/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class TransformingVertexBuilder
implements VertexConsumer {
    private final VertexConsumer base;
    private final PoseStack transform;
    private final List<ObjectWithGlobal<?>> allObjects = new ArrayList();
    private final ObjectWithGlobal<Vec2> uv = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vec3> pos = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vec2i> overlay = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vec2i> lightmap = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vector3f> normal = new ObjectWithGlobal(this);
    private final ObjectWithGlobal<Vector4f> color = new ObjectWithGlobal(this);
    private final VertexFormat format;

    public TransformingVertexBuilder(VertexConsumer base, PoseStack transform, VertexFormat format) {
        this.base = base;
        this.transform = transform;
        this.format = format;
    }

    public TransformingVertexBuilder(VertexConsumer base, VertexFormat format) {
        this(base, new PoseStack(), format);
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type, PoseStack transform) {
        this(buffer.getBuffer(type), transform, type.format());
    }

    public TransformingVertexBuilder(MultiBufferSource buffer, RenderType type) {
        this(buffer, type, new PoseStack());
    }

    @Nonnull
    public VertexConsumer vertex(double x, double y, double z) {
        this.pos.putData(new Vec3(x, y, z));
        return this;
    }

    @Nonnull
    public VertexConsumer color(int red, int green, int blue, int alpha) {
        this.color.putData(new Vector4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f));
        return this;
    }

    @Nonnull
    public VertexConsumer uv(float u, float v) {
        this.uv.putData(new Vec2(u, v));
        return this;
    }

    @Nonnull
    public VertexConsumer overlayCoords(int u, int v) {
        this.overlay.putData(new Vec2i(u, v));
        return this;
    }

    @Nonnull
    public VertexConsumer uv2(int u, int v) {
        this.lightmap.putData(new Vec2i(u, v));
        return this;
    }

    @Nonnull
    public VertexConsumer normal(float x, float y, float z) {
        this.normal.putData(new Vector3f(x, y, z));
        return this;
    }

    public void endVertex() {
        for (VertexFormatElement element : this.format.getElements()) {
            if (element == DefaultVertexFormat.ELEMENT_POSITION) {
                this.pos.ifPresent(pos -> this.base.vertex(this.transform.last().pose(), (float)pos.x, (float)pos.y, (float)pos.z));
                continue;
            }
            if (element == DefaultVertexFormat.ELEMENT_COLOR) {
                this.color.ifPresent(c -> this.base.color(c.x(), c.y(), c.z(), c.w()));
                continue;
            }
            if (element == DefaultVertexFormat.ELEMENT_UV0) {
                this.uv.ifPresent(uv -> this.base.uv(uv.x, uv.y));
                continue;
            }
            if (element == DefaultVertexFormat.ELEMENT_UV1) {
                this.overlay.ifPresent(overlay -> this.base.overlayCoords(overlay.x, overlay.y));
                continue;
            }
            if (element == DefaultVertexFormat.ELEMENT_UV2) {
                this.lightmap.ifPresent(lightmap -> this.base.uv2(lightmap.x, lightmap.y));
                continue;
            }
            if (element != DefaultVertexFormat.ELEMENT_NORMAL) continue;
            this.normal.ifPresent(normal -> this.base.normal(this.transform.last().normal(), normal.x(), normal.y(), normal.z()));
        }
        this.base.endVertex();
        this.allObjects.forEach(ObjectWithGlobal::clear);
    }

    public void defaultColor(float r, float g, float b, float a) {
        this.color.setGlobal(new Vector4f(r, g, b, a));
    }

    public void defaultColor(int r, int g, int b, int a) {
        this.defaultColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public void unsetDefaultColor() {
        this.color.setGlobal(null);
    }

    public void setUV(Vec2 uv) {
        this.uv.setGlobal(uv);
    }

    public void setLight(int light) {
        this.lightmap.setGlobal(new Vec2i(light & 0xFF, light >> 16));
    }

    public void setNormal(float x, float y, float z) {
        Vector3f vec = new Vector3f(x, y, z);
        vec.normalize();
        this.normal.setGlobal(vec);
    }

    public void setOverlay(int packedOverlayIn) {
        this.overlay.setGlobal(new Vec2i(packedOverlayIn & 0xFFFF, packedOverlayIn >> 16));
    }

    private static class ObjectWithGlobal<T> {
        @Nullable
        private T obj;
        private boolean isGlobal;

        public ObjectWithGlobal(TransformingVertexBuilder builder) {
            builder.allObjects.add(this);
        }

        public void putData(T newVal) {
            Preconditions.checkState((this.obj == null || this.isGlobal && this.obj.equals(newVal) ? 1 : 0) != 0);
            this.obj = newVal;
        }

        public void setGlobal(@Nullable T obj) {
            this.obj = obj;
            this.isGlobal = obj != null;
        }

        public T read() {
            Object ret = Preconditions.checkNotNull(this.obj);
            if (!this.isGlobal) {
                this.obj = null;
            }
            return (T)ret;
        }

        public boolean hasValue() {
            return this.obj != null;
        }

        public void ifPresent(Consumer<T> out) {
            if (this.hasValue()) {
                out.accept(this.read());
            }
        }

        public void clear() {
            if (!this.isGlobal) {
                this.obj = null;
            }
        }
    }

    private record Vec2i(int x, int y) {
    }
}

