/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class IESaveData
extends SavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";

    public IESaveData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IESaveData(CompoundTag nbt) {
        this();
        int i;
        ListTag dimensionList = nbt.getList("mineralVeins", 10);
        Multimap<ResourceKey<Level>, MineralVein> multimap = ExcavatorHandler.getMineralVeinList();
        synchronized (multimap) {
            ExcavatorHandler.getMineralVeinList().clear();
            for (i = 0; i < dimensionList.size(); ++i) {
                CompoundTag dimTag = dimensionList.getCompound(i);
                ResourceLocation rl = new ResourceLocation(dimTag.getString("dimension"));
                ResourceKey dimensionType = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rl);
                ListTag mineralList = dimTag.getList("veins", 10);
                ExcavatorHandler.getMineralVeinList().putAll((Object)dimensionType, (Iterable)mineralList.stream().map(inbt -> MineralVein.readFromNBT((CompoundTag)inbt)).collect(Collectors.toList()));
            }
            ExcavatorHandler.resetCache();
        }
        ListTag receivedShaderList = nbt.getList("receivedShaderList", 10);
        for (i = 0; i < receivedShaderList.size(); ++i) {
            CompoundTag tag = receivedShaderList.getCompound(i);
            UUID player = tag.getUUID("player");
            ShaderRegistry.receivedShaders.get((Object)player).clear();
            ListTag playerReceived = tag.getList("received", 8);
            for (int j = 0; j < playerReceived.size(); ++j) {
                String s = playerReceived.getString(j);
                if (s.isEmpty()) continue;
                ShaderRegistry.receivedShaders.put((Object)player, (Object)new ResourceLocation(s));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag nbt) {
        ListTag dimensionList = new ListTag();
        Multimap<ResourceKey<Level>, MineralVein> multimap = ExcavatorHandler.getMineralVeinList();
        synchronized (multimap) {
            for (ResourceKey dimension : ExcavatorHandler.getMineralVeinList().keySet()) {
                CompoundTag dimTag = new CompoundTag();
                dimTag.putString("dimension", dimension.location().toString());
                ListTag mineralList = new ListTag();
                for (MineralVein mineralVein : ExcavatorHandler.getMineralVeinList().get((Object)dimension)) {
                    mineralList.add((Object)mineralVein.writeToNBT());
                }
                dimTag.put("veins", (Tag)mineralList);
                dimensionList.add((Object)dimTag);
            }
        }
        nbt.put("mineralVeins", (Tag)dimensionList);
        ListTag receivedShaderList = new ListTag();
        for (UUID player : ShaderRegistry.receivedShaders.keySet()) {
            CompoundTag tag = new CompoundTag();
            tag.putUUID("player", player);
            ListTag playerReceived = new ListTag();
            for (ResourceLocation shader : ShaderRegistry.receivedShaders.get((Object)player)) {
                if (shader == null) continue;
                playerReceived.add((Object)StringTag.valueOf((String)shader.toString()));
            }
            tag.put("received", (Tag)playerReceived);
            receivedShaderList.add((Object)tag);
        }
        nbt.put("receivedShaderList", (Tag)receivedShaderList);
        return nbt;
    }

    public static void markInstanceDirty() {
        if (INSTANCE != null) {
            INSTANCE.setDirty();
        }
    }

    public static void setInstance(IESaveData in) {
        INSTANCE = in;
    }
}

