/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.blocks.cloth.BalloonBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ChargingStationBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ChuteBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.DynamoBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ElectromagnetBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPlacerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPumpBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FurnaceHeaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalBarrelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.PipeValveBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ThermoelectricGenBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.CraftingTableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.FluidSorterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.LogicUnitBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.MachineInterfaceBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenBarrelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.VanillaFurnaceHeater;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="immersiveengineering")
public class BlockCapabilityRegistration {
    @SubscribeEvent
    public static void registerBlockCapabilities(RegisterCapabilitiesEvent event) {
        BalloonBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.BALLOON));
        ShaderBannerBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.SHADER_BANNER));
        BlastFurnacePreheaterBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.BLASTFURNACE_PREHEATER));
        CapacitorBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CAPACITOR_LV));
        CapacitorBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CAPACITOR_MV));
        CapacitorBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CAPACITOR_HV));
        CapacitorBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CAPACITOR_CREATIVE));
        ChargingStationBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CHARGING_STATION));
        ChuteBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CHUTE));
        ClocheBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CLOCHE));
        for (Supplier<BlockEntityType<?>> beType : ConveyorBeltBlockEntity.BE_TYPES.values()) {
            ConveyorBeltBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, () -> (BlockEntityType)beType.get()));
        }
        DynamoBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.DYNAMO));
        ElectromagnetBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.ELECTROMAGNET));
        EnergyConnectorBlockEntity.registerCapabilities(event);
        FluidPipeBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.FLUID_PIPE));
        FluidPumpBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.FLUID_PUMP));
        FluidPlacerBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.FLUID_PLACER));
        FurnaceHeaterBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.FURNACE_HEATER));
        MetalBarrelBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.METAL_BARREL));
        SampleDrillBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.SAMPLE_DRILL));
        TeslaCoilBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.TESLACOIL));
        ThermoelectricGenBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.THERMOELECTRIC_GEN));
        TurretChemBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.TURRET_CHEM));
        TurretGunBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.TURRET_GUN));
        PipeValveBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.PIPE_VALVE));
        CircuitTableBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CIRCUIT_TABLE));
        CraftingTableBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.CRAFTING_TABLE));
        FluidSorterBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.FLUID_SORTER));
        ItemBatcherBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.ITEM_BATCHER));
        LogicUnitBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.LOGIC_UNIT));
        MachineInterfaceBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.MACHINE_INTERFACE));
        SorterBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.SORTER));
        WoodenBarrelBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.WOODEN_BARREL));
        WoodenCrateBlockEntity.registerCapabilities(BlockCapabilityRegistration.forType(event, IEBlockEntities.WOODEN_CRATE));
        event.registerBlockEntity(ExternalHeaterHandler.CAPABILITY, BlockEntityType.FURNACE, (be, side) -> new VanillaFurnaceHeater((FurnaceBlockEntity)be));
    }

    private static <BE extends BlockEntity> BECapabilityRegistrar<BE> forType(final RegisterCapabilitiesEvent ev, final Supplier<BlockEntityType<BE>> type) {
        return new BECapabilityRegistrar<BE>(){

            @Override
            public <C, T> void register(BlockCapability<T, C> capability, ICapabilityProvider<? super BE, C, T> provider) {
                ev.registerBlockEntity(capability, (BlockEntityType)type.get(), provider);
            }
        };
    }

    private static <BE extends BlockEntity> BECapabilityRegistrar<BE> forType(final RegisterCapabilitiesEvent ev, final MultiblockBEType<BE> type) {
        return new BECapabilityRegistrar<BE>(){

            @Override
            public <C, T> void register(BlockCapability<T, C> capability, ICapabilityProvider<? super BE, C, T> provider) {
                ev.registerBlockEntity(capability, type.dummy(), provider);
                ev.registerBlockEntity(capability, type.master(), provider);
            }
        };
    }

    public static interface BECapabilityRegistrar<BE> {
        public <C, T> void register(BlockCapability<T, C> var1, ICapabilityProvider<? super BE, C, T> var2);

        default public <C, T> void registerOnContext(BlockCapability<T, C> capability, Function<? super BE, T> getValue, C onContext) {
            this.register(capability, (be, ctx) -> Objects.equals(onContext, ctx) ? getValue.apply((Object)be) : null);
        }

        default public <T> void registerAllContexts(BlockCapability<T, ?> capability, Function<? super BE, T> getValue) {
            this.register(capability, (be, ctx) -> getValue.apply((Object)be));
        }
    }
}

