/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BlockIESlab<T extends Block>
extends SlabBlock
implements IIEBlock {
    private final Supplier<T> base;

    public BlockIESlab(BlockBehaviour.Properties props, Supplier<T> base) {
        super(props.isSuffocating(BlockIESlab.causesSuffocation(base)).isRedstoneConductor(BlockIESlab.isNormalCube(base)));
        this.base = base;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, @Nullable LivingEntity entity) {
        if (entity == null) {
            return true;
        }
        double relativeEntityPosition = entity.position().y() - (double)pos.getY();
        switch ((SlabType)state.getValue((Property)SlabBlock.TYPE)) {
            case TOP: {
                return 0.5 < relativeEntityPosition && relativeEntityPosition < 1.0;
            }
            case BOTTOM: {
                return 0.0 < relativeEntityPosition && relativeEntityPosition < 0.5;
            }
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasFlavour() {
        return ((IIEBlock)((Block)this.base.get())).hasFlavour();
    }

    @Override
    public String getNameForFlavour() {
        return ((IIEBlock)((Block)this.base.get())).getNameForFlavour();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Math.min(((Block)this.base.get()).getLightBlock(state, worldIn, pos), super.getLightBlock(state, worldIn, pos));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return super.propagatesSkylightDown(state, reader, pos) || ((Block)this.base.get()).propagatesSkylightDown(state, reader, pos);
    }

    public static BlockBehaviour.StatePredicate causesSuffocation(Supplier<? extends Block> base) {
        return (state, world, pos) -> ((Block)base.get()).defaultBlockState().isSuffocating(world, pos) && state.getValue((Property)TYPE) == SlabType.DOUBLE;
    }

    public static BlockBehaviour.StatePredicate isNormalCube(Supplier<? extends Block> base) {
        return (state, world, pos) -> ((Block)base.get()).defaultBlockState().isRedstoneConductor(world, pos) && state.getValue((Property)TYPE) == SlabType.DOUBLE;
    }
}

