/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FloodlightBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.SpawnInterdictionHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FakeLightBlock
extends IEEntityBlock<FakeLightBlockEntity> {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().replaceable().air().noOcclusion().pushReaction(PushReaction.DESTROY).lightLevel(b -> 15);

    public FakeLightBlock(BlockBehaviour.Properties props) {
        super(IEBlockEntities.FAKE_LIGHT, props);
    }

    public boolean isAir(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @Override
    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return true;
    }

    public static class FakeLightBlockEntity
    extends IEBaseBlockEntity
    implements IEBlockInterfaces.ISpawnInterdiction {
        public BlockPos floodlightCoords = null;

        public FakeLightBlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType)IEBlockEntities.FAKE_LIGHT.get(), pos, state);
        }

        @Override
        public double getInterdictionRangeSquared() {
            return 1024.0;
        }

        @Override
        public void setRemovedIE() {
            SpawnInterdictionHandler.removeFromInterdictionTiles(this);
            super.setRemovedIE();
        }

        @Override
        public void onChunkUnloaded() {
            SpawnInterdictionHandler.removeFromInterdictionTiles(this);
            super.onChunkUnloaded();
        }

        @Override
        public void onLoad() {
            FloodlightBlockEntity floodlight;
            BlockEntity blockEntity;
            super.onLoad();
            if (this.floodlightCoords == null || !((blockEntity = Utils.getExistingTileEntity(this.level, this.floodlightCoords)) instanceof FloodlightBlockEntity) || !(floodlight = (FloodlightBlockEntity)blockEntity).getIsActive()) {
                this.level.removeBlock(this.getBlockPos(), false);
            }
            SpawnInterdictionHandler.addInterdictionTile(this);
        }

        @Override
        public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
            this.floodlightCoords = nbt.contains("floodlightCoords", 10) ? NbtUtils.readBlockPos((CompoundTag)nbt.getCompound("floodlightCoords")) : null;
        }

        @Override
        public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
            if (this.floodlightCoords != null) {
                nbt.put("floodlightCoords", (Tag)NbtUtils.writeBlockPos((BlockPos)this.floodlightCoords));
            }
        }
    }
}

