/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ScheduledTick;

public class IEBaseBlock
extends Block
implements IIEBlock,
SimpleWaterloggedBlock {
    boolean isHidden;
    boolean hasFlavour;
    protected int lightOpacity;
    protected final boolean notNormalBlock;
    private final boolean fitsIntoContainer;

    public IEBaseBlock(BlockBehaviour.Properties blockProps) {
        this(blockProps, true);
    }

    public IEBaseBlock(BlockBehaviour.Properties blockProps, boolean fitsIntoContainer) {
        super(blockProps);
        this.fitsIntoContainer = fitsIntoContainer;
        this.notNormalBlock = !this.defaultBlockState().canOcclude();
        this.registerDefaultState(this.getInitDefaultState());
        this.lightOpacity = -1;
    }

    public IEBaseBlock setHidden(boolean shouldHide) {
        this.isHidden = shouldHide;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public IEBaseBlock setHasFlavour(boolean shouldHave) {
        this.hasFlavour = shouldHave;
        return this;
    }

    @Override
    public String getNameForFlavour() {
        return BuiltInRegistries.BLOCK.getKey((Object)this).getPath();
    }

    @Override
    public boolean hasFlavour() {
        return this.hasFlavour;
    }

    public IEBaseBlock setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
        return this;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (this.lightOpacity != -1) {
            return this.lightOpacity;
        }
        if (this.notNormalBlock) {
            return 0;
        }
        return super.getLightBlock(state, worldIn, pos);
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return this.notNormalBlock ? 1.0f : super.getShadeBrightness(state, world, pos);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.notNormalBlock || super.propagatesSkylightDown(state, reader, pos);
    }

    protected BlockState getInitDefaultState() {
        BlockState state = (BlockState)this.stateDefinition.any();
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        return state;
    }

    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
    }

    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        return true;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    public void fillCreativeTab(CreativeModeTab.Output out) {
        out.accept((ItemLike)this);
    }

    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.isClientSide && eventID == 255) {
            worldIn.sendBlockUpdated(pos, state, state, 3);
            return true;
        }
        return super.triggerEvent(state, worldIn, pos, eventID, eventParam);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack activeStack = player.getItemInHand(hand);
        if (activeStack.is(IETags.hammers)) {
            return this.hammerUseSide(hit.getDirection(), player, hand, world, pos, hit);
        }
        if (activeStack.is(IETags.screwdrivers)) {
            return this.screwdriverUseSide(hit.getDirection(), player, hand, world, pos, hit);
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static BlockState applyLocationalWaterlogging(BlockState state, Level world, BlockPos pos) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        state = IEBaseBlock.applyLocationalWaterlogging(state, context.getLevel(), context.getClickedPos());
        return state;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)stateIn.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            worldIn.getFluidTicks().schedule(new ScheduledTick((Object)Fluids.WATER, currentPos, (long)Fluids.WATER.getTickDelay((LevelReader)worldIn), 0L));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        if (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return false;
        }
        return super.canPlaceLiquid(player, worldIn, pos, state, fluidIn);
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && super.placeLiquid(worldIn, pos, state, fluidStateIn);
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return super.pickupBlock(player, level, pos, state);
        }
        return ItemStack.EMPTY;
    }

    public boolean fitsIntoContainer() {
        return this.fitsIntoContainer;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.getValue(facingProp);
            Direction newDirection = rot.rotate(currentDirection);
            return (BlockState)state.setValue(facingProp, (Comparable)newDirection);
        }
        return super.rotate(state, rot);
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (state.hasProperty((Property)IEProperties.MIRRORED) && this.canRotate() && mirrorIn == Mirror.LEFT_RIGHT) {
            return (BlockState)state.setValue((Property)IEProperties.MIRRORED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)IEProperties.MIRRORED) == false));
        }
        Property<Direction> facingProp = this.findFacingProperty(state);
        if (facingProp != null && this.canRotate()) {
            Direction currentDirection = (Direction)state.getValue(facingProp);
            Direction newDirection = mirrorIn.mirror(currentDirection);
            return (BlockState)state.setValue(facingProp, (Comparable)newDirection);
        }
        return super.mirror(state, mirrorIn);
    }

    @Nullable
    private Property<Direction> findFacingProperty(BlockState state) {
        if (state.hasProperty((Property)IEProperties.FACING_ALL)) {
            return IEProperties.FACING_ALL;
        }
        if (state.hasProperty((Property)IEProperties.FACING_HORIZONTAL)) {
            return IEProperties.FACING_HORIZONTAL;
        }
        return null;
    }

    protected boolean canRotate() {
        return !this.getStateDefinition().getProperties().contains(IEProperties.MULTIBLOCKSLAVE);
    }

    public static abstract class IELadderBlock
    extends IEBaseBlock {
        public IELadderBlock(BlockBehaviour.Properties material) {
            super(material);
        }

        public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, @Nullable LivingEntity entity) {
            return true;
        }

        public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
            super.entityInside(state, worldIn, pos, entityIn);
            if (entityIn instanceof LivingEntity && this.isLadder(state, (LevelReader)worldIn, pos, (LivingEntity)entityIn)) {
                IELadderBlock.applyLadderLogic(entityIn);
            }
        }

        public static void applyLadderLogic(Entity entityIn) {
            if (entityIn instanceof LivingEntity && !((LivingEntity)entityIn).onClimbable()) {
                Vec3 motion = entityIn.getDeltaMovement();
                float maxMotion = 0.15f;
                motion = new Vec3(Mth.clamp((double)motion.x, (double)(-maxMotion), (double)maxMotion), Math.max(motion.y, (double)(-maxMotion)), Mth.clamp((double)motion.z, (double)(-maxMotion), (double)maxMotion));
                entityIn.fallDistance = 0.0f;
                if (motion.y < 0.0 && entityIn instanceof Player && entityIn.isShiftKeyDown()) {
                    motion = new Vec3(motion.x, 0.0, motion.z);
                } else if (entityIn.horizontalCollision) {
                    motion = new Vec3(motion.x, 0.2, motion.z);
                }
                entityIn.setDeltaMovement(motion);
            }
        }
    }
}

