/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class IEBaseBlockEntity
extends BlockEntity
implements IEBlockInterfaces.BlockstateProvider {
    protected IEBlockInterfaces.IGeneralMultiblock tempMasterBE;
    @Nullable
    private BlockState overrideBlockState = null;
    private final EnumMap<Direction, Integer> redstoneBySide = new EnumMap(Direction.class);
    private boolean isUnloaded = false;

    public IEBaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void load(CompoundTag nbtIn) {
        super.load(nbtIn);
        this.readCustomNBT(nbtIn, false);
    }

    public abstract void readCustomNBT(CompoundTag var1, boolean var2);

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        this.writeCustomNBT(nbt, false);
    }

    public abstract void writeCustomNBT(CompoundTag var1, boolean var2);

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, be -> {
            CompoundTag nbttagcompound = new CompoundTag();
            this.writeCustomNBT(nbttagcompound, true);
            return nbttagcompound;
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nonNullTag = pkt.getTag() != null ? pkt.getTag() : new CompoundTag();
        this.readCustomNBT(nonNullTag, true);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readCustomNBT(tag, true);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = super.getUpdateTag();
        this.writeCustomNBT(nbt, true);
        return nbt;
    }

    public void receiveMessageFromClient(CompoundTag message) {
    }

    public void receiveMessageFromServer(CompoundTag message) {
    }

    public void onEntityCollision(Level world, Entity entity) {
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 0 || id == 255) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (id == 254) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void markContainingBlockForUpdate(@Nullable BlockState newState) {
        if (this.level != null) {
            this.markBlockForUpdate(this.getBlockPos(), newState);
        }
    }

    public void markBlockForUpdate(BlockPos pos, @Nullable BlockState newState) {
        BlockState state = this.level.getBlockState(pos);
        if (newState == null) {
            newState = state;
        }
        this.level.sendBlockUpdated(pos, state, newState, 3);
        this.level.updateNeighborsAt(pos, newState.getBlock());
    }

    protected IEnergyStorage makeEnergyInput(IEnergyStorage directStorage) {
        return new WrappingEnergyStorage(directStorage, true, false, this::setChanged);
    }

    protected IEnergyStorage makeEnergyOutput(IEnergyStorage directStorage) {
        return new WrappingEnergyStorage(directStorage, false, true, this::setChanged);
    }

    private IFluidHandler makeFluidHandler(IFluidTank[] tanks, boolean allowDrain, boolean allowFill) {
        return new ArrayFluidHandler(tanks, allowDrain, allowFill, () -> this.markContainingBlockForUpdate(null));
    }

    protected final IFluidHandler makeFluidHandler(IFluidTank ... tanks) {
        return this.makeFluidHandler(tanks, true, true);
    }

    protected final IFluidHandler makeFluidInput(IFluidTank ... tanks) {
        return this.makeFluidHandler(tanks, false, true);
    }

    protected final IFluidHandler registerFluidOutput(IFluidTank ... tanks) {
        return this.makeFluidHandler(tanks, true, false);
    }

    protected final IFluidHandler registerFluidView(IFluidTank ... tanks) {
        return this.makeFluidHandler(tanks, false, false);
    }

    public final void setRemoved() {
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        super.setRemoved();
    }

    public void onLoad() {
        super.onLoad();
        this.isUnloaded = false;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.isUnloaded = true;
    }

    public void setRemovedIE() {
    }

    @Nonnull
    public Level getLevelNonnull() {
        return Objects.requireNonNull(super.getLevel());
    }

    protected void checkLight() {
        this.checkLight(this.worldPosition);
    }

    protected void checkLight(BlockPos pos) {
        this.getLevelNonnull().getBlockTicks().schedule(new ScheduledTick((Object)this.getBlockState().getBlock(), pos, 4L, 0L));
    }

    public void setOverrideState(@Nullable BlockState state) {
        this.overrideBlockState = state;
    }

    public BlockState getBlockState() {
        if (this.overrideBlockState != null) {
            return this.overrideBlockState;
        }
        return super.getBlockState();
    }

    @Deprecated
    public void setBlockState(BlockState newState) {
        BlockState old = this.getBlockState();
        super.setBlockState(newState);
        if (this.getType().isValid(old) && !this.getType().isValid(newState)) {
            this.setOverrideState(old);
        } else if (this.getType().isValid(newState)) {
            this.setOverrideState(null);
        }
        this.invalidateCapabilities();
    }

    @Override
    public void setState(BlockState state) {
        if (this.getLevelNonnull().getBlockState(this.worldPosition) == this.getState()) {
            this.getLevelNonnull().setBlockAndUpdate(this.worldPosition, state);
        }
    }

    @Override
    public BlockState getState() {
        return this.getBlockState();
    }

    protected void markChunkDirty() {
        if (this.level != null && this.level.hasChunkAt(this.worldPosition)) {
            this.level.getChunkAt(this.worldPosition).setUnsaved(true);
        }
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        this.redstoneBySide.clear();
    }

    public void setChanged() {
        if (this.level != null) {
            this.markChunkDirty();
            BlockState state = this.getBlockState();
            if (state.hasAnalogOutputSignal()) {
                this.level.updateNeighbourForOutputSignal(this.worldPosition, state.getBlock());
            }
        }
    }

    protected void onNeighborBlockChange(BlockPos otherPos) {
        BlockPos delta = otherPos.subtract((Vec3i)this.worldPosition);
        Direction side = Direction.getNearest((float)delta.getX(), (float)delta.getY(), (float)delta.getZ());
        Preconditions.checkNotNull((Object)side);
        this.updateRSForSide(side);
    }

    private void updateRSForSide(Direction side) {
        BlockState state;
        int rsStrength = this.getLevelNonnull().getSignal(this.worldPosition.relative(side), side);
        if (rsStrength == 0 && this instanceof IEBlockInterfaces.IRedstoneOutput && ((IEBlockInterfaces.IRedstoneOutput)((Object)this)).canConnectRedstone(side) && (state = SafeChunkUtils.getBlockState((LevelAccessor)this.level, this.worldPosition.relative(side))).getBlock() == Blocks.REDSTONE_WIRE && (Integer)state.getValue((Property)RedStoneWireBlock.POWER) > rsStrength) {
            rsStrength = (Integer)state.getValue((Property)RedStoneWireBlock.POWER);
        }
        this.redstoneBySide.put(side, rsStrength);
    }

    protected int getRSInput(Direction from) {
        if (this.level.isClientSide || !this.redstoneBySide.containsKey(from)) {
            this.updateRSForSide(from);
        }
        return this.redstoneBySide.get(from);
    }

    protected int getMaxRSInput() {
        int ret = 0;
        for (Direction d : DirectionUtils.VALUES) {
            ret = Math.max(ret, this.getRSInput(d));
        }
        return ret;
    }

    protected boolean isRSPowered() {
        for (Direction d : DirectionUtils.VALUES) {
            if (this.getRSInput(d) <= 0) continue;
            return true;
        }
        return false;
    }
}

