/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class IEDoorBlock
extends DoorBlock {
    public static BlockSetType TREATED_WOOD = new BlockSetType("treated_wood");
    public static BlockSetType STEEL = new BlockSetType("steel", true, false, false, BlockSetType.PressurePlateSensitivity.MOBS, SoundType.METAL, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.METAL_PRESSURE_PLATE_CLICK_OFF, SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON);
    private boolean lockedByRedstone = false;

    public IEDoorBlock(BlockSetType blockSetType, BlockBehaviour.Properties properties) {
        super(blockSetType, properties);
    }

    public IEDoorBlock setLockedByRedstone() {
        this.lockedByRedstone = true;
        return this;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (this.lockedByRedstone) {
            return (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public InteractionResult use(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.lockedByRedstone && ((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            level.playSound(player, pos, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.BLOCKS, 0.25f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            return InteractionResult.CONSUME_PARTIAL;
        }
        return super.use(blockState, level, pos, player, hand, hitResult);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.lockedByRedstone) {
            boolean flag;
            boolean bl = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.relative(blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
            if (!this.defaultBlockState().is(block) && flag != (Boolean)blockState.getValue((Property)POWERED)) {
                level.setBlock(pos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            }
        } else {
            super.neighborChanged(blockState, level, pos, block, fromPos, isMoving);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob.goalSelector.getRunningGoals().anyMatch(wrappedGoal -> wrappedGoal.getGoal() instanceof BreakDoorGoal)) {
                return this.type() != STEEL;
            }
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }
}

