/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.gui.IEBaseContainerOld;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IEEntityBlock<T extends BlockEntity>
extends IEBaseBlock
implements IEBlockInterfaces.IColouredBlock,
EntityBlock {
    private boolean hasColours = false;
    private final BiFunction<BlockPos, BlockState, T> makeEntity;
    private BEClassInspectedData classData;
    private static final List<BooleanProperty> DEFAULT_OFF = ImmutableList.of((Object)IEProperties.MULTIBLOCKSLAVE, (Object)IEProperties.ACTIVE, (Object)IEProperties.MIRRORED, (Object)IEProperties.UP, (Object)IEProperties.DOWN, (Object)IEProperties.NORTH, (Object)IEProperties.SOUTH, (Object)IEProperties.WEST, (Object)IEProperties.EAST);

    public IEEntityBlock(BiFunction<BlockPos, BlockState, T> makeEntity, BlockBehaviour.Properties blockProps) {
        this(makeEntity, blockProps, true);
    }

    public IEEntityBlock(BiFunction<BlockPos, BlockState, T> makeEntity, BlockBehaviour.Properties blockProps, boolean fitsIntoContainer) {
        super(blockProps, fitsIntoContainer);
        this.makeEntity = makeEntity;
    }

    public IEEntityBlock(Supplier<BlockEntityType<T>> tileType, BlockBehaviour.Properties blockProps) {
        this(tileType, blockProps, true);
    }

    public IEEntityBlock(Supplier<BlockEntityType<T>> tileType, BlockBehaviour.Properties blockProps, boolean fitsIntoContainer) {
        this((BlockPos bp, BlockState state) -> ((BlockEntityType)tileType.get()).create(bp, state), blockProps, fitsIntoContainer);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return (BlockEntity)this.makeEntity.apply(pPos, pState);
    }

    @Nullable
    public <T2 extends BlockEntity> BlockEntityTicker<T2> getTicker(Level world, BlockState state, BlockEntityType<T2> type) {
        MultiblockBEType multiBEType;
        BlockEntityTicker baseTicker = this.getClassData().makeBaseTicker(world.isClientSide);
        BiFunction<BlockPos, BlockState, T> biFunction = this.makeEntity;
        if (biFunction instanceof MultiblockBEType && type != (multiBEType = (MultiblockBEType)biFunction).master()) {
            return null;
        }
        return baseTicker;
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        if (ret.hasProperty((Property)IEProperties.FACING_ALL)) {
            ret = (BlockState)ret.setValue((Property)IEProperties.FACING_ALL, (Comparable)this.getDefaultFacing());
        } else if (ret.hasProperty((Property)IEProperties.FACING_HORIZONTAL)) {
            ret = (BlockState)ret.setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)this.getDefaultFacing());
        }
        for (BooleanProperty defaultOff : DEFAULT_OFF) {
            if (!ret.hasProperty((Property)defaultOff)) continue;
            ret = (BlockState)ret.setValue((Property)defaultOff, (Comparable)Boolean.valueOf(false));
        }
        return ret;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (state.getBlock() != newState.getBlock()) {
            if (tile instanceof IEBaseBlockEntity) {
                ((IEBaseBlockEntity)tile).setOverrideState(state);
            }
            if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
                ((IEBlockInterfaces.IHasDummyBlocks)tile).breakDummies(pos, state);
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, BlockEntity tile, ItemStack stack) {
        Collection<ItemStack> stacks;
        if (tile instanceof IEBlockInterfaces.IAdditionalDrops && (stacks = ((IEBlockInterfaces.IAdditionalDrops)tile).getExtraDrops(player, state)) != null && !stacks.isEmpty()) {
            for (ItemStack s : stacks) {
                if (s.isEmpty()) continue;
                IEEntityBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)s);
            }
        }
        super.playerDestroy(world, player, pos, state, tile, stack);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IEntityProof) {
            return ((IEBlockInterfaces.IEntityProof)tile).canEntityDestroy(entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        ItemStack s;
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IBlockEntityDrop && target instanceof BlockHitResult && !(s = ((IEBlockInterfaces.IBlockEntityDrop)tile).getPickBlock(player, world.getBlockState(pos), target)).isEmpty()) {
            return s;
        }
        Item item = this.asItem();
        return item == Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)item, 1);
    }

    @Override
    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, worldIn, pos, eventID, eventParam);
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        return tileentity != null && tileentity.triggerEvent(eventID, eventParam);
    }

    protected Direction getDefaultFacing() {
        return Direction.NORTH;
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity tile = world.getBlockEntity(pos);
        Player placer = context.getPlayer();
        Direction side = context.getClickedFace();
        float hitX = (float)context.getClickLocation().x - (float)pos.getX();
        float hitY = (float)context.getClickLocation().y - (float)pos.getY();
        float hitZ = (float)context.getClickLocation().z - (float)pos.getZ();
        if (tile instanceof IEBlockInterfaces.IDirectionalBE) {
            IEBlockInterfaces.IDirectionalBE directionalBE = (IEBlockInterfaces.IDirectionalBE)tile;
            Direction f = directionalBE.getFacingForPlacement(context);
            directionalBE.setFacing(f);
            if (tile instanceof IEBlockInterfaces.IAdvancedDirectionalBE) {
                IEBlockInterfaces.IAdvancedDirectionalBE advDirectional = (IEBlockInterfaces.IAdvancedDirectionalBE)tile;
                advDirectional.onDirectionalPlacement(side, hitX, hitY, hitZ, (LivingEntity)placer);
            }
        }
        if (tile instanceof IEBlockInterfaces.IHasDummyBlocks) {
            IEBlockInterfaces.IHasDummyBlocks hasDummyBlocks = (IEBlockInterfaces.IHasDummyBlocks)tile;
            hasDummyBlocks.placeDummies(context, state);
        }
        if (tile instanceof IEBlockInterfaces.IPlacementInteraction) {
            IEBlockInterfaces.IPlacementInteraction placementInteractionBE = (IEBlockInterfaces.IPlacementInteraction)tile;
            placementInteractionBE.onBEPlaced(context);
        }
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        BlockEntity tile = w.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IHammerInteraction) {
            boolean b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hand, hit.getLocation());
            if (b) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.hammerUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        InteractionResult teResult;
        BlockEntity tile = w.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IScrewdriverInteraction && (teResult = ((IEBlockInterfaces.IScrewdriverInteraction)tile).screwdriverUseSide(side, player, hand, hit.getLocation())) != InteractionResult.PASS) {
            return teResult;
        }
        return super.screwdriverUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IEBlockInterfaces.IPlayerInteraction interaction;
        InteractionResult res;
        InteractionResult superResult = super.use(state, world, pos, player, hand, hit);
        if (superResult.consumesAction()) {
            return superResult;
        }
        Direction side = hit.getDirection();
        float hitX = (float)hit.getLocation().x - (float)pos.getX();
        float hitY = (float)hit.getLocation().y - (float)pos.getY();
        float hitZ = (float)hit.getLocation().z - (float)pos.getZ();
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IDirectionalBE && Utils.isHammer(heldItem) && ((IEBlockInterfaces.IDirectionalBE)tile).canHammerRotate(side, hit.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos)), (LivingEntity)player) && !world.isClientSide) {
            Direction f;
            Direction oldF = f = ((IEBlockInterfaces.IDirectionalBE)tile).getFacing();
            PlacementLimitation limit = ((IEBlockInterfaces.IDirectionalBE)tile).getFacingLimitation();
            switch (limit) {
                case SIDE_CLICKED: {
                    f = DirectionUtils.VALUES[Math.floorMod(f.ordinal() + (player.isShiftKeyDown() ? -1 : 1), DirectionUtils.VALUES.length)];
                    break;
                }
                case PISTON_LIKE: {
                    f = player.isShiftKeyDown() != (side.getAxisDirection() == Direction.AxisDirection.NEGATIVE) ? DirectionUtils.rotateAround(f, side.getAxis()).getOpposite() : DirectionUtils.rotateAround(f, side.getAxis());
                    break;
                }
                case HORIZONTAL: 
                case HORIZONTAL_PREFER_SIDE: 
                case HORIZONTAL_QUADRANT: 
                case HORIZONTAL_AXIS: {
                    f = player.isShiftKeyDown() != side.equals((Object)Direction.DOWN) ? f.getCounterClockWise() : f.getClockWise();
                }
            }
            ((IEBlockInterfaces.IDirectionalBE)tile).setFacing(f);
            ((IEBlockInterfaces.IDirectionalBE)tile).afterRotation(oldF, f);
            tile.setChanged();
            world.sendBlockUpdated(pos, state, state, 3);
            world.blockEvent(tile.getBlockPos(), tile.getBlockState().getBlock(), 255, 0);
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof IEBlockInterfaces.IPlayerInteraction && ((res = (interaction = (IEBlockInterfaces.IPlayerInteraction)tile).interact(side, player, hand, heldItem, hitX, hitY, hitZ)).consumesAction() || res == InteractionResult.FAIL)) {
            return res;
        }
        if (tile instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)tile;
            if (hand == InteractionHand.MAIN_HAND && !player.isShiftKeyDown()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (menuProvider instanceof IEBlockInterfaces.IInteractionObjectIE) {
                        IEBlockInterfaces.IInteractionObjectIE interaction2 = (IEBlockInterfaces.IInteractionObjectIE)menuProvider;
                        if ((interaction2 = (IEBlockInterfaces.IInteractionObjectIE)interaction2.getGuiMaster()) != null && interaction2.canUseGui(player)) {
                            AbstractContainerMenu tempMenu = interaction2.createMenu(0, player.getInventory(), player);
                            if (tempMenu instanceof IEBaseContainerOld) {
                                serverPlayer.openMenu((MenuProvider)interaction2, ((BlockEntity)interaction2).getBlockPos());
                            } else {
                                serverPlayer.openMenu((MenuProvider)interaction2);
                            }
                        }
                    } else {
                        serverPlayer.openMenu(menuProvider);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return superResult;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity tile;
        if (!world.isClientSide && (tile = world.getBlockEntity(pos)) instanceof IEBaseBlockEntity) {
            ((IEBaseBlockEntity)tile).onNeighborBlockChange(fromPos);
        }
    }

    public IEEntityBlock setHasColours() {
        this.hasColours = true;
        return this;
    }

    @Override
    public boolean hasCustomBlockColours() {
        return this.hasColours;
    }

    @Override
    public int getRenderColour(BlockState state, @Nullable BlockGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity tile;
        if (worldIn != null && pos != null && (tile = worldIn.getBlockEntity(pos)) instanceof IEBlockInterfaces.IColouredBE) {
            return ((IEBlockInterfaces.IColouredBE)tile).getRenderColour(tintIndex);
        }
        return 0xFFFFFF;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity te;
        if (state.getBlock() == this && (te = world.getBlockEntity(pos)) instanceof IEBlockInterfaces.ISelectionBounds) {
            return ((IEBlockInterfaces.ISelectionBounds)te).getSelectionShape(context);
        }
        return super.getShape(state, world, pos, context);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.getClassData().customCollisionBounds()) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof IEBlockInterfaces.ICollisionBounds) {
                IEBlockInterfaces.ICollisionBounds collisionBounds = (IEBlockInterfaces.ICollisionBounds)te;
                return collisionBounds.getCollisionShape(context);
            }
            return Shapes.empty();
        }
        return super.getCollisionShape(state, world, pos, context);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te;
        if (world.getBlockState(pos).getBlock() == this && (te = world.getBlockEntity(pos)) instanceof IEBlockInterfaces.ISelectionBounds) {
            return ((IEBlockInterfaces.ISelectionBounds)te).getSelectionShape(null);
        }
        return super.getInteractionShape(state, world, pos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return this.getClassData().hasComparatorOutput;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IEBlockInterfaces.IComparatorOverride) {
            IEBlockInterfaces.IComparatorOverride compOverride = (IEBlockInterfaces.IComparatorOverride)te;
            return compOverride.getComparatorInputOverride();
        }
        return 0;
    }

    public int getSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            IEBlockInterfaces.IRedstoneOutput rsOutput = (IEBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.getWeakRSOutput(side);
        }
        return 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            IEBlockInterfaces.IRedstoneOutput rsOutput = (IEBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.getStrongRSOutput(side);
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return this.getClassData().emitsRedstone();
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IEBlockInterfaces.IRedstoneOutput) {
            IEBlockInterfaces.IRedstoneOutput rsOutput = (IEBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.canConnectRedstone(side);
        }
        return false;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IEBaseBlockEntity) {
            ((IEBaseBlockEntity)te).onEntityCollision(world, entity);
        }
    }

    public static boolean areAllReplaceable(BlockPos start, BlockPos end, BlockPlaceContext context) {
        Level w = context.getLevel();
        return BlockPos.betweenClosedStream((BlockPos)start, (BlockPos)end).allMatch(pos -> {
            BlockPlaceContext subContext = BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)pos, (Direction)context.getClickedFace());
            return w.getBlockState(pos).canBeReplaced(subContext);
        });
    }

    private BEClassInspectedData getClassData() {
        if (this.classData == null) {
            BlockEntity tempBE = (BlockEntity)this.makeEntity.apply(BlockPos.ZERO, this.getInitDefaultState());
            this.classData = new BEClassInspectedData(tempBE instanceof IEServerTickableBE, tempBE instanceof IEClientTickableBE, tempBE instanceof IEBlockInterfaces.IComparatorOverride, tempBE instanceof IEBlockInterfaces.IRedstoneOutput, tempBE instanceof IEBlockInterfaces.ICollisionBounds);
        }
        return this.classData;
    }

    private record BEClassInspectedData(boolean serverTicking, boolean clientTicking, boolean hasComparatorOutput, boolean emitsRedstone, boolean customCollisionBounds) {
        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> makeBaseTicker(boolean isClient) {
            if (this.serverTicking && !isClient) {
                return IEServerTickableBE.makeTicker();
            }
            if (this.clientTicking && isClient) {
                return IEClientTickableBE.makeTicker();
            }
            return null;
        }
    }
}

