/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.BalloonBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BalloonBlock
extends IEEntityBlock<BalloonBlockEntity> {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).ignitedByLava().sound(SoundType.WOOL).strength(0.8f).lightLevel(s -> 13).noOcclusion();

    public BalloonBlock(BlockBehaviour.Properties props) {
        super(IEBlockEntities.BALLOON, props);
        this.setHasColours();
        this.setLightOpacity(0);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public void fallOn(@Nonnull Level w, @Nonnull BlockState state, @Nonnull BlockPos pos, Entity entity, float fallStrength) {
        entity.fallDistance = 0.0f;
    }

    @Deprecated
    public void onProjectileHit(@Nonnull Level level, @Nonnull BlockState p_60454_, @Nonnull BlockHitResult hitResult, @Nonnull Projectile p_60456_) {
        BalloonBlockEntity balloon;
        ShaderRegistry.ShaderAndCase shader;
        super.onProjectileHit(level, p_60454_, hitResult, p_60456_);
        BlockPos bPos = hitResult.getBlockPos();
        Vec3 pos = Vec3.atCenterOf((Vec3i)bPos);
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIREWORK_ROCKET_BLAST, SoundSource.BLOCKS, 1.5f, 0.7f);
        Runnable shaderEffect = () -> {};
        BlockEntity blockEntity = level.getBlockEntity(bPos);
        if (blockEntity instanceof BalloonBlockEntity && (shader = ShaderRegistry.getStoredShaderAndCase((balloon = (BalloonBlockEntity)blockEntity).getShader())) != null) {
            shaderEffect = () -> shader.registryEntry().getEffectFunction().execute(level, shader.shader(), null, shader.sCase().getShaderType().toString(), pos, Vec3.ZERO, 0.375f);
        }
        level.removeBlock(bPos, false);
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, pos.x, pos.y, pos.z, 0.0, 0.05, 0.0);
        shaderEffect.run();
    }
}

