/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BalloonBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds {
    public int style = 0;
    public DyeColor colour0 = null;
    public DyeColor colour1 = null;
    private CapabilityShader.ShaderWrapper_Direct shader = new CapabilityShader.ShaderWrapper_Direct(new ResourceLocation("immersiveengineering", "balloon"));

    public BalloonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.BALLOON.get(), pos, state);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        int oldStyle = this.style;
        DyeColor oldC0 = this.colour0;
        DyeColor oldC1 = this.colour1;
        this.style = nbt.getInt("style");
        int tmpIdx = nbt.getInt("colour0");
        this.colour0 = tmpIdx >= 0 && tmpIdx < DyeColor.values().length ? DyeColor.byId((int)tmpIdx) : null;
        tmpIdx = nbt.getInt("colour1");
        DyeColor dyeColor = this.colour1 = tmpIdx >= 0 && tmpIdx < DyeColor.values().length ? DyeColor.byId((int)tmpIdx) : null;
        if (oldStyle != this.style || oldC0 != this.colour0 || oldC1 != this.colour1) {
            this.requestModelDataUpdate();
        }
        if (nbt.contains("shader", 10)) {
            this.shader = (CapabilityShader.ShaderWrapper_Direct)CapabilityShader.ShaderWrapper_Direct.SERIALIZER.read((IAttachmentHolder)this, (Tag)nbt.getCompound("shader"));
        }
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void writeCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.putInt("style", this.style);
        nbt.putInt("colour0", this.colour0 != null ? this.colour0.getId() : -1);
        nbt.putInt("colour1", this.colour1 != null ? this.colour1.getId() : -1);
        nbt.put("shader", CapabilityShader.ShaderWrapper_Direct.SERIALIZER.write((Object)this.shader));
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.9375, (double)0.875);
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return super.triggerEvent(id, arg);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<BalloonBlockEntity> registrar) {
        registrar.registerAllContexts(CapabilityShader.BLOCK, be -> be.shader);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "STRUCTURE".equals(cableType.getCategory());
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        double dist;
        BlockPos end = other.position();
        int xDif = end.getX() - this.getBlockPos().getX();
        int zDif = end.getZ() - this.getBlockPos().getZ();
        int yDif = end.getY() - this.getBlockPos().getY();
        if (yDif < 0 && (dist = Math.sqrt(xDif * xDif + zDif * zDif)) / (double)Math.abs(yDif) < 2.5) {
            return new Vec3(0.5, 0.09375, 0.5);
        }
        if (Math.abs(zDif) > Math.abs(xDif)) {
            return new Vec3(0.5, 0.09375, zDif > 0 ? 0.78125 : 0.21875);
        }
        return new Vec3(xDif > 0 ? 0.78125 : 0.21875, 0.09375, 0.5);
    }

    @Override
    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.isShiftKeyDown()) {
            if (!this.level.isClientSide) {
                ItemEntity entityitem = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)this.level.getBlockState(this.getBlockPos()).getBlock()), 0.0, 0.0, 0.0);
                this.level.removeBlock(this.getBlockPos(), false);
                this.level.addFreshEntity((Entity)entityitem);
            }
            return InteractionResult.SUCCESS;
        }
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof IShaderItem) {
            this.shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1));
            this.markContainingBlockForUpdate(null);
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        boolean target = false;
        if (side.getAxis() == Direction.Axis.Y && this.style == 0) {
            target = ((double)hitX < 0.375 || (double)hitX > 0.625) && ((double)hitZ < 0.375 || (double)hitZ > 0.625);
        } else if (side.getAxis() == Direction.Axis.Z) {
            target = this.style == 0 ? (double)hitX < 0.375 || (double)hitX > 0.625 : (double)hitY > 0.5625 && (double)hitY < 0.75;
        } else if (side.getAxis() == Direction.Axis.X) {
            target = this.style == 0 ? (double)hitZ < 0.375 || (double)hitZ > 0.625 : (double)hitY > 0.5625 && (double)hitY < 0.75;
        }
        DyeColor heldDye = Utils.getDye(heldItem);
        if (heldDye == null) {
            return InteractionResult.PASS;
        }
        if (!target) {
            if (this.colour0 == heldDye) {
                return InteractionResult.PASS;
            }
            this.colour0 = heldDye;
        } else {
            if (this.colour1 == heldDye) {
                return InteractionResult.PASS;
            }
            this.colour1 = heldDye;
        }
        this.markContainingBlockForUpdate(null);
        return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.level.isClientSide) {
            this.style = 1 - this.style;
            this.markContainingBlockForUpdate(null);
        }
        return true;
    }

    public CapabilityShader.ShaderWrapper getShader() {
        return this.shader;
    }
}

