/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockItemBalloon
extends BlockItemIE {
    public BlockItemBalloon(Block b) {
        super(b);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        if (playerIn.isShiftKeyDown()) {
            return this.increaseOffset(playerIn, hand);
        }
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        Vec3 pos = playerIn.position().add(0.0, (double)playerIn.getEyeHeight(), 0.0).add(playerIn.getLookAngle());
        BlockPos bPos = BlockPos.containing((Position)pos);
        byte offset = this.getOffset(itemStackIn);
        if (worldIn.isEmptyBlock(bPos = bPos.above((int)offset))) {
            if (!worldIn.isClientSide) {
                worldIn.setBlockAndUpdate(bPos, IEBlocks.Cloth.BALLOON.defaultBlockState());
                itemStackIn.shrink(1);
                if (itemStackIn.getCount() <= 0) {
                    playerIn.setItemInHand(hand, ItemStack.EMPTY);
                }
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            InteractionResultHolder<ItemStack> resultHolder = this.increaseOffset(player, context.getHand());
            player.setItemInHand(context.getHand(), (ItemStack)resultHolder.getObject());
            return resultHolder.getResult();
        }
        return super.useOn(context);
    }

    @Override
    protected boolean placeBlock(BlockPlaceContext context, BlockState newState) {
        byte offset = this.getOffset(context.getItemInHand());
        context = BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)context.getClickedPos().above((int)offset), (Direction)context.getClickedFace());
        return super.placeBlock(context, newState);
    }

    public Component getName(ItemStack stack) {
        MutableComponent ret = super.getName(stack).copy();
        CompoundTag nbt = stack.getOrCreateTag();
        if (nbt.getByte("offset") != 0) {
            ret.append(" (+" + nbt.getByte("offset") + ")");
        }
        return ret;
    }

    private InteractionResultHolder<ItemStack> increaseOffset(Player player, InteractionHand hand) {
        ItemStack newStack = player.getItemInHand(hand).copy();
        CompoundTag tag = newStack.getOrCreateTag();
        tag.putByte("offset", (byte)((this.getOffset(newStack) + 1) % 5));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)newStack);
    }

    private byte getOffset(ItemStack stack) {
        if (stack.hasTag()) {
            return stack.getOrCreateTag().getByte("offset");
        }
        return 0;
    }
}

