/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class StripCurtainBlock
extends IEEntityBlock<StripCurtainBlockEntity> {
    public static BooleanProperty CEILING_ATTACHED = BooleanProperty.create((String)"ceiling_attached");
    public static EnumProperty<Direction> FACING = IEProperties.FACING_HORIZONTAL;
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).ignitedByLava().sound(SoundType.WOOL).strength(0.8f).noOcclusion();

    public StripCurtainBlock(BlockBehaviour.Properties props) {
        super(IEBlockEntities.STRIP_CURTAIN, props);
        this.setLightOpacity(0);
        this.setHasColours();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CEILING_ATTACHED, FACING});
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            int color = ItemNBTHelper.getInt(stack, "colour");
            tooltip.add((Component)FontUtils.withAppendColoredColour(Component.translatable((String)"desc.immersiveengineering.info.colour"), color));
        }
    }
}

