/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PostBlock
extends IEBaseBlock
implements IPostBlock,
IModelOffsetProvider {
    public static final IntegerProperty POST_SLAVE = IntegerProperty.create((String)"post_slave", (int)0, (int)3);
    public static final EnumProperty<HorizontalOffset> HORIZONTAL_OFFSET = EnumProperty.create((String)"horizontal_offset", HorizontalOffset.class);
    private static final ThreadLocal<Boolean> recursionLock = new ThreadLocal();

    public PostBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps.pushReaction(PushReaction.BLOCK));
        this.lightOpacity = 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POST_SLAVE, HORIZONTAL_OFFSET, BlockStateProperties.WATERLOGGED});
    }

    public void onRemove(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, BlockState newState, boolean moving) {
        if (state.getBlock() != newState.getBlock()) {
            int dummyState = (Integer)state.getValue((Property)POST_SLAVE);
            HorizontalOffset offset = (HorizontalOffset)((Object)state.getValue(HORIZONTAL_OFFSET));
            if (dummyState > 0 && offset == HorizontalOffset.NONE) {
                world.removeBlock(pos.below(dummyState), false);
            } else if (dummyState == 0) {
                int highestBlock = 3;
                BlockPos armStart = pos.above(3);
                for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
                    BlockPos armPos = armStart.relative(d);
                    BlockState armState = world.getBlockState(armPos);
                    if (armState.getBlock() != this || !((HorizontalOffset)((Object)armState.getValue(HORIZONTAL_OFFSET))).getOffset().equals((Object)d.getNormal())) continue;
                    world.removeBlock(armPos, false);
                }
                for (int i = 0; i <= 3; ++i) {
                    world.removeBlock(pos.above(i), false);
                }
            }
        }
        super.onRemove(state, world, pos, newState, moving);
    }

    @Override
    public boolean canIEBlockBePlaced(@Nonnull BlockState newState, BlockPlaceContext context) {
        BlockPos startingPos = context.getClickedPos();
        Level level = context.getLevel();
        for (int hh = 1; hh <= 3; ++hh) {
            BlockPos pos = startingPos.above(hh);
            BlockPlaceContext dummyContext = BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)pos, (Direction)context.getClickedFace());
            BlockState oldState = level.getBlockState(pos);
            if (!level.isOutsideBuildHeight(pos) && oldState.getBlock().canBeReplaced(oldState, dummyContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (int i = 1; i <= 3; ++i) {
            BlockPos dummyPos = pos.above(i);
            world.setBlockAndUpdate(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.setValue((Property)POST_SLAVE, (Comparable)Integer.valueOf(i)), world, dummyPos));
            world.blockEvent(pos.offset(0, i, 0), (Block)this, 255, 0);
        }
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, @Nullable LivingEntity entity) {
        return true;
    }

    private static boolean hasArmFor(BlockPos center, Direction side, BlockGetter world, Block expected) {
        int highest = 3;
        BlockState centerState = world.getBlockState(center);
        if (centerState.getBlock() != expected || (Integer)centerState.getValue((Property)POST_SLAVE) != 3 || centerState.getValue(HORIZONTAL_OFFSET) != HorizontalOffset.NONE) {
            return false;
        }
        BlockState armState = world.getBlockState(center.relative(side));
        return armState.getBlock() == expected && (Integer)armState.getValue((Property)POST_SLAVE) == 3 && ((HorizontalOffset)((Object)armState.getValue(HORIZONTAL_OFFSET))).getOffset().equals((Object)side.getNormal());
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level world, BlockPos pos, BlockHitResult hit) {
        BlockState state = world.getBlockState(pos);
        int dummy = (Integer)state.getValue((Property)POST_SLAVE);
        HorizontalOffset offset = (HorizontalOffset)((Object)state.getValue(HORIZONTAL_OFFSET));
        boolean changed = false;
        if (dummy == 3 && offset == HorizontalOffset.NONE && side.getAxis() != Direction.Axis.Y) {
            BlockPos offsetPos = pos.relative(side);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, hand, hit));
            if (!world.getBlockState(offsetPos).canBeReplaced(context)) {
                return InteractionResult.FAIL;
            }
            for (Direction forbidden : ImmutableList.of((Object)side.getClockWise(), (Object)side.getCounterClockWise())) {
                if (!PostBlock.hasArmFor(pos, forbidden, (BlockGetter)world, this)) continue;
                return InteractionResult.FAIL;
            }
            BlockState arm_state = (BlockState)((BlockState)this.getStateForPlacement(context).setValue((Property)POST_SLAVE, (Comparable)Integer.valueOf(3))).setValue(HORIZONTAL_OFFSET, (Comparable)((Object)HorizontalOffset.get(side)));
            world.setBlockAndUpdate(offsetPos, arm_state);
            changed = true;
        } else if (dummy == 3 && offset != HorizontalOffset.NONE) {
            world.removeBlock(pos, false);
            changed = true;
        }
        if (changed) {
            BlockPos masterPos = pos.below(dummy).subtract(offset.getOffset());
            BlockState masterState = world.getBlockState(masterPos);
            world.sendBlockUpdated(masterPos, masterState, masterState, 3);
            return InteractionResult.SUCCESS;
        }
        return super.hammerUseSide(side, player, hand, world, pos, hit);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.joinUnoptimized((VoxelShape)this.getMainShape(state, worldIn, pos), (VoxelShape)this.getConnectionShapes(state, worldIn, pos), (BooleanOp)BooleanOp.OR);
    }

    private VoxelShape getMainShape(BlockState state, BlockGetter world, BlockPos pos) {
        int dummy = (Integer)state.getValue((Property)POST_SLAVE);
        if (dummy == 0) {
            return Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
        }
        if (dummy <= 2) {
            return Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
        }
        if (dummy == 3) {
            float down = PostBlock.hasConnection(state, Direction.DOWN, world, pos) ? 0.0f : 0.4375f;
            float up = down > 0.0f ? 1.0f : 0.5625f;
            return switch ((HorizontalOffset)((Object)state.getValue(HORIZONTAL_OFFSET))) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalOffset.NONE -> Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
                case HorizontalOffset.NORTH -> Shapes.box((double)0.3125, (double)down, (double)0.3125, (double)0.6875, (double)up, (double)1.0);
                case HorizontalOffset.SOUTH -> Shapes.box((double)0.3125, (double)down, (double)0.0, (double)0.6875, (double)up, (double)0.6875);
                case HorizontalOffset.EAST -> Shapes.box((double)0.0, (double)down, (double)0.3125, (double)0.6875, (double)up, (double)0.6875);
                case HorizontalOffset.WEST -> Shapes.box((double)0.3125, (double)down, (double)0.3125, (double)1.0, (double)up, (double)0.6875);
            };
        }
        return Shapes.block();
    }

    private VoxelShape getConnectionShapes(BlockState state, BlockGetter world, BlockPos pos) {
        HorizontalOffset offset = (HorizontalOffset)((Object)state.getValue(HORIZONTAL_OFFSET));
        if (offset == HorizontalOffset.NONE) {
            int dummy = (Integer)state.getValue((Property)POST_SLAVE);
            if (dummy == 0) {
                return Shapes.empty();
            }
            double baseWidth = dummy == 3 ? 0.375 : 0.25;
            VoxelShape ret = Shapes.empty();
            for (Direction neighbor : DirectionUtils.BY_HORIZONTAL_INDEX) {
                double maxY;
                double minY;
                if (!PostBlock.hasConnection(state, neighbor, world, pos)) continue;
                if (dummy < 3) {
                    minY = 0.25;
                    maxY = 0.8125;
                } else {
                    BlockPos neighborPos = pos.relative(neighbor);
                    BlockState neighborState = world.getBlockState(neighborPos);
                    if (PostBlock.hasConnection(neighborState, Direction.DOWN, world, neighborPos)) {
                        minY = 0.0;
                        maxY = 0.5625;
                    } else {
                        minY = 0.4375;
                        maxY = 1.0;
                    }
                }
                double[] horizontalBounds = new double[]{(1.0 - baseWidth) / 2.0, (1.0 + baseWidth) / 2.0, (1.0 - baseWidth) / 2.0, (1.0 + baseWidth) / 2.0};
                int minIndex = neighbor.getAxis() == Direction.Axis.X ? 0 : 2;
                int maxIndex = minIndex + 1;
                if (neighbor.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    horizontalBounds[minIndex] = horizontalBounds[maxIndex];
                    horizontalBounds[maxIndex] = 1.0;
                } else {
                    horizontalBounds[maxIndex] = horizontalBounds[minIndex];
                    horizontalBounds[minIndex] = 0.0;
                }
                VoxelShape sideShape = Shapes.box((double)horizontalBounds[0], (double)minY, (double)horizontalBounds[2], (double)horizontalBounds[1], (double)maxY, (double)horizontalBounds[3]);
                ret = Shapes.joinUnoptimized((VoxelShape)ret, (VoxelShape)sideShape, (BooleanOp)BooleanOp.OR);
            }
            return ret;
        }
        return Shapes.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasConnection(BlockState stateHere, Direction dir, BlockGetter world, BlockPos pos) {
        if (recursionLock.get() != null && recursionLock.get().booleanValue()) {
            return true;
        }
        recursionLock.set(true);
        try {
            boolean bl = PostBlock.hasConnectionInner(stateHere, dir, world, pos);
            return bl;
        }
        finally {
            recursionLock.set(false);
        }
    }

    private static boolean hasConnectionInner(BlockState stateHere, Direction dir, BlockGetter world, BlockPos pos) {
        BlockPos neighborPos = pos.relative(dir);
        int dummy = (Integer)stateHere.getValue((Property)POST_SLAVE);
        boolean ret = false;
        if (dummy > 0 && dummy < 3) {
            BlockState neighborState = world.getBlockState(neighborPos);
            VoxelShape shape = neighborState.getShape(world, neighborPos);
            if (!shape.isEmpty()) {
                boolean connect;
                AABB aabb = shape.bounds();
                double distance = dir == Direction.NORTH ? aabb.maxZ - 1.0 : (dir == Direction.SOUTH ? aabb.minZ : (dir == Direction.WEST ? aabb.maxX - 1.0 : aabb.minX));
                double eps = 1.0E-7;
                boolean bl = connect = distance < 1.0E-7 && distance > -1.0E-7;
                if (connect) {
                    ret = dir.getAxis() == Direction.Axis.Z ? aabb.minX > 1.0E-7 && aabb.maxX < 0.9999999 : aabb.minZ > 1.0E-7 && aabb.maxZ < 0.9999999;
                }
            }
        } else if (dummy == 3) {
            HorizontalOffset offset = (HorizontalOffset)((Object)stateHere.getValue(HORIZONTAL_OFFSET));
            if (offset == HorizontalOffset.NONE) {
                ret = PostBlock.hasArmFor(pos, dir, world, stateHere.getBlock());
            } else if (world.getBlockState(neighborPos).isAir() || dir.getAxis() != Direction.Axis.Y) {
                ret = false;
            } else {
                BlockState neighborState = world.getBlockState(neighborPos);
                if (neighborState.canBeReplaced()) {
                    ret = false;
                } else {
                    VoxelShape shape = neighborState.getShape(world, neighborPos);
                    ret = PostBlock.shapeReachesBlockFace(shape, dir.getOpposite());
                }
            }
        }
        return ret;
    }

    private static boolean shapeReachesBlockFace(VoxelShape shape, Direction face) {
        if (face.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            return shape.max(face.getAxis()) == 1.0;
        }
        return shape.min(face.getAxis()) == 0.0;
    }

    @Override
    public boolean canConnectTransformer(BlockGetter world, BlockPos pos) {
        int offset = (Integer)world.getBlockState(pos).getValue((Property)POST_SLAVE);
        return offset > 0;
    }

    @Override
    @Nonnull
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        HorizontalOffset d = (HorizontalOffset)((Object)state.getValue(HORIZONTAL_OFFSET));
        return new BlockPos(0, ((Integer)state.getValue((Property)POST_SLAVE)).intValue(), 0).offset(d.getOffset());
    }

    @Override
    public int getLightBlock(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public static enum HorizontalOffset implements StringRepresentable
    {
        NONE,
        NORTH,
        SOUTH,
        EAST,
        WEST;


        public static HorizontalOffset get(Direction side) {
            return switch (side) {
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
                default -> throw new IllegalArgumentException("No horizontal offset for " + side.name());
            };
        }

        public Vec3i getOffset() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORTH -> Direction.NORTH.getNormal();
                case SOUTH -> Direction.SOUTH.getNormal();
                case EAST -> Direction.EAST.getNormal();
                case WEST -> Direction.WEST.getNormal();
                case NONE -> BlockPos.ZERO;
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

