/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallmountBlock
extends IEBaseBlock {
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.create((String)"orientation", Orientation.class);

    public WallmountBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps);
        this.lightOpacity = 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_HORIZONTAL, ORIENTATION, BlockStateProperties.WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState ret = super.getStateForPlacement(context);
        if (ret == null) {
            return null;
        }
        Direction side = context.getClickedFace();
        Direction facing = Direction.fromYRot((double)context.getRotation());
        if (side.getAxis() == Direction.Axis.Y) {
            facing = facing.getOpposite();
        }
        ret = side == Direction.UP ? (BlockState)ret.setValue(ORIENTATION, (Comparable)((Object)Orientation.VERT_UP)) : (side == Direction.DOWN ? (BlockState)ret.setValue(ORIENTATION, (Comparable)((Object)Orientation.VERT_DOWN)) : (context.getClickLocation().y - (double)context.getClickedPos().getY() < 0.5 ? (BlockState)ret.setValue(ORIENTATION, (Comparable)((Object)Orientation.SIDE_DOWN)) : (BlockState)ret.setValue(ORIENTATION, (Comparable)((Object)Orientation.SIDE_UP))));
        ret = (BlockState)ret.setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)facing);
        return ret;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        double maxX;
        double minX;
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        Direction facing = (Direction)state.getValue((Property)IEProperties.FACING_HORIZONTAL);
        Direction towards = orientation.attachedToSide() ? facing : facing.getOpposite();
        double d = minX = towards == Direction.WEST ? 0.0 : 0.3125;
        double minY = orientation == Orientation.SIDE_UP ? 0.375 : (orientation == Orientation.VERT_DOWN ? 0.3125 : 0.0);
        double minZ = towards == Direction.NORTH ? 0.0 : 0.3125;
        double d2 = maxX = towards == Direction.EAST ? 1.0 : 0.6875;
        double maxY = orientation == Orientation.SIDE_DOWN ? 0.625 : (orientation == Orientation.VERT_UP ? 0.6875 : 1.0);
        double maxZ = towards == Direction.SOUTH ? 1.0 : 0.6875;
        return Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            BlockState state = w.getBlockState(pos);
            Orientation old = (Orientation)((Object)state.getValue(ORIENTATION));
            Orientation newO = old.getDual();
            w.setBlockAndUpdate(pos, (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)newO)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum Orientation implements StringRepresentable
    {
        SIDE_UP,
        SIDE_DOWN,
        VERT_DOWN,
        VERT_UP;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public boolean attachedToSide() {
            return this == SIDE_DOWN || this == SIDE_UP;
        }

        public boolean touchesTop() {
            return this == SIDE_UP || this == VERT_UP;
        }

        public Orientation getDual() {
            switch (this) {
                case SIDE_UP: {
                    return SIDE_DOWN;
                }
                case SIDE_DOWN: {
                    return SIDE_UP;
                }
                case VERT_UP: {
                    return VERT_DOWN;
                }
            }
            return VERT_UP;
        }

        public String modelSuffix() {
            switch (this) {
                case SIDE_UP: {
                    return "";
                }
                case SIDE_DOWN: {
                    return "_inverted";
                }
                case VERT_DOWN: {
                    return "_sideways";
                }
            }
            return "_sideways_inverted";
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

