/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindowBlock
extends IEBaseBlock {
    private static final VoxelShape X_FACING = Block.box((double)6.75, (double)0.0, (double)0.0, (double)9.25, (double)16.0, (double)16.0);
    private static final VoxelShape Y_FACING = Block.box((double)0.0, (double)6.75, (double)0.0, (double)16.0, (double)9.25, (double)16.0);
    private static final VoxelShape Z_FACING = Block.box((double)0.0, (double)0.0, (double)6.75, (double)16.0, (double)16.0, (double)9.25);

    public WindowBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_ALL});
    }

    protected Direction getDefaultFacing() {
        return Direction.NORTH;
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        return (BlockState)ret.setValue((Property)IEProperties.FACING_ALL, (Comparable)this.getDefaultFacing());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)IEProperties.FACING_ALL, (Comparable)pContext.getNearestLookingDirection());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)IEProperties.FACING_ALL);
        return switch (facing.getAxis()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_FACING;
            case Direction.Axis.Y -> Y_FACING;
            case Direction.Axis.Z -> Z_FACING;
        };
    }
}

