/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BlastFurnacePreheaterBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IModelOffsetProvider,
IEClientTickableBE,
IEBlockInterfaces.ISoundBE {
    public static final float ANGLE_PER_TICK = (float)Math.toRadians(20.0);
    public boolean active;
    public int dummy = 0;
    public final MutableEnergyStorage energyStorage = new MutableEnergyStorage(8000);
    public float angle = 0.0f;
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, BlastFurnacePreheaterBlockEntity::master, this.makeEnergyInput(this.energyStorage));

    public BlastFurnacePreheaterBlockEntity(BlockEntityType<BlastFurnacePreheaterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int doSpeedup() {
        int consumed = (Integer)IEServerConfig.MACHINES.preheater_consumption.get();
        if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
            if (!this.active) {
                this.active = true;
                this.markContainingBlockForUpdate(null);
            }
            this.energyStorage.extractEnergy(consumed, false);
            return 1;
        }
        this.turnOff();
        return 0;
    }

    @Override
    public void tickClient() {
        if (this.active) {
            this.angle = (this.angle + ANGLE_PER_TICK) % (float)Math.PI;
        }
        ImmersiveEngineering.proxy.handleTileSound(IESounds.preheater, this, this.active, 0.5f, 1.0f);
    }

    public Void turnOff() {
        if (this.active) {
            this.active = false;
            this.markContainingBlockForUpdate(null);
        }
        return null;
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    @Nullable
    public BlastFurnacePreheaterBlockEntity master() {
        BlastFurnacePreheaterBlockEntity heater;
        BlockPos masterPos = this.getBlockPos().below(this.dummy);
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof BlastFurnacePreheaterBlockEntity ? (heater = (BlastFurnacePreheaterBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.level.setBlockAndUpdate(this.worldPosition.offset(0, i, 0), state);
            ((BlastFurnacePreheaterBlockEntity)this.level.getBlockEntity((BlockPos)this.worldPosition.offset((int)0, (int)i, (int)0))).dummy = i;
            ((BlastFurnacePreheaterBlockEntity)this.level.getBlockEntity(this.worldPosition.offset(0, i, 0))).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.level.getBlockEntity(this.getBlockPos().offset(0, -this.dummy, 0).offset(0, i, 0)) instanceof BlastFurnacePreheaterBlockEntity)) continue;
            this.level.removeBlock(this.getBlockPos().offset(0, -this.dummy, 0).offset(0, i, 0), false);
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.dummy = nbt.getInt("dummy");
        this.active = nbt.getBoolean("active");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        } else {
            EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.putInt("dummy", this.dummy);
        nbt.putBoolean("active", this.active);
        if (!descPacket) {
            EnergyHelper.serializeTo(this.energyStorage, nbt);
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<BlastFurnacePreheaterBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> {
            if (side == null || be.dummy == 2 && side == Direction.UP) {
                return be.energyCap.get();
            }
            return null;
        });
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public void afterRotation(Direction oldDir, Direction newDir) {
        for (int i = 0; i <= 2; ++i) {
            BlockEntity te = this.level.getBlockEntity(this.getBlockPos().offset(0, -this.dummy + i, 0));
            if (!(te instanceof BlastFurnacePreheaterBlockEntity)) continue;
            BlastFurnacePreheaterBlockEntity dummy = (BlastFurnacePreheaterBlockEntity)te;
            dummy.setFacing(newDir);
            dummy.setChanged();
            dummy.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return new BlockPos(0, this.dummy, 0);
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.active;
    }
}

