/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CapacitorBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockEntityDrop {
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(Direction.class);
    private final IEServerConfig.Machines.CapacitorConfig configValues;
    private final IEnergyStorage energyStorage;
    protected final Map<Direction, IEnergyStorage> energyCaps = new EnumMap<Direction, IEnergyStorage>(Direction.class);
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IEnergyStorage>> connectedCaps = IEBlockCapabilityCaches.allNeighbors(Capabilities.EnergyStorage.BLOCK, this);
    protected final IEnergyStorage nullEnergyCap;
    public int comparatorOutput = 0;

    public CapacitorBlockEntity(IEServerConfig.Machines.CapacitorConfig configValues, BlockPos pos, BlockState state) {
        super(configValues.tileType.get(), pos, state);
        this.configValues = configValues;
        this.energyStorage = IEServerConfig.CONFIG_SPEC.isLoaded() ? this.makeMainEnergyStorage() : NullEnergyStorage.INSTANCE;
        for (Direction f : DirectionUtils.VALUES) {
            if (f == Direction.UP) {
                this.sideConfig.put(f, IEEnums.IOSideConfig.INPUT);
            } else {
                this.sideConfig.put(f, IEEnums.IOSideConfig.NONE);
            }
            this.energyCaps.put(f, new CapacitorEnergyHandler(f, this.sideConfig, this.energyStorage));
        }
        this.nullEnergyCap = new WrappingEnergyStorage(this.energyStorage, false, false);
    }

    @Override
    public void tickServer() {
        int i;
        for (Direction f : DirectionUtils.VALUES) {
            this.transferEnergy(f);
        }
        if (this.level.getGameTime() % 32L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
            this.comparatorOutput = i;
            this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(Direction side) {
        if (this.sideConfig.get(side) != IEEnums.IOSideConfig.OUTPUT) {
            return;
        }
        int out = Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
        IEnergyStorage neighborCap = this.connectedCaps.get(side).getCapability();
        if (neighborCap != null) {
            int inserted = neighborCap.receiveEnergy(out, false);
            this.energyStorage.extractEnergy(inserted, false);
        }
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.get(side);
    }

    @Override
    public boolean toggleSide(Direction side, Player player) {
        this.sideConfig.put(side, IEEnums.IOSideConfig.next(this.sideConfig.get(side)));
        this.setChanged();
        this.markContainingBlockForUpdate(null);
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
        return true;
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public final int getMaxStorage() {
        return this.configValues.storage.getAsInt();
    }

    public final int getMaxInput() {
        return this.configValues.input.getAsInt();
    }

    public final int getMaxOutput() {
        return this.configValues.output.getAsInt();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        for (Direction f : DirectionUtils.VALUES) {
            nbt.putInt("sideConfig_" + f.ordinal(), this.sideConfig.get(f).ordinal());
        }
        IEnergyStorage iEnergyStorage = this.energyStorage;
        if (iEnergyStorage instanceof EnergyStorage) {
            EnergyStorage forgeStorage = (EnergyStorage)iEnergyStorage;
            EnergyHelper.serializeTo(forgeStorage, nbt);
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        for (Direction f : DirectionUtils.VALUES) {
            this.sideConfig.put(f, IEEnums.IOSideConfig.values()[nbt.getInt("sideConfig_" + f.ordinal())]);
        }
        IEnergyStorage iEnergyStorage = this.energyStorage;
        if (iEnergyStorage instanceof EnergyStorage) {
            EnergyStorage forgeStorage = (EnergyStorage)iEnergyStorage;
            EnergyHelper.deserializeFrom(forgeStorage, nbt);
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<? extends CapacitorBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> side == null ? be.nullEnergyCap : be.energyCaps.get(side));
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && mop instanceof BlockHitResult) {
            BlockHitResult bmop = (BlockHitResult)mop;
            IEEnums.IOSideConfig here = this.sideConfig.get(bmop.getDirection());
            IEEnums.IOSideConfig opposite = this.sideConfig.get(bmop.getDirection().getOpposite());
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectEnergy.", here, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        this.writeCustomNBT(stack.getOrCreateTag(), false);
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (stack.hasTag()) {
            this.readCustomNBT(stack.getOrCreateTag(), false);
        }
    }

    protected IEnergyStorage makeMainEnergyStorage() {
        return new MutableEnergyStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    }

    private record CapacitorEnergyHandler(Direction side, Map<Direction, IEEnums.IOSideConfig> sideConfigs, IEnergyStorage base) implements IEnergyStorage
    {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.canReceive()) {
                return this.base.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.canExtract()) {
                return this.base.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            return this.base.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.base.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.sideConfigs.get(this.side) == IEEnums.IOSideConfig.OUTPUT;
        }

        public boolean canReceive() {
            return this.sideConfigs.get(this.side) == IEEnums.IOSideConfig.INPUT;
        }
    }
}

