/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorStructuralBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IStateBasedDirectional {
    public float rotation = 0.0f;

    public ConnectorStructuralBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)IEBlockEntities.CONNECTOR_STRUCTURAL.get(), pos, state);
    }

    public ConnectorStructuralBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.level.isClientSide) {
            this.rotation += player.isShiftKeyDown() ? -22.5f : 22.5f;
            this.rotation %= 360.0f;
            this.setChanged();
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 254, 0);
        }
        return true;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.putFloat("rotation", this.rotation);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.rotation = nbt.getFloat("rotation");
        if (this.level != null && this.level.isClientSide) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = 0.03125;
        return new Vec3(0.5 + (double)side.getStepX() * (-0.125 - conRadius), 0.5 + (double)side.getStepY() * (-0.125 - conRadius), 0.5 + (double)side.getStepZ() * (-0.125 - conRadius));
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "STRUCTURE".equals(cableType.getCategory());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return EnergyConnectorBlockEntity.getConnectorBounds(this.getFacing(), 0.5f);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }
}

