/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class ConveyorBlock
extends IEEntityBlock<ConveyorBeltBlockEntity<?>>
implements ConveyorHandler.IConveyorBlock {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).noOcclusion();
    public static final String DEFAULT_COVER = "defaultCover";
    private final IConveyorType<?> type;
    public static final EnumProperty<Direction> FACING = IEProperties.FACING_HORIZONTAL;

    public ConveyorBlock(IConveyorType<?> type, BlockBehaviour.Properties props) {
        super((BlockPos pos, BlockState state) -> new ConveyorBeltBlockEntity(type, (BlockPos)pos, (BlockState)state), props);
        this.type = type;
        this.lightOpacity = 0;
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
        out.accept((ItemLike)this);
        if (this.type.acceptsCovers()) {
            out.accept(ConveyorBlock.makeCovered((ItemLike)this, IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get((Object)MetalScaffoldingType.STANDARD).get()));
        }
    }

    public static ItemStack makeCovered(ItemLike conveyor, Block cover) {
        ItemStack covered = new ItemStack(conveyor, 1);
        covered.getOrCreateTag().putString(DEFAULT_COVER, BuiltInRegistries.BLOCK.getKey((Object)cover).toString());
        return covered;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED});
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        String flavourKey = this.getDescriptionId() + ".flavour";
        if (I18n.exists((String)flavourKey)) {
            tooltip.add((Component)Component.translatable((String)flavourKey));
        }
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        super.onIEBlockPlacedBy(context, state);
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof ConveyorBeltBlockEntity) {
            ConveyorHandler.IConveyorBlockEntity convUp;
            ConveyorHandler.IConveyorBlockEntity outputConv;
            ConveyorBeltBlockEntity conveyor = (ConveyorBeltBlockEntity)tile;
            Object conveyorInst = conveyor.getConveyorInstance();
            if (conveyorInst != null) {
                conveyorInst.setCover(ConveyorBlock.getCover(context.getItemInHand()));
            }
            Direction f = conveyor.getFacing();
            tile = world.getBlockEntity(pos.relative(f));
            BlockEntity tileUp = world.getBlockEntity(pos.relative(f).offset(0, 1, 0));
            Object subType = conveyor.getConveyorInstance();
            if (subType != null && (!(tile instanceof ConveyorHandler.IConveyorBlockEntity) || (outputConv = (ConveyorHandler.IConveyorBlockEntity)tile).getFacing() == f.getOpposite()) && tileUp instanceof ConveyorHandler.IConveyorBlockEntity && (convUp = (ConveyorHandler.IConveyorBlockEntity)tileUp).getFacing() != f.getOpposite() && world.isEmptyBlock(pos.offset(0, 1, 0))) {
                subType.setConveyorDirection(ConveyorHandler.ConveyorDirection.UP);
            }
        }
    }

    public static Block getCover(ItemStack conveyor) {
        ResourceLocation coverID = new ResourceLocation(ItemNBTHelper.getString(conveyor, DEFAULT_COVER));
        Block result = (Block)BuiltInRegistries.BLOCK.get(coverID);
        if (result != null) {
            return result;
        }
        return Blocks.AIR;
    }

    @Override
    public IConveyorType<?> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (this.type.isTicking()) {
            return super.getTicker(world, state, type);
        }
        return null;
    }
}

