/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;

public class ElectromagnetBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IScrewdriverInteraction {
    private final MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000);
    public boolean redstoneControlInverted = false;
    public static final int MAGNET_CONSUMPTION = 32;
    public static final LoadingCache<String, Predicate<ItemEntity>> MAGNET_SOURCE_PREDICATE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(20L, TimeUnit.MINUTES).build(CacheLoader.from(key -> itemEntity -> {
        if (itemEntity.hasPickUpDelay()) {
            return false;
        }
        int lastMagnetized = itemEntity.getPersistentData().getInt("immersiveengineering:magnet_last_pulled");
        if (lastMagnetized > 0 && itemEntity.tickCount - lastMagnetized < 40) {
            return false;
        }
        String nbtSource = itemEntity.getPersistentData().getString("immersiveengineering:magnet_source");
        if (!nbtSource.isEmpty() && !nbtSource.equals(key)) {
            return false;
        }
        return !itemEntity.getPersistentData().contains("PreventRemoteMovement");
    }));

    public ElectromagnetBlockEntity(BlockEntityType<? extends ElectromagnetBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ElectromagnetBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ElectromagnetBlockEntity>)((BlockEntityType)IEBlockEntities.ELECTROMAGNET.get()), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.isRSPowered() == this.redstoneControlInverted && this.energyStorage.extractEnergy(32, false) >= 32) {
            BlockPos topFar;
            BlockPos bottomClose;
            int radius = 6;
            Direction facing = this.getFacing();
            Vec3 sourcePos = this.getBlockPos().relative(facing).getCenter().add(0.0, 0.25, 0.0);
            if (this.getFacing().getAxis() != Direction.Axis.Y) {
                bottomClose = this.getBlockPos().relative(facing.getCounterClockWise(), 6).below(6);
                topFar = this.getBlockPos().relative(facing, 6).relative(facing.getClockWise(), 6).above(6);
            } else {
                bottomClose = this.getBlockPos().offset(-6, 0, -6);
                topFar = this.getBlockPos().offset(6, 0, 6).relative(facing, 6);
            }
            AABB area = new AABB(Vec3.atCenterOf((Vec3i)bottomClose), Vec3.atCenterOf((Vec3i)topFar));
            List<ItemEntity> items = ElectromagnetBlockEntity.performMagnetAttraction(this.getLevelNonnull(), area, 0.75, sourcePos, Vec3.ZERO, this.getBlockPos().toShortString(), () -> true);
            items.forEach(itemEntity -> {
                if (itemEntity.distanceToSqr(sourcePos) <= 1.0) {
                    itemEntity.getPersistentData().putInt("immersiveengineering:magnet_last_pulled", itemEntity.tickCount);
                }
            });
        }
    }

    public static List<ItemEntity> performMagnetAttraction(Level world, AABB targetArea, double minimumDistance, Vec3 sourcePosition, Vec3 sourceMovement, String sourceName, Supplier<Boolean> hasConsumedEnergy) {
        List items = world.getEntitiesOfClass(ItemEntity.class, targetArea, (Predicate)MAGNET_SOURCE_PREDICATE.getUnchecked((Object)sourceName));
        for (ItemEntity itemEntity : items) {
            Vec3 dist = sourcePosition.subtract(itemEntity.position());
            if (!(dist.length() > minimumDistance) || !hasConsumedEnergy.get().booleanValue()) continue;
            if (!itemEntity.getPersistentData().contains("immersiveengineering:magnet_source")) {
                itemEntity.playSound((SoundEvent)IESounds.electromagnet.value(), (float)(0.125 + world.getRandom().nextDouble() * 0.25), 1.0f);
                itemEntity.getPersistentData().putString("immersiveengineering:magnet_source", sourceName);
            }
            Vec3 movementRequired = new Vec3(Math.min(dist.x, 1.0), Math.min(dist.y, 1.0), Math.min(dist.z, 1.0)).subtract(sourceMovement);
            itemEntity.setDeltaMovement(movementRequired.scale(0.2));
        }
        return items;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.putBoolean("redstoneInverted", this.redstoneControlInverted);
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<ElectromagnetBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> side != be.getFacing() ? be.energyStorage : null);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_INVERTED;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (player.isShiftKeyDown() && !this.getLevelNonnull().isClientSide) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }
}

