/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.ComputerControlState;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.FakeLightBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.SpawnInterdictionHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControllable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloodlightBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IAdvancedDirectionalBE,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.ISpawnInterdiction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.IStateBasedDirectional,
ComputerControllable {
    public int energyStorage = 0;
    private final int energyDraw;
    public final int maximumStorage;
    public boolean redstoneControlInverted;
    public Direction facing;
    public float rotY;
    public float rotX;
    public List<BlockPos> fakeLights;
    public List<BlockPos> lightsToBePlaced;
    public List<BlockPos> lightsToBeRemoved;
    final int timeBetweenSwitches = 20;
    int switchCooldown;
    private boolean shouldUpdate;
    public final ComputerControlState computerControl;
    public int turnCooldown;

    public FloodlightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLOODLIGHT.get(), pos, state);
        this.energyDraw = IEServerConfig.getOrDefault(IEServerConfig.MACHINES.floodlight_energyDraw);
        this.maximumStorage = IEServerConfig.getOrDefault(IEServerConfig.MACHINES.floodlight_maximumStorage);
        this.redstoneControlInverted = false;
        this.facing = Direction.NORTH;
        this.rotY = 0.0f;
        this.rotX = 0.0f;
        this.fakeLights = new ArrayList<BlockPos>();
        this.lightsToBePlaced = new ArrayList<BlockPos>();
        this.lightsToBeRemoved = new ArrayList<BlockPos>();
        this.timeBetweenSwitches = 20;
        this.switchCooldown = 0;
        this.shouldUpdate = true;
        this.computerControl = new ComputerControlState();
        this.turnCooldown = 0;
    }

    @Override
    public void tickServer() {
        if (this.turnCooldown > 0) {
            --this.turnCooldown;
        }
        boolean activeBeforeTick = this.getIsActive();
        if (this.shouldUpdate) {
            this.lightsToBePlaced.clear();
            this.updateFakeLights(true, activeBeforeTick);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
            this.shouldUpdate = false;
        }
        boolean enabled = this.computerControl.isAttached() ? this.computerControl.isEnabled() : this.isRSPowered() ^ this.redstoneControlInverted;
        if (this.energyStorage >= (!activeBeforeTick ? this.energyDraw * 10 : this.energyDraw) && enabled && this.switchCooldown <= 0) {
            this.energyStorage -= this.energyDraw;
            if (!activeBeforeTick) {
                this.setActive(true);
            }
        } else if (activeBeforeTick) {
            this.setActive(false);
            this.switchCooldown = 20;
        }
        --this.switchCooldown;
        boolean activeAfterTick = this.getIsActive();
        if (activeAfterTick != activeBeforeTick || this.level.getGameTime() % 512L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x1FF)) {
            this.markContainingBlockForUpdate(null);
            this.updateFakeLights(true, activeAfterTick);
            this.checkLight();
        }
        if (!activeAfterTick && !this.lightsToBePlaced.isEmpty()) {
            this.lightsToBePlaced.clear();
        }
        if (!(this.lightsToBePlaced.isEmpty() && this.lightsToBeRemoved.isEmpty() || this.level.getGameTime() % 8L != (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 7))) {
            BlockPos cc;
            Iterator<BlockPos> it = this.lightsToBePlaced.iterator();
            int timeout = 0;
            while (it.hasNext() && timeout++ < Math.max(16, 32 - this.lightsToBeRemoved.size())) {
                cc = it.next();
                this.level.setBlock(cc, IEBlocks.Misc.FAKE_LIGHT.defaultBlockState(), 2);
                BlockEntity te = this.level.getBlockEntity(cc);
                if (te instanceof FakeLightBlock.FakeLightBlockEntity) {
                    ((FakeLightBlock.FakeLightBlockEntity)te).floodlightCoords = this.getBlockPos();
                }
                this.fakeLights.add(cc);
                it.remove();
            }
            it = this.lightsToBeRemoved.iterator();
            while (it.hasNext() && timeout++ < 32) {
                cc = it.next();
                if (Utils.getExistingTileEntity(this.level, cc) instanceof FakeLightBlock.FakeLightBlockEntity) {
                    this.level.removeBlock(cc, false);
                }
                it.remove();
            }
        }
    }

    public void updateFakeLights(boolean deleteOld, boolean genNew) {
        Iterator<BlockPos> it = this.fakeLights.iterator();
        ArrayList<BlockPos> tempRemove = new ArrayList<BlockPos>();
        while (it.hasNext()) {
            BlockPos cc = it.next();
            BlockEntity te = this.level.getBlockEntity(cc);
            if (te instanceof FakeLightBlock.FakeLightBlockEntity) {
                if (!deleteOld) continue;
                tempRemove.add(cc);
                continue;
            }
            it.remove();
        }
        if (genNew) {
            float angle = this.facing == Direction.NORTH ? 180 : (this.facing == Direction.EAST ? 90 : (this.facing == Direction.WEST ? -90 : 0));
            float yRotation = this.rotY;
            double angleX = Math.toRadians(this.rotX);
            Vec3[] rays = new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 1.0)};
            Matrix4 mat = new Matrix4();
            if (this.getFacing() == Direction.DOWN) {
                mat.scale(1.0, -1.0, 1.0);
            } else if (this.getFacing() != Direction.UP) {
                float f = this.facing == Direction.DOWN ? 180.0f : (this.facing == Direction.NORTH ? -90.0f : (angle = this.facing == Direction.SOUTH ? 90.0f : angle));
                if (this.getFacing().getAxis() == Direction.Axis.X) {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    mat.rotate(1.5707963267948966, 0.0, 0.0, -this.getFacing().getAxisDirection().getStep());
                } else {
                    mat.rotate(1.5707963267948966, -1.0, 0.0, 0.0);
                    if (this.getFacing() == Direction.SOUTH) {
                        mat.rotate(Math.PI, 0.0, 0.0, 1.0);
                        if (this.facing.getAxis() == Direction.Axis.X) {
                            angle = -angle;
                        }
                    }
                }
            }
            double angleY = Math.toRadians(angle + yRotation);
            mat.rotate(angleY, 0.0, 1.0, 0.0);
            mat.rotate(-angleX, 1.0, 0.0, 0.0);
            rays[0] = mat.apply(rays[0]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[1] = mat.apply(rays[1]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[5] = mat.apply(rays[5]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[6] = mat.apply(rays[6]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            rays[2] = mat.apply(rays[2]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            rays[3] = mat.apply(rays[3]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[7] = mat.apply(rays[7]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[8] = mat.apply(rays[8]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            rays[4] = mat.apply(rays[4]);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 0.0, 1.0, 0.0);
            rays[9] = mat.apply(rays[9]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            rays[10] = mat.apply(rays[10]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            rays[11] = mat.apply(rays[11]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            rays[12] = mat.apply(rays[12]);
            for (int ray = 0; ray < rays.length; ++ray) {
                int offset = ray == 0 ? 0 : (ray < 4 ? 3 : 1);
                this.placeLightAlongVector(rays[ray], offset, tempRemove);
            }
        }
        this.lightsToBeRemoved.addAll(tempRemove);
    }

    public void placeLightAlongVector(Vec3 vec, int offset, ArrayList<BlockPos> checklist) {
        Vec3 light = Vec3.atCenterOf((Vec3i)this.getBlockPos()).add(0.0, 0.25, 0.0);
        int range = 32;
        HashSet<BlockPos> ignore = new HashSet<BlockPos>();
        ignore.add(this.getBlockPos());
        BlockPos hit = Utils.rayTraceForFirst(vec.add(light), light.add(vec.x * (double)range, vec.y * (double)range, vec.z * (double)range), this.level, ignore);
        double maxDistance = hit != null ? Vec3.atCenterOf((Vec3i)hit).add(0.0, 0.25, 0.0).distanceToSqr(light) : (double)(range * range);
        for (int i = 1 + offset; i <= range; ++i) {
            BlockPos target = this.getBlockPos().offset((int)Math.round(vec.x * (double)i), (int)Math.round(vec.y * (double)i), (int)Math.round(vec.z * (double)i));
            double dist = vec.x * (double)i * vec.x * (double)i + vec.y * (double)i * vec.y * (double)i + vec.z * (double)i * vec.z * (double)i;
            if (dist > maxDistance) break;
            if (this.getLevelNonnull().isOutsideBuildHeight(this.worldPosition) || target.equals((Object)this.getBlockPos()) || !this.level.isEmptyBlock(target)) continue;
            if (!checklist.remove(target)) {
                this.lightsToBePlaced.add(target);
            }
            i += 2;
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.getIsActive() ? 1024.0 : 0.0;
    }

    @Override
    public void setRemovedIE() {
        SpawnInterdictionHandler.removeFromInterdictionTiles(this);
        for (BlockPos pos : this.fakeLights) {
            BlockEntity blockEntity = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, pos);
            if (!(blockEntity instanceof FakeLightBlock.FakeLightBlockEntity)) continue;
            FakeLightBlock.FakeLightBlockEntity light = (FakeLightBlock.FakeLightBlockEntity)blockEntity;
            this.level.removeBlock(pos, false);
        }
        super.setRemovedIE();
    }

    @Override
    public void onChunkUnloaded() {
        SpawnInterdictionHandler.removeFromInterdictionTiles(this);
        super.onChunkUnloaded();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        SpawnInterdictionHandler.addInterdictionTile(this);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage = nbt.getInt("energy");
        this.redstoneControlInverted = nbt.getBoolean("redstoneControlInverted");
        this.facing = Direction.from3DDataValue((int)nbt.getInt("facing"));
        this.rotY = nbt.getFloat("rotY");
        this.rotX = nbt.getFloat("rotX");
        int lightAmount = nbt.getInt("lightAmount");
        this.fakeLights.clear();
        for (int i = 0; i < lightAmount; ++i) {
            int[] icc = nbt.getIntArray("fakeLight_" + i);
            this.fakeLights.add(new BlockPos(icc[0], icc[1], icc[2]));
        }
        if (this.level != null && this.level.isClientSide) {
            this.markContainingBlockForUpdate(null);
        }
        if (descPacket && nbt.contains("computerOn")) {
            boolean computerOn = nbt.getBoolean("computerOn");
            this.computerControl.setOneRef();
            this.computerControl.setEnabled(computerOn);
        } else {
            this.computerControl.clear();
        }
        if (this.level != null && this.getIsActive()) {
            this.checkLight();
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.putInt("energyStorage", this.energyStorage);
        nbt.putBoolean("redstoneControlInverted", this.redstoneControlInverted);
        nbt.putInt("facing", this.facing.ordinal());
        nbt.putFloat("rotY", this.rotY);
        nbt.putFloat("rotX", this.rotX);
        nbt.putInt("lightAmount", this.fakeLights.size());
        for (int i = 0; i < this.fakeLights.size(); ++i) {
            BlockPos cc = this.fakeLights.get(i);
            nbt.putIntArray("fakeLight_" + i, new int[]{cc.getX(), cc.getY(), cc.getZ()});
        }
        if (descPacket && this.computerControl.isAttached()) {
            nbt.putBoolean("computerOn", this.computerControl.isEnabled());
        }
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.checkLight();
            return true;
        }
        return super.triggerEvent(id, arg);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        double y;
        double x;
        BlockPos otherPos = other.position();
        int xDif = otherPos.getX() - this.worldPosition.getX();
        int yDif = otherPos.getY() - this.worldPosition.getY();
        int zDif = otherPos.getZ() - this.worldPosition.getZ();
        return new Vec3(x, y, switch (this.getFacing().getAxis()) {
            case Direction.Axis.Y -> {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double v0 = y = this.getFacing() == Direction.DOWN ? 0.9375 : 0.0625;
                yield Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
            case Direction.Axis.Z -> {
                double v1 = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                yield this.getFacing() == Direction.NORTH ? 0.9375 : 0.0625;
            }
            default -> {
                double v2 = x = this.getFacing() == Direction.WEST ? 0.9375 : 0.0625;
                double v3 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                yield Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        });
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.box((double)(this.getFacing().getAxis() == Direction.Axis.X ? 0.0 : 0.0625), (double)(this.getFacing().getAxis() == Direction.Axis.Y ? 0.0 : 0.0625), (double)(this.getFacing().getAxis() == Direction.Axis.Z ? 0.0 : 0.0625), (double)(this.getFacing().getAxis() == Direction.Axis.X ? 1.0 : 0.9375), (double)(this.getFacing().getAxis() == Direction.Axis.Y ? 1.0 : 0.9375), (double)(this.getFacing().getAxis() == Direction.Axis.Z ? 1.0 : 0.9375));
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.level.isClientSide) {
            if (side.getAxis() == this.getFacing().getAxis()) {
                this.turnY(player.isShiftKeyDown(), false);
            } else {
                this.turnX(player.isShiftKeyDown(), false);
            }
        }
        return true;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.level.isClientSide) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        Direction f = Direction.fromYRot((double)placer.getYRot());
        if (f == side.getOpposite()) {
            f = placer.getXRot() > 0.0f ? Direction.DOWN : Direction.UP;
        }
        this.facing = f;
    }

    public boolean canComputerTurn() {
        return this.turnCooldown <= 0 || !this.getIsActive();
    }

    public void turnX(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new RuntimeException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotX = Math.min(191.25f, Math.max(-11.25f, this.rotX + (dir ? -11.25f : 11.25f)));
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 255, 0);
        if (this.getIsActive()) {
            this.turnCooldown = 20;
            this.shouldUpdate = true;
        }
    }

    public void turnY(boolean dir, boolean throwException) {
        if (!this.canComputerTurn()) {
            if (throwException) {
                throw new RuntimeException("The floodlight can't turn again yet.");
            }
            return;
        }
        this.rotY = (float)((double)this.rotY + (dir ? -11.25 : 11.25));
        this.rotY %= 360.0f;
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 255, 0);
        if (this.getIsActive()) {
            this.turnCooldown = 20;
            this.shouldUpdate = true;
        }
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        if (this.energyStorage < this.maximumStorage) {
            return this.maximumStorage - this.energyStorage;
        }
        return 0;
    }

    @Override
    public void insertEnergy(int amount) {
        this.energyStorage += amount;
    }

    @Override
    public Stream<ComputerControlState> getAllComputerControlStates() {
        return Stream.of(this.computerControl);
    }
}

