/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.fluid.IPressurizedFluidOutput;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.WorldMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FluidPipeBlockEntity
extends IEBaseBlockEntity
implements IFluidPipe,
IEBlockInterfaces.IColouredBE,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlacementInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IAdditionalDrops {
    static WorldMap<BlockPos, Set<DirectionalFluidOutput>> indirectConnections = new WorldMap();
    public static ArrayList<Predicate<Block>> validPipeCovers = new ArrayList();
    public static ArrayList<Predicate<Block>> climbablePipeCovers = new ArrayList();
    public Object2BooleanMap<Direction> sideConfig = new Object2BooleanOpenHashMap();
    public Block cover;
    private byte connections;
    @Nullable
    private DyeColor color;
    private final Map<Direction, IFluidHandler> sidedHandlers;
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler>> neighbors;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES = new CachedVoxelShapes<BoundingBoxKey>(FluidPipeBlockEntity::getBoxes);

    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLUID_PIPE.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put((Object)d, true);
        }
        this.cover = Blocks.AIR;
        this.connections = 0;
        this.color = null;
        this.sidedHandlers = new EnumMap<Direction, IFluidHandler>(Direction.class);
        this.neighbors = IEBlockCapabilityCaches.allNeighbors(Capabilities.FluidHandler.BLOCK, this);
        for (Direction f : DirectionUtils.VALUES) {
            this.sidedHandlers.put(f, new PipeFluidHandler(this, f));
        }
    }

    public static void initCovers() {
        validPipeCovers.add(b -> b.defaultBlockState().is(IETags.scaffoldingAlu));
        validPipeCovers.add(b -> b.defaultBlockState().is(IETags.scaffoldingSteel));
        validPipeCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
        climbablePipeCovers.add(b -> b.defaultBlockState().is(IETags.scaffoldingAlu));
        climbablePipeCovers.add(b -> b.defaultBlockState().is(IETags.scaffoldingSteel));
        climbablePipeCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
    }

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlers(BlockPos node, Level world) {
        if (world.isClientSide) {
            return ImmutableSet.of();
        }
        Set<DirectionalFluidOutput> cachedResult = indirectConnections.get(world, node);
        if (cachedResult != null) {
            return cachedResult;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            BlockEntity pipeTile = Utils.getExistingTileEntity(world, next);
            if (!closedList.contains(next) && pipeTile instanceof FluidPipeBlockEntity) {
                FluidPipeBlockEntity pipe = (FluidPipeBlockEntity)pipeTile;
                closedList.add(next);
                for (Direction fd : DirectionUtils.VALUES) {
                    if (!pipe.hasOutputConnection(fd)) continue;
                    BlockPos nextPos = next.relative(fd);
                    BlockEntity adjacentTile = Utils.getExistingTileEntity(world, nextPos);
                    if (adjacentTile instanceof FluidPipeBlockEntity) {
                        openList.add(nextPos);
                        continue;
                    }
                    IFluidHandler handler = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, nextPos, (Object)fd.getOpposite());
                    if (handler == null || handler.getTanks() <= 0) continue;
                    fluidHandlers.add(new DirectionalFluidOutput(handler, fd, adjacentTile, nextPos));
                }
            }
            openList.remove(0);
        }
        indirectConnections.put(world, node, fluidHandlers);
        return fluidHandlers;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EventHandler.SERVER_TASKS.add(() -> {
                boolean changed = false;
                for (Direction f : DirectionUtils.VALUES) {
                    changed |= this.updateConnectionByte(f);
                }
                if (changed) {
                    this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
                    this.markContainingBlockForUpdate(null);
                }
            });
        }
    }

    @Override
    public void setRemovedIE() {
        super.setRemovedIE();
        if (this.level != null && !this.level.isClientSide) {
            indirectConnections.clearDimension(this.level);
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.level != null && !this.level.isClientSide) {
            indirectConnections.clearDimension(this.level);
        }
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (entity instanceof LivingEntity && !((LivingEntity)entity).onClimbable() && this.cover != Blocks.AIR) {
            boolean climb = false;
            for (Predicate<Block> f : climbablePipeCovers) {
                if (f == null || !f.test(this.cover)) continue;
                climb = true;
                break;
            }
            if (climb) {
                IEBaseBlock.IELadderBlock.applyLadderLogic(entity);
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] config = nbt.getIntArray("sideConfig");
        for (int i = 0; i < 6; ++i) {
            Direction curDir = Direction.from3DDataValue((int)i);
            if (i < config.length) {
                boolean connected = config[i] != 0;
                this.sideConfig.put((Object)curDir, connected);
                if (connected) {
                    this.setValidHandler(curDir);
                    continue;
                }
                this.invalidateHandler(curDir);
                continue;
            }
            this.sideConfig.put((Object)curDir, false);
            this.invalidateHandler(curDir);
        }
        Block oldCover = this.cover;
        this.cover = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(nbt.getString("cover")));
        DyeColor oldColor = this.color;
        this.color = nbt.contains("color", 3) ? DyeColor.byId((int)nbt.getInt("color")) : null;
        byte oldConns = this.connections;
        this.connections = nbt.getByte("connections");
        if (this.level != null && this.level.isClientSide && (this.connections != oldConns || this.color != oldColor || this.cover != oldCover)) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] config = new int[6];
        for (int i = 0; i < 6; ++i) {
            if (!this.sideConfig.getBoolean((Object)Direction.from3DDataValue((int)i))) continue;
            config[i] = 1;
        }
        nbt.putIntArray("sideConfig", config);
        if (this.hasCover()) {
            nbt.putString("cover", BuiltInRegistries.BLOCK.getKey((Object)this.cover).toString());
        }
        nbt.putByte("connections", this.connections);
        if (this.color != null) {
            nbt.putInt("color", this.color.getId());
        }
    }

    boolean canOutputPressurized(@Nullable BlockEntity output, boolean consumePower) {
        if (output instanceof IFluidPipe) {
            return ((IFluidPipe)output).canOutputPressurized(consumePower);
        }
        return false;
    }

    private void invalidateHandler(Direction side) {
        IFluidHandler handler = this.sidedHandlers.get(side);
        if (handler != null) {
            this.sidedHandlers.put(side, null);
            this.invalidateCapabilities();
        }
    }

    private void setValidHandler(Direction side) {
        IFluidHandler handler = this.sidedHandlers.get(side);
        if (handler == null) {
            this.sidedHandlers.put(side, new PipeFluidHandler(this, side));
            this.invalidateCapabilities();
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<FluidPipeBlockEntity> registrar) {
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, side) -> {
            if (side != null && be.sideConfig.getBoolean(side)) {
                return be.sidedHandlers.get(side);
            }
            return null;
        });
    }

    protected boolean hasCover() {
        return this.cover != Blocks.AIR;
    }

    @Override
    public Collection<ItemStack> getExtraDrops(Player player, BlockState state) {
        if (this.hasCover()) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this.cover)});
        }
        return null;
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        super.onNeighborBlockChange(otherPos);
        Direction dir = Direction.getNearest((float)(otherPos.getX() - this.worldPosition.getX()), (float)(otherPos.getY() - this.worldPosition.getY()), (float)(otherPos.getZ() - this.worldPosition.getZ()));
        if (this.updateConnectionByte(dir)) {
            Level world = this.getLevelNonnull();
            world.updateNeighborsAtExceptFromFacing(this.worldPosition, this.getBlockState().getBlock(), dir);
            this.markContainingBlockForUpdate(null);
            if (!world.isClientSide) {
                indirectConnections.clearDimension(world);
            }
        }
    }

    public boolean updateConnectionByte(Direction dir) {
        IFluidHandler handler;
        if (this.level == null || this.level.isClientSide || !SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, this.worldPosition.relative(dir))) {
            return false;
        }
        byte oldConn = this.connections;
        int i = dir.get3DDataValue();
        int mask = 1 << i;
        this.connections = (byte)(this.connections & ~mask);
        if (this.sideConfig.getBoolean((Object)dir) && (handler = this.neighbors.get(dir).getCapability()) != null && handler.getTanks() > 0) {
            this.connections = (byte)(this.connections | mask);
        }
        return oldConn != this.connections;
    }

    public byte getAvailableConnectionByte() {
        byte availableConnections = this.connections;
        int mask = 1;
        for (Direction dir : DirectionUtils.VALUES) {
            if ((availableConnections & mask) == 0) {
                if (this.level.getBlockEntity(this.getBlockPos().relative(dir)) instanceof FluidPipeBlockEntity) {
                    availableConnections = (byte)(availableConnections | mask);
                } else {
                    IFluidHandler handler = this.neighbors.get(dir).getCapability();
                    if (handler != null && handler.getTanks() > 0) {
                        availableConnections = (byte)(availableConnections | mask);
                    }
                }
            }
            mask <<= 1;
        }
        return availableConnections;
    }

    public ConnectionStyle getConnectionStyle(Direction connection) {
        if ((this.connections & 1 << connection.get3DDataValue()) == 0) {
            return ConnectionStyle.NO_CONNECTION;
        }
        if (this.connections != 3 && this.connections != 12 && this.connections != 48) {
            return ConnectionStyle.FLANGE;
        }
        BlockEntity con = Utils.getExistingTileEntity(this.level, this.getBlockPos().relative(connection));
        if (con instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity pipe = (FluidPipeBlockEntity)con;
            int tileConnections = pipe.connections | 1 << connection.getOpposite().get3DDataValue();
            if (this.connections == tileConnections) {
                return ConnectionStyle.PLAIN;
            }
        }
        return ConnectionStyle.FLANGE;
    }

    public void toggleSide(Direction side) {
        boolean newSideConnected = !this.sideConfig.getBoolean((Object)side);
        this.setSide(side, newSideConnected);
    }

    public void setSide(Direction side, boolean connectable) {
        this.setSide(side, connectable, true);
    }

    public void setSide(Direction side, boolean connectable, boolean firstPipe) {
        this.sideConfig.put((Object)side, connectable);
        if (connectable) {
            this.setValidHandler(side);
        } else {
            this.invalidateHandler(side);
        }
        this.setChanged();
        if (firstPipe) {
            BlockEntity neighborTile = this.level.getBlockEntity(this.getBlockPos().relative(side));
            if (neighborTile instanceof FluidPipeBlockEntity) {
                ((FluidPipeBlockEntity)neighborTile).setSide(side.getOpposite(), connectable, false);
            }
            this.updateConnectionByte(side);
        }
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(false, this));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        boolean hammer = ctx != null && ctx.isHoldingItem((Item)IEItems.Tools.HAMMER.get());
        return SHAPES.get(new BoundingBoxKey(hammer, this));
    }

    private static List<AABB> getBoxes(BoundingBoxKey key) {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        if (!key.showToolView && key.hasCover) {
            list.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).inflate(-0.03125));
            return list;
        }
        byte availableConnections = key.availableConnections;
        byte activeConnections = key.connections;
        if (key.hasCover) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (Direction d : DirectionUtils.VALUES) {
            int i = d.get3DDataValue();
            if ((availableConnections & 1) == 1 && ((activeConnections & 1) == 1 || key.showToolView)) {
                list.add(new AABB(i == 4 ? 0.0 : (i == 5 ? 0.75 : 0.25), i == 0 ? 0.0 : (i == 1 ? 0.75 : 0.25), i == 2 ? 0.0 : (i == 3 ? 0.75 : 0.25), i == 4 ? 0.25 : (i == 5 ? 1.0 : 0.75), i == 0 ? 0.25 : (i == 1 ? 1.0 : 0.75), i == 2 ? 0.25 : (i == 3 ? 1.0 : 0.75)));
                if (key.connectionStyles.get(d) == ConnectionStyle.FLANGE) {
                    list.add(new AABB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.125), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.125), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.125), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.875), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.875), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.875)));
                }
            }
            availableConnections = (byte)(availableConnections >> 1);
            activeConnections = (byte)(activeConnections >> 1);
        }
        list.add(new AABB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]));
        return list;
    }

    @Override
    public int getRenderColour(int tintIndex) {
        return 0xFFFFFF;
    }

    public void dropCover(Player player) {
        ItemEntity entityitem;
        if (!this.level.isClientSide && this.hasCover() && this.level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (entityitem = player.drop(new ItemStack((ItemLike)this.cover), false)) != null) {
            entityitem.setNoPickUpDelay();
        }
    }

    @Override
    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.isEmpty() && player.isShiftKeyDown() && this.hasCover()) {
            if (!player.level().isClientSide) {
                this.dropCover(player);
                this.cover = Blocks.AIR;
                this.markContainingBlockForUpdate(null);
                this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 255, 0);
                this.markChunkDirty();
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        if (!heldItem.isEmpty() && !player.isShiftKeyDown()) {
            return this.setColorOrCoverFrom(heldItem, player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult setColorOrCoverFrom(ItemStack heldItem, Player player) {
        DyeColor heldDye = Utils.getDye(heldItem);
        if (heldDye != null) {
            if (!player.level().isClientSide) {
                this.color = heldDye;
                this.markChunkDirty();
                this.markContainingBlockForUpdate(null);
                this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 255, 0);
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        Block heldBlock = Block.byItem((Item)heldItem.getItem());
        if (heldBlock == Blocks.AIR) {
            return InteractionResult.PASS;
        }
        for (Predicate<Block> func : validPipeCovers) {
            if (!func.test(heldBlock) || this.cover == heldBlock) continue;
            if (!player.level().isClientSide) {
                this.dropCover(player);
                this.cover = heldBlock;
                this.markChunkDirty();
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                this.markContainingBlockForUpdate(null);
                this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 255, 0);
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            return true;
        }
        hitVec = hitVec.subtract(Vec3.atLowerCornerOf((Vec3i)this.worldPosition));
        Direction fd = side;
        List<AABB> boxes = FluidPipeBlockEntity.getBoxes(new BoundingBoxKey(true, this));
        block0: for (AABB box : boxes) {
            if (!box.inflate(0.002).contains(hitVec)) continue;
            for (Direction d : DirectionUtils.VALUES) {
                Vec3 testVec = new Vec3(0.5 + 0.5 * (double)d.getStepX(), 0.5 + 0.5 * (double)d.getStepY(), 0.5 + 0.5 * (double)d.getStepZ());
                if (!box.inflate(0.002).contains(testVec)) continue;
                fd = d;
                break block0;
            }
        }
        if (fd != null) {
            this.toggleSide(fd);
            this.markContainingBlockForUpdate(null);
            indirectConnections.clearDimension(this.level);
            return true;
        }
        return false;
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        if (level.isClientSide) {
            return;
        }
        if (ctx.getPlayer() != null) {
            InteractionHand otherHand = ctx.getHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            this.setColorOrCoverFrom(ctx.getPlayer().getItemInHand(otherHand), ctx.getPlayer());
        }
        BlockPos pos = ctx.getClickedPos();
        for (Direction dir : Direction.values()) {
            BlockEntity blockEntity = level.getBlockEntity(pos.relative(dir));
            if (!(blockEntity instanceof FluidPipeBlockEntity)) continue;
            FluidPipeBlockEntity neighborPipe = (FluidPipeBlockEntity)blockEntity;
            if (neighborPipe.color == this.color && neighborPipe.sideConfig.getBoolean((Object)dir.getOpposite())) continue;
            this.setSide(dir, false);
        }
    }

    public boolean hasOutputConnection(Direction side) {
        return this.sideConfig.getBoolean((Object)side);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload ev) {
        LevelAccessor levelAccessor;
        if (!ev.getLevel().isClientSide() && (levelAccessor = ev.getLevel()) instanceof Level) {
            Level level = (Level)levelAccessor;
            indirectConnections.clearDimension(level);
        }
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    static class PipeFluidHandler
    implements IFluidHandler {
        private static final Random CURRENT_TICK_RANDOM = new Random();
        FluidPipeBlockEntity pipe;
        Direction facing;

        public PipeFluidHandler(FluidPipeBlockEntity pipe, Direction facing) {
            this.pipe = pipe;
            this.facing = facing;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource == null) {
                return 0;
            }
            int canAccept = resource.getAmount();
            if (canAccept <= 0) {
                return 0;
            }
            Set<DirectionalFluidOutput> outputList = FluidPipeBlockEntity.getConnectedFluidHandlers(this.pipe.getBlockPos(), this.pipe.level);
            if (outputList.isEmpty()) {
                return 0;
            }
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.getBlockPos().relative(this.facing));
            int sum = 0;
            HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
            for (DirectionalFluidOutput output : outputList) {
                int limit;
                int tileSpecificAcceptedFluid;
                int temp;
                BlockPos cc = output.pos;
                if (cc.equals((Object)ccFrom) || !this.pipe.level.hasChunkAt(cc) || this.pipe.getBlockPos().equals((Object)output.pos) || (temp = output.output.fill(Utils.copyFluidStackWithAmount(resource, tileSpecificAcceptedFluid = Math.min(limit = this.getTransferableAmount(resource, output.containingTile), canAccept), output.stripPressure()), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                sorting.put(output, temp);
                sum += temp;
            }
            if (sum > 0) {
                int f = 0;
                for (DirectionalFluidOutput output : sorting.keySet()) {
                    int r;
                    int amount = (Integer)sorting.get(output);
                    if (sum > resource.getAmount()) {
                        int limit = this.getTransferableAmount(resource, output.containingTile);
                        int tileSpecificAcceptedFluid = Math.min(limit, canAccept);
                        float prio = (float)amount / (float)sum;
                        amount = (int)Math.ceil(Mth.clamp((float)amount, (float)1.0f, (float)Math.min((float)resource.getAmount() * prio, (float)tileSpecificAcceptedFluid)));
                        amount = Math.min(amount, canAccept);
                    }
                    if ((r = output.output.fill(Utils.copyFluidStackWithAmount(resource, amount, output.stripPressure()), doFill)) > 50) {
                        this.pipe.canOutputPressurized(output.containingTile, true);
                    }
                    f += r;
                    if ((canAccept -= r) > 0) continue;
                    break;
                }
                return f;
            }
            return 0;
        }

        private int getTransferableAmount(FluidStack resource, @Nullable BlockEntity target) {
            if (target instanceof IPressurizedFluidOutput) {
                IPressurizedFluidOutput pressurizedOutput = (IPressurizedFluidOutput)target;
                return pressurizedOutput.getMaxAcceptedFluidAmount(resource);
            }
            return IFluidPipe.getTransferableAmount(resource.hasTag() && resource.getOrCreateTag().contains("pressurized") || this.pipe.canOutputPressurized(target, false));
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.drain(resource.getAmount(), doDrain);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            Level world = this.pipe.getLevelNonnull();
            ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(FluidPipeBlockEntity.getConnectedFluidHandlers(this.pipe.getBlockPos(), world));
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.getBlockPos().relative(this.facing));
            outputList.removeIf(output -> ccFrom.equals((Object)output.pos));
            if (outputList.size() < 1) {
                return FluidStack.EMPTY;
            }
            CURRENT_TICK_RANDOM.setSeed(HashCommon.mix((long)world.getGameTime()));
            int chosen = outputList.size() == 1 ? 0 : CURRENT_TICK_RANDOM.nextInt(outputList.size());
            DirectionalFluidOutput output2 = (DirectionalFluidOutput)outputList.get(chosen);
            FluidStack available = output2.output.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
            BlockEntity drainingBE = SafeChunkUtils.getSafeBE((LevelAccessor)world, this.pipe.getBlockPos().relative(this.facing));
            int limit = this.getTransferableAmount(available, drainingBE);
            int actualTake = Math.min(limit, maxDrain);
            return output2.output.drain(actualTake, doDrain);
        }
    }

    public record DirectionalFluidOutput(IFluidHandler output, Direction direction, @Nullable BlockEntity containingTile, BlockPos pos) {
        boolean stripPressure() {
            BlockEntity blockEntity = this.containingTile;
            if (blockEntity instanceof IFluidPipe) {
                IFluidPipe pipe = (IFluidPipe)blockEntity;
                return pipe.stripPressureTag();
            }
            return true;
        }
    }

    public static enum ConnectionStyle {
        NO_CONNECTION,
        PLAIN,
        FLANGE;

    }

    private static class BoundingBoxKey {
        private final boolean showToolView;
        private final byte connections;
        private final byte availableConnections;
        private final boolean hasCover;
        private final Map<Direction, ConnectionStyle> connectionStyles = new EnumMap<Direction, ConnectionStyle>(Direction.class);

        private BoundingBoxKey(boolean showToolView, FluidPipeBlockEntity te) {
            this.showToolView = showToolView;
            this.connections = te.connections;
            this.availableConnections = te.getAvailableConnectionByte();
            this.hasCover = te.hasCover();
            for (Direction d : DirectionUtils.VALUES) {
                this.connectionStyles.put(d, te.getConnectionStyle(d));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.showToolView == that.showToolView && this.connections == that.connections && this.availableConnections == that.availableConnections && this.hasCover == that.hasCover && this.connectionStyles.equals(that.connectionStyles);
        }

        public int hashCode() {
            return Objects.hash(this.showToolView, this.connections, this.availableConnections, this.hasCover, this.connectionStyles);
        }
    }
}

