/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class FurnaceHeaterBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction {
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000, FurnaceHeaterBlockEntity.getEnergyIO());
    private final IEnergyStorage energyCap = this.makeEnergyInput(this.energyStorage);
    private final Collection<IEBlockCapabilityCaches.IEBlockCapabilityCache<ExternalHeaterHandler.IExternalHeatable>> heatables = IEBlockCapabilityCaches.allNeighbors(ExternalHeaterHandler.CAPABILITY, this).values();

    public FurnaceHeaterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FURNACE_HEATER.get(), pos, state);
    }

    @Override
    public void tickServer() {
        boolean activeBeforeTick = this.getIsActive();
        boolean redstonePower = this.isRSPowered();
        boolean newActive = activeBeforeTick;
        if (activeBeforeTick && !redstonePower) {
            newActive = false;
        }
        if (this.energyStorage.getEnergyStored() > 3200 || activeBeforeTick) {
            for (IEBlockCapabilityCaches.IEBlockCapabilityCache<ExternalHeaterHandler.IExternalHeatable> capRef : this.heatables) {
                int consumed;
                ExternalHeaterHandler.IExternalHeatable heatable = capRef.getCapability();
                if (heatable == null || (consumed = heatable.doHeatTick(this.energyStorage.getEnergyStored(), redstonePower)) <= 0) continue;
                this.energyStorage.extractEnergy(consumed, false);
                newActive = true;
            }
        }
        if (newActive != activeBeforeTick) {
            this.setActive(newActive);
            this.setChanged();
        }
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<FurnaceHeaterBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> side == null || side == be.getFacing() ? be.energyCap : null);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.isShiftKeyDown();
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        this.setFacing(side);
        return true;
    }

    private static int getEnergyIO() {
        return Math.max(256, Math.max(IEServerConfig.getOrDefault(IEServerConfig.MACHINES.heater_consumption), IEServerConfig.getOrDefault(IEServerConfig.MACHINES.heater_speedupConsumption)));
    }
}

