/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class PipeValveBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IFluidPipe {
    public final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler>> blockFluidHandlers = IEBlockCapabilityCaches.allNeighbors(Capabilities.FluidHandler.BLOCK, this);
    VoxelShape SHAPE_X = Shapes.join((VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.125, (double)0.25, (double)0.25, (double)0.3125, (double)0.75, (double)0.75), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.3125, (double)0.1875, (double)0.1875, (double)0.6875, (double)0.8125, (double)0.8125), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.6875, (double)0.25, (double)0.25, (double)0.875, (double)0.75, (double)0.75), (VoxelShape)Shapes.box((double)0.875, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR);
    VoxelShape SHAPE_Y = Shapes.join((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.3125, (double)0.75), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.1875, (double)0.3125, (double)0.1875, (double)0.8125, (double)0.6875, (double)0.8125), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.25, (double)0.6875, (double)0.25, (double)0.75, (double)0.875, (double)0.75), (VoxelShape)Shapes.box((double)0.125, (double)0.875, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR);
    VoxelShape SHAPE_Z = Shapes.join((VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.125), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.125, (double)0.75, (double)0.75, (double)0.3125), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.1875, (double)0.1875, (double)0.3125, (double)0.8125, (double)0.8125, (double)0.6875), (VoxelShape)Shapes.join((VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.6875, (double)0.75, (double)0.75, (double)0.875), (VoxelShape)Shapes.box((double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR);

    public PipeValveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.PIPE_VALVE.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED_INVERTED;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (ctx == null) {
            return Shapes.block();
        }
        return switch (this.getFacing().getAxis()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> this.SHAPE_X;
            case Direction.Axis.Y -> this.SHAPE_Y;
            case Direction.Axis.Z -> this.SHAPE_Z;
        };
    }

    @Override
    public boolean canOutputPressurized(boolean consumePower) {
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<? extends PipeValveBlockEntity> registrar) {
        registrar.register(Capabilities.FluidHandler.BLOCK, (be, side) -> side == be.getFacing() ? new SidedFluidHandler((PipeValveBlockEntity)be, be.getFacing()) : (side == be.getFacing().getOpposite() ? new SidedFluidHandler((PipeValveBlockEntity)be, be.getFacing().getOpposite()) : null));
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        private boolean inUse = false;
        PipeValveBlockEntity valve;
        @Nullable
        Direction side;

        SidedFluidHandler(PipeValveBlockEntity valve, @Nullable Direction side) {
            this.valve = valve;
            this.side = side;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (this.inUse || this.valve.isRSPowered() || resource.isEmpty() || this.side == null || !this.side.equals((Object)this.valve.getFacing().getOpposite())) {
                return 0;
            }
            this.inUse = true;
            IEBlockCapabilityCaches.IEBlockCapabilityCache<IFluidHandler> capRef = this.valve.blockFluidHandlers.get(this.valve.getFacing());
            IFluidHandler handler = capRef.getCapability();
            int filled = 0;
            if (handler != null) {
                filled = handler.fill(resource, doFill);
            }
            this.inUse = false;
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (this.inUse || this.valve.isRSPowered() || resource.isEmpty() || this.side == null || !this.side.equals((Object)this.valve.getFacing())) {
                return FluidStack.EMPTY;
            }
            this.inUse = true;
            IFluidHandler input = this.valve.blockFluidHandlers.get(this.valve.getFacing().getOpposite()).getCapability();
            FluidStack drained = input != null ? input.drain(resource, doDrain) : FluidStack.EMPTY;
            this.inUse = false;
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (this.inUse || this.valve.isRSPowered() || this.side == null || !this.side.equals((Object)this.valve.getFacing())) {
                return FluidStack.EMPTY;
            }
            this.inUse = true;
            IFluidHandler input = this.valve.blockFluidHandlers.get(this.valve.getFacing().getOpposite()).getCapability();
            FluidStack drained = input != null ? input.drain(maxDrain, doDrain) : FluidStack.EMPTY;
            this.inUse = false;
            return drained;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }
    }
}

