/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SampleDrillBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IModelOffsetProvider {
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(8000);
    public int dummy = 0;
    public int process = 0;
    public boolean isRunning = false;
    @Nonnull
    public ItemStack sample = ItemStack.EMPTY;
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, SampleDrillBlockEntity::master, this.makeEnergyInput(this.energyStorage));
    public AABB renderAABB;

    public SampleDrillBlockEntity(BlockEntityType<SampleDrillBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean canTickAny() {
        return this.sample.isEmpty();
    }

    @Override
    public void tickClient() {
        if (this.isRunning) {
            ++this.process;
            if ((double)this.process <= 0.5 * (double)((Integer)IEServerConfig.MACHINES.coredrill_time.get()).intValue()) {
                this.level.addAlwaysVisibleParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.COBBLESTONE)), (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.125, (double)this.getBlockPos().getZ() + 0.5, ApiUtils.RANDOM.nextDouble() * 0.125 - 0.0625, 0.0625, ApiUtils.RANDOM.nextDouble() * 0.125 - 0.0625);
            }
        }
    }

    @Override
    public void tickServer() {
        boolean canRun;
        int consumption = (Integer)IEServerConfig.MACHINES.coredrill_consumption.get();
        int totalTime = (Integer)IEServerConfig.MACHINES.coredrill_time.get();
        boolean bl = canRun = this.process > 0 && this.process < totalTime && this.energyStorage.getEnergyStored() >= consumption && !this.isRSPowered() && !this.level.isEmptyBlock(this.getBlockPos().offset(0, -1, 0));
        if (canRun && this.energyStorage.extractEnergy(consumption, false) == consumption) {
            ++this.process;
            if (this.process >= totalTime) {
                MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.level, this.getBlockPos());
                this.sample = this.createCoreSample(info);
                this.process = 0;
                canRun = false;
                this.markContainingBlockForUpdate(null);
            }
            this.markChunkDirty();
        }
        if (canRun != this.isRunning) {
            this.isRunning = canRun;
            this.markChunkDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)((Integer)IEServerConfig.MACHINES.coredrill_time.get()).intValue();
    }

    public boolean isSamplingFinished() {
        return this.process >= (Integer)IEServerConfig.MACHINES.coredrill_time.get();
    }

    @Nullable
    public List<CoresampleItem.VeinSampleData> getVein() {
        if (this.sample.isEmpty()) {
            return null;
        }
        return CoresampleItem.getVeins(this.level, this.sample);
    }

    @Nonnull
    public ItemStack createCoreSample(@Nullable MineralWorldInfo info) {
        ItemStack stack = new ItemStack(IEItems.Misc.CORESAMPLE);
        ItemNBTHelper.putLong(stack, "timestamp", this.level.getGameTime());
        CoresampleItem.setDimension(stack, (ResourceKey<Level>)this.level.dimension());
        CoresampleItem.setCoords(stack, this.getBlockPos());
        CoresampleItem.setMineralInfo(this.level, stack, info, this.getBlockPos());
        return stack;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        nbt.putInt("dummy", this.dummy);
        nbt.putInt("process", this.process);
        nbt.putBoolean("isRunning", this.isRunning);
        if (!this.sample.isEmpty()) {
            nbt.put("sample", (Tag)this.sample.save(new CompoundTag()));
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        this.dummy = nbt.getInt("dummy");
        this.process = nbt.getInt("process");
        this.isRunning = nbt.getBoolean("isRunning");
        this.sample = nbt.contains("sample", 10) ? ItemStack.of((CompoundTag)nbt.getCompound("sample")) : ItemStack.EMPTY;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<SampleDrillBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> side == null || be.dummy == 0 && side.getAxis().isHorizontal() ? be.energyCap.get() : null);
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    @Nullable
    public SampleDrillBlockEntity master() {
        SampleDrillBlockEntity drill;
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.getBlockPos().below(this.dummy);
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof SampleDrillBlockEntity ? (drill = (SampleDrillBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.level.setBlockAndUpdate(this.worldPosition.offset(0, i, 0), state);
            ((SampleDrillBlockEntity)this.level.getBlockEntity((BlockPos)this.worldPosition.offset((int)0, (int)i, (int)0))).dummy = i;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.level.getBlockEntity(this.getBlockPos().offset(0, -this.dummy, 0).offset(0, i, 0)) instanceof SampleDrillBlockEntity)) continue;
            this.level.removeBlock(this.getBlockPos().offset(0, -this.dummy, 0).offset(0, i, 0), false);
        }
    }

    @Override
    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        BlockEntity te;
        if (this.dummy != 0 && (te = this.level.getBlockEntity(this.getBlockPos().offset(0, -this.dummy, 0))) instanceof SampleDrillBlockEntity) {
            return ((SampleDrillBlockEntity)te).interact(side, player, hand, heldItem, hitX, hitY, hitZ);
        }
        if (!this.sample.isEmpty()) {
            if (!this.level.isClientSide) {
                player.spawnAtLocation(this.sample.copy(), 0.5f);
                this.sample = ItemStack.EMPTY;
                this.setChanged();
                this.markContainingBlockForUpdate(null);
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        if (this.process <= 0) {
            if (!this.level.isClientSide && this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.coredrill_consumption.get()) {
                this.process = 1;
                this.setChanged();
                this.markContainingBlockForUpdate(null);
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return new BlockPos(0, this.dummy, 0);
    }
}

