/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.metal.StructuralArmBlock;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StructuralArmBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.IBlockBounds {
    private int totalLength = 1;
    private int slopePosition = 0;
    private Direction facing = null;
    private boolean onCeiling = false;
    private static final CachedShapesWithTransform<ShapeKey, Direction> SHAPES = CachedShapesWithTransform.createDirectional(key -> StructuralArmBlockEntity.getBounds(key.slopePos(), key.slopeLength(), key.onCeiling()));

    public StructuralArmBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.STRUCTURAL_ARM.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int oldLength = this.totalLength;
        int oldPos = this.slopePosition;
        this.totalLength = nbt.getInt("totalLength");
        this.slopePosition = nbt.getInt("slopePosition");
        this.onCeiling = nbt.getBoolean("onCeiling");
        if (this.level != null && this.level.isClientSide && (oldLength != this.totalLength || this.slopePosition != oldPos)) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
        this.facing = nbt.contains("facing", 3) ? DirectionUtils.VALUES[nbt.getInt("facing")] : null;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.putInt("totalLength", this.totalLength);
        nbt.putInt("slopePosition", this.slopePosition);
        if (this.facing != null) {
            nbt.putInt("facing", this.facing.ordinal());
        }
        nbt.putBoolean("onCeiling", this.onCeiling);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        boolean atEnd;
        boolean positive;
        super.onNeighborBlockChange(otherPos);
        if (this.level.isClientSide) {
            return;
        }
        if (otherPos.equals((Object)this.worldPosition.relative(this.getFacing(), 1))) {
            positive = true;
        } else if (otherPos.equals((Object)this.worldPosition.relative(this.getFacing(), -1))) {
            positive = false;
        } else {
            return;
        }
        StructuralArmBlockEntity slope = null;
        BlockEntity atOther = this.level.getBlockEntity(otherPos);
        if (atOther instanceof StructuralArmBlockEntity) {
            StructuralArmBlockEntity tmp = (StructuralArmBlockEntity)atOther;
            BlockState stateHere = this.level.getBlockState(this.worldPosition);
            BlockState stateThere = this.level.getBlockState(otherPos);
            if (tmp.getFacing() == this.getFacing() && stateHere.getBlock() == stateThere.getBlock() && tmp.onCeiling == this.onCeiling) {
                slope = (StructuralArmBlockEntity)atOther;
            }
        }
        if ((atEnd = this.isAtEnd(positive)) == (slope == null)) {
            return;
        }
        if (slope == null) {
            int toEnd = this.blocksToEnd(positive);
            this.forEachSlopeBlockBeyond(positive, false, true, other -> {
                other.totalLength = toEnd - 1;
                if (positive) {
                    other.slopePosition -= this.slopePosition + 2;
                }
                this.updateNoNeighbours(other.worldPosition);
            });
            this.forEachSlopeBlockBeyond(!positive, true, true, other -> {
                other.totalLength = this.totalLength - toEnd;
                if (!positive) {
                    other.slopePosition -= this.slopePosition;
                }
                this.updateNoNeighbours(other.worldPosition);
            });
        } else {
            int oldLength = this.totalLength;
            if (!positive) {
                this.slopePosition += slope.totalLength;
            }
            this.totalLength += slope.totalLength;
            this.forEachSlopeBlockBeyond(positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (positive) {
                    other.slopePosition += oldLength;
                }
                this.updateNoNeighbours(other.worldPosition);
            });
            this.forEachSlopeBlockBeyond(!positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (!positive) {
                    other.slopePosition += this.totalLength - oldLength;
                }
                this.updateNoNeighbours(other.worldPosition);
            });
        }
        this.updateNoNeighbours(this.worldPosition);
    }

    private boolean isAtEnd(boolean positive) {
        if (positive) {
            return this.slopePosition == this.totalLength - 1;
        }
        return this.slopePosition == 0;
    }

    private int blocksToEnd(boolean positive) {
        if (positive) {
            return this.totalLength - this.slopePosition - 1;
        }
        return this.slopePosition;
    }

    private void forEachSlopeBlockBeyond(boolean positive, boolean includeThis, boolean removing, Consumer<StructuralArmBlockEntity> out) {
        if (positive) {
            for (int i = 1; i < this.totalLength - this.slopePosition; ++i) {
                this.acceptIfValid(i, removing, out);
            }
        } else {
            for (int i = -1; i >= -this.slopePosition; --i) {
                this.acceptIfValid(i, removing, out);
            }
        }
        if (includeThis) {
            out.accept(this);
        }
    }

    private void acceptIfValid(int offsetToHere, boolean removing, Consumer<StructuralArmBlockEntity> out) {
        BlockPos posI = this.worldPosition.relative(this.getFacing(), offsetToHere);
        BlockEntity teAtI = this.level.getBlockEntity(posI);
        if (teAtI instanceof StructuralArmBlockEntity) {
            StructuralArmBlockEntity slope = (StructuralArmBlockEntity)teAtI;
            int offsetAtPos = this.slopePosition + offsetToHere;
            BlockState stateHere = this.level.getBlockState(this.worldPosition);
            BlockState stateThere = this.level.getBlockState(posI);
            if ((!removing || slope.totalLength == this.totalLength && slope.slopePosition == offsetAtPos) && slope.onCeiling == this.onCeiling && stateHere.getBlock() == stateThere.getBlock() && slope.getFacing() == this.getFacing()) {
                out.accept(slope);
            }
        }
    }

    private void updateNoNeighbours(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        this.level.sendBlockUpdated(pos, state, state, 3);
    }

    @Override
    public Direction getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacing();
    }

    @Override
    public void setFacing(Direction facing) {
        IEBlockInterfaces.IStateBasedDirectional.super.setFacing(facing);
        this.facing = null;
        this.totalLength = 1;
        this.slopePosition = 0;
        if (this.level != null) {
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return StructuralArmBlock.FACING;
    }

    @Override
    public Direction getFacingForPlacement(BlockPlaceContext ctx) {
        Direction side = ctx.getClickedFace();
        double relativeClickY = ctx.getClickLocation().y - (double)ctx.getClickedPos().getY();
        this.onCeiling = side == Direction.DOWN || side != Direction.UP && relativeClickY > 0.5;
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacingForPlacement(ctx);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(new ShapeKey(this.slopePosition, this.totalLength, this.onCeiling), this.getFacing());
    }

    private static List<AABB> getBounds(int slopePosition, int totalLength, boolean onCeiling) {
        double lowerH = ((double)slopePosition + 0.5) / (double)totalLength;
        double upperH = ((double)slopePosition + 1.0) / (double)totalLength;
        if (!onCeiling) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, lowerH, 1.0), (Object)new AABB(0.0, lowerH, 0.0, 1.0, upperH, 0.5));
        }
        return ImmutableList.of((Object)new AABB(0.0, 1.0 - lowerH, 0.0, 1.0, 1.0, 1.0), (Object)new AABB(0.0, 1.0 - upperH, 0.0, 1.0, 1.0 - lowerH, 0.5));
    }

    public int getSlopePosition() {
        return this.slopePosition;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public boolean isOnCeiling() {
        return this.onCeiling;
    }

    private record ShapeKey(int slopePos, int slopeLength, boolean onCeiling) {
    }
}

