/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.AbstractTransformerBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TransformerBlockEntity
extends AbstractTransformerBlockEntity
implements IEBlockInterfaces.IMirrorAble,
IEBlockInterfaces.IHasDummyBlocks,
IModelOffsetProvider,
IEBlockInterfaces.IBlockBounds {
    public int dummy = 0;
    private static final CachedShapesWithTransform<ShapeKey, Pair<Direction, Boolean>> SHAPES = new CachedShapesWithTransform<ShapeKey, Pair>(key -> ImmutableList.of((Object)new AABB(0.0, 0.0, 0.3125, 0.375, key.lowerHeight, 0.6875), (Object)new AABB(0.625, 0.0, 0.3125, 1.0, key.higherHeight, 0.6875)), (pair, aabb) -> CachedShapesWithTransform.withFacingAndMirror(aabb, (Direction)pair.getFirst(), (Boolean)pair.getSecond()));

    public TransformerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TransformerBlockEntity>)((BlockEntityType)IEBlockEntities.TRANSFORMER.get()), pos, state);
    }

    public TransformerBlockEntity(BlockEntityType<? extends TransformerBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ImmersiveConnectableBlockEntity>)type, pos, state);
        this.dummy = (Boolean)state.getValue((Property)IEProperties.MULTIBLOCKSLAVE) != false ? 1 : 0;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.putInt("dummy", this.dummy);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.dummy = nbt.getInt("dummy");
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.getBlockPos().offset(0, -this.dummy, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (this.dummy == 2) {
            BlockEntity master = this.level.getBlockEntity(this.getBlockPos().offset(0, -this.dummy, 0));
            return master instanceof TransformerBlockEntity && ((TransformerBlockEntity)master).canConnectCable(cableType, target, new Vec3i(0, 2, 0));
        }
        return super.canConnectCable(cableType, target, offset);
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        if (this.dummy != 0) {
            BlockEntity master = this.level.getBlockEntity(this.getBlockPos().offset(0, -this.dummy, 0));
            if (master instanceof TransformerBlockEntity) {
                ((TransformerBlockEntity)master).connectCable(cableType, target, other, otherTarget);
            }
        } else {
            super.connectCable(cableType, target, other, otherTarget);
        }
    }

    @Override
    protected Vec3 getConnectionOffset(WireType type, boolean right) {
        double offset;
        double conRadius = type.getRenderDiameter() / 2.0;
        double d = offset = this.getHigherWiretype().equals(type.getCategory()) ? (double)this.getHigherOffset() : (double)this.getLowerOffset();
        if (this.getFacing() == Direction.NORTH) {
            return new Vec3(right ? 0.8125 : 0.1875, 2.0 + offset - conRadius, 0.5);
        }
        if (this.getFacing() == Direction.SOUTH) {
            return new Vec3(right ? 0.1875 : 0.8125, 2.0 + offset - conRadius, 0.5);
        }
        if (this.getFacing() == Direction.WEST) {
            return new Vec3(0.5, 2.0 + offset - conRadius, right ? 0.1875 : 0.8125);
        }
        if (this.getFacing() == Direction.EAST) {
            return new Vec3(0.5, 2.0 + offset - conRadius, right ? 0.8125 : 0.1875);
        }
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo target, Vec3i offset) {
        if (offset.getY() != 2) {
            return null;
        }
        ConnectionPoint leftCP = new ConnectionPoint(this.worldPosition, 1);
        ConnectionPoint rightCP = new ConnectionPoint(this.worldPosition, 0);
        boolean leftEmpty = this.getLocalNet(1).getConnections(leftCP).stream().allMatch(Connection::isInternal);
        boolean rightEmpty = this.getLocalNet(0).getConnections(rightCP).stream().allMatch(Connection::isInternal);
        if (leftEmpty && !rightEmpty) {
            return leftCP;
        }
        if (!leftEmpty && rightEmpty) {
            return rightCP;
        }
        Direction facing = this.getFacing();
        double hitPos = facing.getAxis() == Direction.Axis.X ? (double)target.hitZ : (double)(1.0f - target.hitX);
        if (hitPos < 0.5 == (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE)) {
            return leftCP;
        }
        return rightCP;
    }

    @Override
    protected void updateMirrorState() {
        if (this.dummy != 0) {
            BlockEntity master = this.level.getBlockEntity(this.worldPosition.below(this.dummy));
            if (master instanceof TransformerBlockEntity) {
                ((TransformerBlockEntity)master).updateMirrorState();
            }
        } else if (this.rightType != null || this.leftType != null) {
            String higher = this.getHigherWiretype();
            boolean intendedState = this.rightType != null && higher.equals(this.rightType.getCategory()) || this.leftType != null && !higher.equals(this.leftType.getCategory());
            for (int i = 0; i < 3; ++i) {
                BlockEntity te = this.level.getBlockEntity(this.worldPosition.above(i));
                if (!(te instanceof TransformerBlockEntity)) continue;
                ((TransformerBlockEntity)te).setMirrored(intendedState);
            }
        }
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.getBlockPos().below(this.dummy);
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        int i = 1;
        while (i <= 2) {
            BlockPos dummyPos = this.worldPosition.above(i);
            this.level.setBlockAndUpdate(dummyPos, IEBaseBlock.applyLocationalWaterlogging(state, this.level, dummyPos));
            ((TransformerBlockEntity)this.level.getBlockEntity((BlockPos)dummyPos)).dummy = i++;
            ((TransformerBlockEntity)this.level.getBlockEntity(dummyPos)).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            this.level.removeBlock(this.getBlockPos().offset(0, -this.dummy, 0).offset(0, i, 0), false);
        }
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (this.dummy == 2) {
            return SHAPES.get(new ShapeKey(this.getLowerOffset(), this.getHigherOffset()), (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)(!this.getIsMirrored() ? 1 : 0)));
        }
        return Shapes.block();
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.worldPosition.above(2));
    }

    protected float getLowerOffset() {
        return 0.5f;
    }

    protected float getHigherOffset() {
        return 0.5625f;
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        if (this.isDummy()) {
            return ImmutableList.of();
        }
        return super.getConnectionPoints();
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.isDummy()) {
            return ImmutableList.of();
        }
        return super.getInternalConnections();
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return new BlockPos(0, this.dummy, 0);
    }

    private static class ShapeKey {
        private final double lowerHeight;
        private final double higherHeight;

        private ShapeKey(double lowerHeight, double higherHeight) {
            this.lowerHeight = lowerHeight;
            this.higherHeight = higherHeight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShapeKey shapeKey = (ShapeKey)o;
            return Double.compare(shapeKey.lowerHeight, this.lowerHeight) == 0 && Double.compare(shapeKey.higherHeight, this.higherHeight) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.lowerHeight, this.higherHeight);
        }
    }
}

