/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class TurretBlockEntity<T extends TurretBlockEntity<T>>
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IIEInventory,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IInteractionObjectIE<T>,
IEBlockInterfaces.IEntityProof,
IEBlockInterfaces.IScrewdriverInteraction,
IModelOffsetProvider {
    public static final int ENERGY_CAPACITY = 16000;
    public MutableEnergyStorage energyStorage;
    public boolean redstoneControlInverted;
    public String owner;
    public List<String> targetList;
    public boolean whitelist;
    public boolean attackAnimals;
    public boolean attackPlayers;
    public boolean attackNeutrals;
    protected int tick;
    protected LivingEntity target;
    public float rotationYaw;
    public float rotationPitch;
    private UUID targetId;
    public AABB renderBB;
    private final MultiblockCapability<IEnergyStorage> energyCap;

    /*
     * Exception decompiling
     */
    public TurretBlockEntity(BlockEntityType<T> type, BlockPos pos, BlockState state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void tickClient() {
        this.tickCommon();
    }

    public void tickCommon() {
        double range = this.getRange();
        if (this.targetId != null) {
            AABB validBox = Shapes.block().bounds().move(this.worldPosition).inflate(range);
            List entities = this.level.getEntitiesOfClass(LivingEntity.class, validBox);
            for (LivingEntity entity : entities) {
                if (!entity.getUUID().equals(this.targetId) || !this.isValidTarget(entity, true)) continue;
                this.target = entity;
                break;
            }
            this.targetId = null;
        }
        if (this.target != null) {
            Vec3 delta = this.getGunToTargetVec(this.target);
            double dSq = delta.lengthSqr();
            if (dSq > range * range) {
                this.target = null;
            } else if (this.level.isClientSide) {
                double yaw = Mth.atan2((double)delta.x, (double)delta.z) * 57.29577951308232 - 180.0;
                this.rotationPitch = (float)(Math.atan2(Math.sqrt(delta.x * delta.x + delta.z * delta.z), delta.y) * 57.29577951308232) - 90.0f;
                float defaultYaw = 180.0f - this.getFacing().toYRot();
                this.rotationYaw = this.rotationYaw == 0.0f ? (float)(yaw * 0.5) - defaultYaw : (float)yaw - defaultYaw;
            }
        } else if (this.level.isClientSide) {
            this.rotationYaw = (float)((double)this.rotationYaw * 0.75);
            if (Math.abs(this.rotationYaw) < 10.0f) {
                this.rotationYaw = 0.0f;
            }
            this.rotationPitch = (float)((double)this.rotationPitch * 0.75);
            if (Math.abs(this.rotationPitch) < 10.0f) {
                this.rotationPitch = 0.0f;
            }
        }
    }

    @Override
    public void tickServer() {
        this.tickCommon();
        if (this.level.getGameTime() % 64L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x3F)) {
            this.markContainingBlockForUpdate(null);
        }
        int energy = (Integer)IEServerConfig.MACHINES.turret_consumption.get();
        if (this.isRSPowered() ^ this.redstoneControlInverted) {
            if (this.energyStorage.extractEnergy(energy, true) == energy) {
                this.energyStorage.extractEnergy(energy, false);
                if (this.target == null || !this.target.isAlive() || this.level.getEntity(this.target.getId()) == null || this.target.getHealth() <= 0.0f || !this.canShootEntity(this.target)) {
                    this.target = this.getTarget();
                    if (this.target != null) {
                        this.setChanged();
                        this.markContainingBlockForUpdate(null);
                    }
                }
                if (this.target != null && this.canActivate()) {
                    ++this.tick;
                    int chargeup = this.getChargeupTicks();
                    if (this.tick == chargeup) {
                        this.activate();
                    } else if (this.tick > chargeup) {
                        if (this.loopActivation()) {
                            this.activate();
                        } else if (this.tick == chargeup + this.getActiveTicks()) {
                            this.tick = 0;
                        }
                    }
                } else {
                    this.tick = 0;
                }
            }
        } else if (this.target != null) {
            this.target = null;
        }
    }

    private boolean canShootEntity(LivingEntity entity) {
        Vec3 end;
        Vec3 start = this.getGunPosition();
        if (Utils.rayTraceForFirst(start, end = this.getTargetVector(entity), this.level, Collections.singleton(this.getBlockPos().above())) != null) {
            return false;
        }
        AABB potentialCollateralArea = entity.getBoundingBox().minmax(new AABB(this.worldPosition.above()));
        List potentialCollateral = this.level.getEntitiesOfClass(LivingEntity.class, potentialCollateralArea);
        for (LivingEntity coll : potentialCollateral) {
            AABB entityBB = coll.getBoundingBox().inflate(0.4625);
            if (this.isValidTarget(coll, false) || !entityBB.clip(start, end).isPresent()) continue;
            return false;
        }
        return true;
    }

    protected Vec3 getTargetVector(LivingEntity e) {
        return new Vec3(e.getX(), e.getY() + 0.5 * (double)e.getEyeHeight(), e.getZ());
    }

    protected Vec3 getGunPosition() {
        return new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.375, (double)this.worldPosition.getZ() + 0.5);
    }

    protected Vec3 getGunToTargetVec(LivingEntity target) {
        return this.getGunPosition().vectorTo(this.getTargetVector(target));
    }

    @Nullable
    private LivingEntity getTarget() {
        double range = this.getRange();
        List list = this.level.getEntitiesOfClass(LivingEntity.class, new AABB((double)this.getBlockPos().getX() - range, (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ() - range, (double)this.getBlockPos().getX() + range, (double)(this.getBlockPos().getY() + 3), (double)this.getBlockPos().getZ() + range));
        if (list.isEmpty()) {
            return null;
        }
        for (LivingEntity entity : list) {
            if (!this.isValidTarget(entity, true)) continue;
            return entity;
        }
        return null;
    }

    public boolean isValidTarget(LivingEntity entity, boolean checkCanShoot) {
        LivingEntity entityOwner;
        boolean isListed;
        if (entity == null || !entity.isAlive() || entity.getHealth() <= 0.0f) {
            return false;
        }
        boolean bl = isListed = this.isListedName(this.targetList, entity.getName().getString()) || this.isListedName(this.targetList, entity.getType().getDescription().getString());
        if (this.whitelist ^ isListed) {
            return false;
        }
        if (entity instanceof TamableAnimal && (entityOwner = ((TamableAnimal)entity).getOwner()) != null && this.whitelist ^ this.isListedName(this.targetList, entityOwner.getName().getString())) {
            return false;
        }
        if (entity instanceof Animal && !this.attackAnimals) {
            return false;
        }
        if (entity instanceof Player && !this.attackPlayers) {
            return false;
        }
        if (!(entity instanceof Player || entity instanceof Animal || entity instanceof Enemy || this.attackNeutrals)) {
            return false;
        }
        if (this.target == null || this.getBlockPos().distToCenterSqr((Position)entity.position()) < this.getBlockPos().distToCenterSqr((Position)this.target.position())) {
            return true;
        }
        return !checkCanShoot || this.canShootEntity(entity);
    }

    private boolean isListedName(List<String> list, String name) {
        for (String s : list) {
            if (!name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected abstract double getRange();

    protected abstract boolean canActivate();

    protected abstract int getChargeupTicks();

    protected abstract int getActiveTicks();

    protected abstract boolean loopActivation();

    protected abstract void activate();

    protected boolean hasOwnerRights(Player player) {
        if (player.getAbilities().instabuild || this.owner == null || this.owner.isEmpty()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.getName().getString());
    }

    public void resetTarget() {
        this.target = null;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        if (nbt.contains("owner", 8)) {
            this.owner = nbt.getString("owner");
        }
        ListTag list = nbt.getList("targetList", 8);
        this.targetList.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.targetList.add(list.getString(i));
        }
        this.whitelist = nbt.getBoolean("whitelist");
        this.attackAnimals = nbt.getBoolean("attackAnimals");
        this.attackPlayers = nbt.getBoolean("attackPlayers");
        this.attackNeutrals = nbt.getBoolean("attackNeutrals");
        this.target = null;
        if (nbt.contains("target", 8)) {
            this.targetId = UUID.fromString(nbt.getString("target"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.putBoolean("redstoneInverted", this.redstoneControlInverted);
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        if (this.owner != null) {
            nbt.putString("owner", this.owner);
        }
        ListTag list = new ListTag();
        for (String s : this.targetList) {
            list.add((Object)StringTag.valueOf((String)s));
        }
        nbt.put("targetList", (Tag)list);
        nbt.putBoolean("whitelist", this.whitelist);
        nbt.putBoolean("attackAnimals", this.attackAnimals);
        nbt.putBoolean("attackPlayers", this.attackPlayers);
        nbt.putBoolean("attackNeutrals", this.attackNeutrals);
        if (this.target != null) {
            nbt.putString("target", this.target.getUUID().toString());
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (!this.isDummy()) {
            return Shapes.block();
        }
        switch (this.getFacing()) {
            case NORTH: {
                return Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.875, (double)1.0);
            }
            case SOUTH: {
                return Shapes.box((double)0.125, (double)0.0625, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
            }
            case WEST: {
                return Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)1.0, (double)0.875, (double)0.875);
            }
            case EAST: {
                return Shapes.box((double)0.0, (double)0.0625, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
        }
        return Shapes.block();
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.isDummy()) {
            BlockEntity te = this.level.getBlockEntity(this.getBlockPos().below());
            if (te instanceof TurretBlockEntity) {
                return ((TurretBlockEntity)te).screwdriverUseSide(side, player, hand, hitVec);
            }
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && !this.level.isClientSide) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
            this.setChanged();
            this.markContainingBlockForUpdate(null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.create();
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Override
    public boolean canUseGui(Player player) {
        if (this.hasOwnerRights(player)) {
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.notOwner", (Object[])new Object[]{this.owner}), true);
        return false;
    }

    @Override
    public T getGuiMaster() {
        if (!this.isDummy()) {
            return (T)this;
        }
        BlockEntity te = this.level.getBlockEntity(this.getBlockPos().below());
        if (te instanceof TurretBlockEntity) {
            return (T)((TurretBlockEntity)te);
        }
        return null;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        BlockEntity te;
        if (this.isDummy() && (te = this.level.getBlockEntity(this.getBlockPos().below())) instanceof TurretBlockEntity) {
            return ((TurretBlockEntity)te).canEntityDestroy(entity);
        }
        if (entity instanceof Player) {
            return this.hasOwnerRights((Player)entity);
        }
        return true;
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.getBlockState().getValue((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public TurretBlockEntity<T> master() {
        if (!this.isDummy()) {
            return this;
        }
        IEBlockInterfaces.IGeneralMultiblock iGeneralMultiblock = this.tempMasterBE;
        if (iGeneralMultiblock instanceof TurretBlockEntity) {
            TurretBlockEntity turret = (TurretBlockEntity)iGeneralMultiblock;
            return turret;
        }
        BlockPos masterPos = this.getBlockPos().below();
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return this.getClass().isInstance(te) ? (TurretBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        this.level.setBlockAndUpdate(this.worldPosition.above(), (BlockState)this.getBlockState().setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        BlockPos otherPos;
        this.tempMasterBE = this.master();
        BlockPos blockPos = otherPos = this.isDummy() ? this.getBlockPos().below() : this.getBlockPos().above();
        if (this.level.getBlockEntity(otherPos) instanceof TurretBlockEntity) {
            this.level.removeBlock(otherPos, false);
        }
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        Entity player = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        ItemStack stack = new ItemStack((ItemLike)state.getBlock(), 1);
        IEBlockInterfaces.IGeneralMultiblock turret = this;
        if (this.isDummy() && (turret = this.master()) == null) {
            drop.accept(stack);
            return;
        }
        CompoundTag tag = new CompoundTag();
        if (!(turret.owner == null || player != null && player.getName().getString().equalsIgnoreCase(turret.owner))) {
            tag.putString("owner", turret.owner);
        }
        if (turret.targetList.size() != 1 || !this.isListedName(turret.targetList, turret.owner)) {
            ListTag list = new ListTag();
            for (String s : turret.targetList) {
                list.add((Object)StringTag.valueOf((String)s));
            }
            tag.put("targetList", (Tag)list);
        }
        if (turret.whitelist) {
            tag.putBoolean("whitelist", turret.whitelist);
        }
        if (turret.attackAnimals) {
            tag.putBoolean("attackAnimals", turret.attackAnimals);
        }
        if (!turret.attackPlayers) {
            tag.putBoolean("attackPlayers", turret.attackPlayers);
        }
        if (turret.attackNeutrals) {
            tag.putBoolean("attackNeutrals", turret.attackNeutrals);
        }
        if (turret.redstoneControlInverted) {
            tag.putBoolean("redstoneControlInverted", turret.redstoneControlInverted);
        }
        if (!tag.isEmpty()) {
            stack.setTag(tag);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        Player placer = ctx.getPlayer();
        if (stack.hasTag()) {
            CompoundTag tag = stack.getOrCreateTag();
            if (tag.contains("owner", 8)) {
                this.owner = tag.getString("owner");
            } else if (placer != null) {
                this.owner = placer.getName().getString();
            }
            if (tag.contains("targetList", 9)) {
                ListTag list = tag.getList("targetList", 8);
                this.targetList.clear();
                for (int i = 0; i < list.size(); ++i) {
                    this.targetList.add(list.getString(i));
                }
            } else if (this.owner != null) {
                this.targetList.add(this.owner);
            }
            if (tag.contains("whitelist", 1)) {
                this.whitelist = tag.getBoolean("whitelist");
            }
            if (tag.contains("attackAnimals", 1)) {
                this.attackAnimals = tag.getBoolean("attackAnimals");
            }
            if (tag.contains("attackPlayers", 1)) {
                this.attackPlayers = tag.getBoolean("attackPlayers");
            }
            if (tag.contains("attackNeutrals", 1)) {
                this.attackNeutrals = tag.getBoolean("attackNeutrals");
            }
            if (tag.contains("redstoneControlInverted", 1)) {
                this.redstoneControlInverted = tag.getBoolean("redstoneControlInverted");
            }
        } else if (placer != null) {
            this.owner = placer.getName().getString();
            this.targetList.add(this.owner);
        }
    }

    protected static <T extends TurretBlockEntity<T>> void registerCapabilitiesBase(BlockCapabilityRegistration.BECapabilityRegistrar<T> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> {
            if (side != null || !be.isDummy()) {
                return be.energyCap.get();
            }
            return null;
        });
    }

    public void setDummy(boolean dummy) {
        BlockState old = this.getBlockState();
        BlockState newState = (BlockState)old.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(dummy));
        this.level.setBlockAndUpdate(this.worldPosition, newState);
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return new BlockPos(0, 1, 0);
        }
        return BlockPos.ZERO;
    }
}

