/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.client.render.conveyor.RedstoneConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "redstone");
    public static final IConveyorType<RedstoneConveyor> TYPE = new BasicConveyorType<RedstoneConveyor>(NAME, false, true, RedstoneConveyor::new, () -> new RedstoneConveyorRender(texture_on, texture_off), false);
    private boolean panelRight = true;
    private static final Map<Direction, VoxelShape> WALL_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)13.0, (double)2.0, (double)5.0, (double)16.0, (double)16.0, (double)14.5), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)2.0, (double)1.5, (double)3.0, (double)16.0, (double)11.0), (Object)Direction.WEST, (Object)Block.box((double)5.0, (double)2.0, (double)0.0, (double)14.5, (double)16.0, (double)3.0), (Object)Direction.EAST, (Object)Block.box((double)1.5, (double)2.0, (double)13.0, (double)11.0, (double)16.0, (double)16.0)));

    public RedstoneConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<RedstoneConveyor> getType() {
        return TYPE;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    @Override
    public boolean isActive() {
        return !this.isPowered();
    }

    @Override
    public boolean playerInteraction(Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        if (super.playerInteraction(player, hand, heldItem, hitX, hitY, hitZ, side)) {
            return true;
        }
        if (Utils.isHammer(heldItem) && player.isShiftKeyDown()) {
            this.panelRight = !this.panelRight;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeConveyorNBT() {
        CompoundTag nbt = super.writeConveyorNBT();
        nbt.putBoolean("panelRight", this.panelRight);
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundTag nbt) {
        super.readConveyorNBT(nbt);
        this.panelRight = nbt.getBoolean("panelRight");
    }

    @Override
    public VoxelShape getSelectionShape() {
        VoxelShape ret = conveyorBounds;
        VoxelShape extensionShape = WALL_SHAPES.get(this.panelRight ? this.getFacing() : this.getFacing().getOpposite());
        if (extensionShape != null) {
            ret = Shapes.joinUnoptimized((VoxelShape)ret, (VoxelShape)extensionShape, (BooleanOp)BooleanOp.OR);
        }
        return ret;
    }

    public boolean isPanelRight() {
        return this.panelRight;
    }
}

