/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.ComponentInstance;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.InitialMultiblockContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockBEHelperCommon;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.MultiblockLevel;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MultiblockBEHelperMaster<State extends IMultiblockState>
extends MultiblockBEHelperCommon<State>
implements IMultiblockBEHelperMaster<State> {
    private final State state;
    private final MultiblockContext<State> context;
    private final List<ComponentInstance<?>> componentInstances;
    private final Object2IntMap<BlockPos> currentComparatorOutputs = new Object2IntOpenHashMap();
    private final MultiblockBEHelperCommon.CachedValue<BlockPos, MultiblockOrientation, AABB> renderBox;

    public MultiblockBEHelperMaster(MultiblockBlockEntityMaster<State> be, MultiblockRegistration<State> multiblock) {
        super(be, multiblock, be.getBlockState());
        this.state = multiblock.logic().createInitialState(new InitialMultiblockContext(be, this.orientation, multiblock.masterPosInMB()));
        BlockPos multiblockOrigin = be.getBlockPos().subtract((Vec3i)this.orientation.getAbsoluteOffset(multiblock.masterPosInMB()));
        MultiblockLevel level = new MultiblockLevel(() -> be.getLevel(), this.orientation, multiblockOrigin);
        this.context = new MultiblockContext<State>(this, multiblock, level);
        this.componentInstances = new ArrayList();
        for (MultiblockRegistration.ExtraComponent<State, ?> c : multiblock.extraComponents()) {
            this.componentInstances.add(ComponentInstance.make(c, this.state, this.context));
        }
        this.renderBox = new MultiblockBEHelperCommon.CachedValue<BlockPos, MultiblockOrientation, AABB>((origin, orientation) -> {
            BlockPos maxBlock = new BlockPos(multiblock.size(level.getRawLevel()));
            Vec3 max = Vec3.atLowerCornerOf((Vec3i)maxBlock).add(1.0, 1.0, 1.0);
            Vec3 absoluteOffset = orientation.getAbsoluteOffset(max);
            return new AABB(Vec3.ZERO, absoluteOffset).move(origin);
        });
    }

    @Override
    @Nonnull
    public State getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public MultiblockContext<State> getContext() {
        return this.context;
    }

    @Override
    @Nullable
    protected IMultiblockBEHelperMaster<State> getMasterHelperWithChunkloads() {
        return this;
    }

    @Override
    @Nullable
    protected MultiblockBEHelperMaster<State> getMasterHelper() {
        return this;
    }

    @Override
    public void load(CompoundTag tag) {
        this.load(tag, IMultiblockState::readSaveNBT);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        this.save(tag, IMultiblockState::writeSaveNBT);
    }

    private void save(CompoundTag out, BiConsumer<IMultiblockState, CompoundTag> saveSingle) {
        saveSingle.accept((IMultiblockState)this.state, out);
        ListTag savedComponents = new ListTag();
        for (ComponentInstance<?> component : this.componentInstances) {
            Object obj = component.state();
            if (!(obj instanceof IMultiblockState)) continue;
            IMultiblockState saveable = (IMultiblockState)obj;
            CompoundTag componentNBT = new CompoundTag();
            saveSingle.accept(saveable, componentNBT);
            savedComponents.add((Object)componentNBT);
        }
        if (!savedComponents.isEmpty()) {
            out.put("componentNBT", (Tag)savedComponents);
        }
    }

    private void load(CompoundTag in, BiConsumer<IMultiblockState, CompoundTag> loadSingle) {
        loadSingle.accept((IMultiblockState)this.state, in);
        ListTag savedComponents = in.getList("componentNBT", 10);
        int nextIndex = 0;
        for (ComponentInstance<?> component : this.componentInstances) {
            Object obj = component.state();
            if (!(obj instanceof IMultiblockState)) continue;
            IMultiblockState saveable = (IMultiblockState)obj;
            loadSingle.accept(saveable, savedComponents.getCompound(nextIndex));
            if (++nextIndex < savedComponents.size()) continue;
            break;
        }
    }

    @Override
    public CompoundTag getUpdateTag() {
        CompoundTag result = new CompoundTag();
        this.save(result, IMultiblockState::writeSyncNBT);
        return result;
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this.getMasterBE());
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag, IMultiblockState::readSyncNBT);
    }

    @Override
    public void onDataPacket(CompoundTag tag) {
        this.load(tag, IMultiblockState::readSyncNBT);
    }

    @Override
    public MultiblockRegistration<State> getMultiblock() {
        return this.multiblock;
    }

    @Override
    public BlockPos getPositionInMB() {
        return this.multiblock.masterPosInMB();
    }

    @Override
    public AABB getRenderBoundingBox() {
        return this.renderBox.get(this.context.getLevel().getAbsoluteOrigin(), this.orientation);
    }

    @Override
    public void tickServer() {
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)this.be.getLevel(), this.be.getBlockPos())) {
            return;
        }
        IMultiblockLogic logic = this.multiblock.logic();
        if (logic instanceof IServerTickableComponent) {
            IServerTickableComponent serverTickable = (IServerTickableComponent)((Object)logic);
            serverTickable.tickServer(this.getContext());
        }
        for (ComponentInstance<?> component : this.componentInstances) {
            component.tickServer();
        }
    }

    @Override
    public void tickClient() {
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)this.be.getLevel(), this.be.getBlockPos())) {
            return;
        }
        IMultiblockLogic logic = this.multiblock.logic();
        if (logic instanceof IClientTickableComponent) {
            IClientTickableComponent clientTickable = (IClientTickableComponent)((Object)logic);
            clientTickable.tickClient(this.getContext());
        }
        for (ComponentInstance<?> component : this.componentInstances) {
            component.tickClient();
        }
    }

    @Override
    public void invalidateAllCaps() {
        Level level = this.be.getLevel();
        if (level == null) {
            return;
        }
        for (StructureTemplate.StructureBlockInfo blockInMB : this.multiblock.getStructure().apply(level)) {
            BlockPos realPosition = this.context.getLevel().toAbsolute(blockInMB.pos());
            level.invalidateCapabilities(realPosition);
        }
    }

    public BlockEntity getMasterBE() {
        return this.be;
    }

    public MultiblockOrientation getOrientation() {
        return this.orientation;
    }

    public Object2IntMap<BlockPos> getCurrentComparatorOutputs() {
        return this.currentComparatorOutputs;
    }

    public List<ComponentInstance<?>> getComponentInstances() {
        return this.componentInstances;
    }
}

