/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.BucketWheelShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BucketWheelLogic
implements IMultiblockLogic<State>,
IClientTickableComponent<State>,
IServerTickableComponent<State> {
    @Override
    public void tickServer(IMultiblockContext<State> context) {
        this.tickClient(context);
        if (context.getState().active && context.getLevel().shouldTickModulo(20)) {
            context.requestMasterBESync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.active) {
            state.rotation = (float)((double)state.rotation + (Double)IEServerConfig.MACHINES.excavator_speed.get());
            state.rotation %= 360.0f;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State();
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return BucketWheelShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public float rotation = 0.0f;
        public final NonNullList<ItemStack> digStacks = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        public boolean active = false;
        public boolean reverseRotation = false;
        public boolean outputLeft = false;

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.putFloat("rotation", this.rotation);
            ListTag stacksNBT = new ListTag();
            for (ItemStack stack : this.digStacks) {
                stacksNBT.add((Object)stack.save(new CompoundTag()));
            }
            nbt.put("stacks", (Tag)stacksNBT);
            nbt.putBoolean("active", this.active);
            nbt.putBoolean("renderReverse", this.reverseRotation);
            nbt.putBoolean("outputLeft", this.outputLeft);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.rotation = nbt.getFloat("rotation");
            ListTag stacksNBT = nbt.getList("stacks", 10);
            for (int i = 0; i < stacksNBT.size(); ++i) {
                this.digStacks.set(i, (Object)ItemStack.of((CompoundTag)stacksNBT.getCompound(i)));
            }
            this.active = nbt.getBoolean("active");
            this.reverseRotation = nbt.getBoolean("renderReverse");
            this.outputLeft = nbt.getBoolean("outputLeft");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }
    }
}

