/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.BucketWheelLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ExcavatorShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ExcavatorLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(2, 0, 4, RelativeBlockFace.LEFT), new CapabilityPosition(2, 1, 4, RelativeBlockFace.LEFT), new CapabilityPosition(2, 2, 4, RelativeBlockFace.LEFT));
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 5);
    private static final MultiblockFace ITEM_OUTPUT = new MultiblockFace(1, 1, 6, RelativeBlockFace.BACK);
    public static final BlockPos WHEEL_CENTER = new BlockPos(1, 1, 1);
    private static final Vec3 WHEEL_CENTER_TOP = Vec3.atCenterOf((Vec3i)WHEEL_CENTER.above(2));
    private static final Vec3 DIG_POSITION = Vec3.atCenterOf((Vec3i)WHEEL_CENTER.below(3));
    private static final Vec3 HOPPER = Vec3.atCenterOf((Vec3i)WHEEL_CENTER.above().west());
    private static final List<BlockPos> DIG_POSITIONS = (List)Util.make(() -> {
        BlockPos belowWheelCenter = WHEEL_CENTER.offset(0, -4, 0);
        return List.of(belowWheelCenter, belowWheelCenter.offset(0, 0, 1), belowWheelCenter.offset(0, 0, 2), belowWheelCenter.offset(0, 0, -1), belowWheelCenter.offset(0, 0, -2), belowWheelCenter.offset(1, 0, 1), belowWheelCenter.offset(-1, 0, 1), belowWheelCenter.offset(1, 0, 0), belowWheelCenter.offset(-1, 0, 0), belowWheelCenter.offset(1, 0, -1), belowWheelCenter.offset(-1, 0, -1));
    });

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(0.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.oreConveyor, 0.125f);
        }
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        float rot;
        IMultiblockLevel level = context.getLevel();
        State state = context.getState();
        int target = -1;
        IMultiblockBEHelperMaster<BucketWheelLogic.State> wheelHelper = ExcavatorLogic.getWheel(level);
        if (wheelHelper == null) {
            return;
        }
        BucketWheelLogic.State wheel = wheelHelper.getState();
        IMultiblockContext<BucketWheelLogic.State> wheelCtx = wheelHelper.getContext();
        this.adjustWheel(level.getOrientation(), wheelCtx.getLevel().getOrientation(), wheel);
        if (wheel.active != state.active) {
            wheel.active = state.active;
            wheelCtx.markDirtyAndSync();
            context.requestMasterBESync();
        }
        if ((rot = wheel.rotation) % 45.0f > 40.0f) {
            target = Math.round(rot / 360.0f * 8.0f) % 8;
        }
        if (!state.rsState.isEnabled(context)) {
            state.active = false;
            return;
        }
        Level rawLevel = level.getRawLevel();
        MineralVein mineralVein = ExcavatorHandler.getRandomMineral(rawLevel, level.toAbsolute(WHEEL_CENTER));
        MineralMix mineral = mineralVein != null ? mineralVein.getMineral(rawLevel) : null;
        int consumed = (Integer)IEServerConfig.MACHINES.excavator_consumption.get();
        int extracted = state.energy.extractEnergy(consumed, true);
        if (extracted < consumed) {
            state.active = false;
            return;
        }
        state.energy.extractEnergy(consumed, false);
        state.active = true;
        if (target >= 0) {
            boolean wheelChanged = false;
            int targetDown = (target + 4) % 8;
            if (((ItemStack)wheel.digStacks.get(targetDown)).isEmpty()) {
                ItemStack blocking = this.digBlocksInTheWay(level);
                if (!blocking.isEmpty()) {
                    wheel.digStacks.set(targetDown, (Object)blocking);
                    wheelChanged = true;
                } else if (mineral != null) {
                    if (this.fillBucket(mineralVein, mineral, level.toAbsolute(WHEEL_CENTER), wheel, targetDown, level)) {
                        wheelChanged = true;
                    }
                    mineralVein.deplete();
                }
            }
            if (!((ItemStack)wheel.digStacks.get(target)).isEmpty()) {
                state.output.insertOrDrop(((ItemStack)wheel.digStacks.get(target)).copy(), level);
                Block b = Block.byItem((Item)((ItemStack)wheel.digStacks.get(target)).getItem());
                if (b != Blocks.AIR) {
                    this.spawnParticles((ItemStack)wheel.digStacks.get(target), level);
                    rawLevel.playSound(null, level.toAbsolute((Vec3)ExcavatorLogic.HOPPER).x, level.toAbsolute((Vec3)ExcavatorLogic.HOPPER).y, level.toAbsolute((Vec3)ExcavatorLogic.HOPPER).z, (SoundEvent)IESounds.oreDump.value(), SoundSource.BLOCKS, 0.875f, 1.0f);
                }
                wheel.digStacks.set(target, (Object)ItemStack.EMPTY);
                wheelChanged = true;
            }
            if (wheelChanged) {
                wheelCtx.markDirtyAndSync();
            }
        }
    }

    private void adjustWheel(MultiblockOrientation excavatorOrientation, MultiblockOrientation wheelOrientation, BucketWheelLogic.State wheel) {
        Direction wheelFront = wheelOrientation.front().getCounterClockWise();
        wheel.reverseRotation = wheelFront != excavatorOrientation.front();
    }

    private void spawnParticles(ItemStack stack, IMultiblockLevel level) {
        if (!((Boolean)IEServerConfig.MACHINES.excavator_particles.get()).booleanValue()) {
            return;
        }
        Level level2 = level.getRawLevel();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel rawLevel = (ServerLevel)level2;
        Direction facing = level.getOrientation().front();
        Direction outputDir = level.getOrientation().mirrored() ? facing.getCounterClockWise() : facing.getClockWise();
        Vec3 topCenterAbs = level.toAbsolute(WHEEL_CENTER_TOP);
        double dirX = 0.375 * (double)outputDir.getStepX();
        double dirY = -0.5;
        double dirZ = 0.375 * (double)outputDir.getStepZ();
        rawLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), topCenterAbs.x + dirX, topCenterAbs.y - 1.0, topCenterAbs.z + dirY, 128, dirX, dirY, dirZ, 0.075);
    }

    @Nullable
    private static IMultiblockBEHelperMaster<BucketWheelLogic.State> getWheel(IMultiblockLevel level) {
        BlockEntity blockEntity = level.getBlockEntity(WHEEL_CENTER);
        if (!(blockEntity instanceof MultiblockBlockEntityMaster)) {
            return null;
        }
        MultiblockBlockEntityMaster wheelBE = (MultiblockBlockEntityMaster)blockEntity;
        IMultiblockBEHelper helper = wheelBE.getHelper();
        if (helper.getState() instanceof BucketWheelLogic.State) {
            return helper;
        }
        return null;
    }

    private ItemStack digBlocksInTheWay(IMultiblockLevel level) {
        for (BlockPos attemptPos : DIG_POSITIONS) {
            ItemStack dug = this.digBlock(attemptPos, level);
            if (dug.isEmpty()) continue;
            return dug;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack digBlock(BlockPos relativePos, IMultiblockLevel level) {
        Level rawLevel = level.getRawLevel();
        if (!(rawLevel instanceof ServerLevel)) {
            return ItemStack.EMPTY;
        }
        ServerLevel serverLevel = (ServerLevel)rawLevel;
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer(rawLevel);
        BlockState blockstate = level.getBlockState(relativePos);
        Block block = blockstate.getBlock();
        BlockPos absolutePos = level.toAbsolute(relativePos);
        if (!blockstate.isAir() && blockstate.getDestroySpeed((BlockGetter)rawLevel, absolutePos) != -1.0f) {
            if (!block.canHarvestBlock(blockstate, (BlockGetter)rawLevel, absolutePos, (Player)fakePlayer)) {
                return ItemStack.EMPTY;
            }
            if (block.onDestroyedByPlayer(blockstate, rawLevel, absolutePos, (Player)fakePlayer, true, blockstate.getFluidState())) {
                block.destroy((LevelAccessor)rawLevel, absolutePos, blockstate);
                ItemStack tool = new ItemStack((ItemLike)Items.IRON_PICKAXE);
                tool.enchant(Enchantments.SILK_TOUCH, 1);
                LootParams.Builder dropContext = new LootParams.Builder(serverLevel).withOptionalParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)absolutePos)).withOptionalParameter(LootContextParams.TOOL, (Object)tool);
                List itemsNullable = blockstate.getDrops(dropContext);
                NonNullList items = NonNullList.create();
                items.addAll((Collection)itemsNullable);
                for (int i = 0; i < items.size(); ++i) {
                    if (i == 0) continue;
                    ItemEntity ei = new ItemEntity(EntityType.ITEM, rawLevel);
                    ei.setItem(((ItemStack)items.get(i)).copy());
                    ei.setPos(Vec3.atCenterOf((Vec3i)absolutePos));
                    rawLevel.addFreshEntity((Entity)ei);
                }
                rawLevel.levelEvent(2001, absolutePos, Block.getId((BlockState)blockstate));
                if (items.size() > 0) {
                    return (ItemStack)items.get(0);
                }
            }
        }
        return ItemStack.EMPTY;
    }

    private boolean fillBucket(MineralVein mineralVein, MineralMix mineralMix, BlockPos wheelPos, BucketWheelLogic.State wheel, int targetDown, IMultiblockLevel level) {
        if (mineralVein.isDepleted()) {
            return false;
        }
        ItemStack ore = mineralMix.getRandomOre(ApiUtils.RANDOM);
        if (ore.isEmpty()) {
            return false;
        }
        if (ApiUtils.RANDOM.nextFloat() < mineralMix.failChance || (double)ApiUtils.RANDOM.nextFloat() < mineralVein.getFailChance(wheelPos)) {
            wheel.digStacks.set(targetDown, (Object)mineralMix.getRandomSpoil(ApiUtils.RANDOM));
        } else {
            wheel.digStacks.set(targetDown, (Object)ore);
        }
        Item item = ((ItemStack)wheel.digStacks.get(targetDown)).getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            level.getRawLevel().playSound(null, level.toAbsolute((Vec3)ExcavatorLogic.DIG_POSITION).x, level.toAbsolute((Vec3)ExcavatorLogic.DIG_POSITION).y, level.toAbsolute((Vec3)ExcavatorLogic.DIG_POSITION).z, blockItem.getBlock().defaultBlockState().getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.EnergyStorage.BLOCK, (state, position) -> {
            if (position.side() == null || ENERGY_INPUTS.contains(position)) {
                return state.energy;
            }
            return null;
        });
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    public static int computeComparatorValue(State state, IMultiblockLevel level) {
        if (ExcavatorLogic.getWheel(level) == null) {
            return 0;
        }
        BlockPos wheelPos = level.toAbsolute(WHEEL_CENTER);
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(level.getRawLevel(), wheelPos);
        if (info == null) {
            return 0;
        }
        if (ExcavatorHandler.mineralVeinYield == 0) {
            return 15;
        }
        long totalDepletion = 0L;
        List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
        if (veins.isEmpty()) {
            return 0;
        }
        for (Pair<MineralVein, Integer> pair : veins) {
            totalDepletion += (long)((MineralVein)pair.getFirst()).getDepletion();
        }
        float remain = (float)((long)ExcavatorHandler.mineralVeinYield - (totalDepletion /= (long)veins.size())) / (float)ExcavatorHandler.mineralVeinYield;
        return Mth.ceil((float)(Math.max(remain, 0.0f) * 15.0f));
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return ExcavatorShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        private boolean active = false;
        private final MutableEnergyStorage energy = new MutableEnergyStorage(64000);
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        private final DroppingMultiblockOutput output;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private BooleanSupplier isPlayingSound = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(ITEM_OUTPUT, ctx);
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.put("energy", this.energy.serializeNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.get("energy"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.putBoolean("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.active = nbt.getBoolean("active");
        }

        public IEnergyStorage getEnergy() {
            return this.energy;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

