/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.LightningRodShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class LightningRodLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    public static final BlockPos MASTER_OFFSET = new BlockPos(1, 1, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        BlockPos strikePosition;
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        if (state.energy.getEnergyStored() > 0) {
            for (Supplier outputRef : state.energyOutputs) {
                IEnergyStorage output = (IEnergyStorage)outputRef.get();
                if (output == null) continue;
                int accepted = output.receiveEnergy(state.energy.getEnergyStored(), false);
                state.energy.modifyEnergyStored(-accepted);
            }
        }
        if (level.shouldTickModulo(256)) {
            state.fenceNet = null;
        }
        if (state.fenceNet == null) {
            state.fenceNet = LightningRodLogic.getFenceNet(level.getRawLevel(), level.toAbsolute(MASTER_OFFSET));
        }
        if (state.fenceNet.isValid() && level.shouldTickModulo(128) && (level.isThundering() || level.isRaining() && ApiUtils.RANDOM.nextInt(10) == 0) && (strikePosition = state.fenceNet.getAbsoluteStrikePosition(level)) != null) {
            state.energy.setStoredEnergy((Integer)IEServerConfig.MACHINES.lightning_output.get());
            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level.getRawLevel());
            lightningboltentity.moveTo(Vec3.atBottomCenterOf((Vec3i)strikePosition));
            lightningboltentity.setVisualOnly(true);
            level.getRawLevel().addFreshEntity((Entity)lightningboltentity);
        }
    }

    @Nonnull
    private static FenceNet getFenceNet(Level level, BlockPos absoluteMasterPos) {
        int height = 0;
        boolean broken = false;
        BlockPos lastFence = null;
        for (int i = absoluteMasterPos.getY() + 2; i < level.getMaxBuildHeight() - 1; ++i) {
            BlockPos pos = new BlockPos(absoluteMasterPos.getX(), i, absoluteMasterPos.getZ());
            if (!broken && LightningRodLogic.isFence(level, pos)) {
                ++height;
                lastFence = pos;
                continue;
            }
            if (!level.isEmptyBlock(pos)) {
                return FenceNet.INVALID;
            }
            if (broken) continue;
            broken = true;
        }
        if (lastFence == null) {
            return FenceNet.INVALID;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        openList.add(lastFence);
        while (!openList.isEmpty() && closedList.size() < 256) {
            BlockPos next = (BlockPos)openList.get(0);
            if (!closedList.contains(next) && LightningRodLogic.isFence(level, next)) {
                closedList.add(next);
                openList.add(next.relative(Direction.WEST));
                openList.add(next.relative(Direction.EAST));
                openList.add(next.relative(Direction.NORTH));
                openList.add(next.relative(Direction.SOUTH));
                openList.add(next.relative(Direction.UP));
            }
            openList.remove(0);
        }
        return new FenceNet(height, closedList);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.EnergyStorage.BLOCK, (state, position) -> {
            BlockPos posInMultiblock = position.posInMultiblock();
            if (position.side() == null || posInMultiblock.getY() == 1 && (posInMultiblock.getX() + posInMultiblock.getZ()) % 2 == 1) {
                return state.energy;
            }
            return null;
        });
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return LightningRodShapes.SHAPE_GETTER;
    }

    private static boolean isFence(Level level, BlockPos pos) {
        return Utils.isBlockAt(level, pos, (Block)IEBlocks.MetalDecoration.STEEL_FENCE.get());
    }

    public static class State
    implements IMultiblockState {
        private final MutableEnergyStorage energy;
        private final ImmutableList<Supplier<@Nullable IEnergyStorage>> energyOutputs;
        @Nullable
        private FenceNet fenceNet;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> capabilitySource) {
            this.energy = new MutableEnergyStorage((Integer)IEServerConfig.MACHINES.lightning_output.get(), 0, (Integer)IEServerConfig.MACHINES.lightning_output.get());
            this.fenceNet = null;
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ImmutableList.Builder builder = ImmutableList.builder();
            for (RelativeBlockFace face : RelativeBlockFace.HORIZONTAL) {
                builder.add(capabilitySource.getCapabilityAt(Capabilities.EnergyStorage.BLOCK, face.offsetRelative(MASTER_OFFSET, 2), face.getOpposite()));
            }
            this.energyOutputs = builder.build();
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            EnergyHelper.serializeTo(this.energy, nbt);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            EnergyHelper.deserializeFrom(this.energy, nbt);
        }
    }

    private record FenceNet(int height, List<BlockPos> absoluteFencePositions) {
        public static final FenceNet INVALID = new FenceNet(0, List.of());

        public boolean isValid() {
            return !this.absoluteFencePositions.isEmpty();
        }

        public BlockPos getAbsoluteStrikePosition(IMultiblockLevel level) {
            int i = this.height + this.absoluteFencePositions.size();
            int masterY = level.getAbsoluteOrigin().getY();
            if (ApiUtils.RANDOM.nextInt(4096 * level.getMaxBuildHeight()) < i * (masterY + i)) {
                return this.absoluteFencePositions.get(ApiUtils.RANDOM.nextInt(this.absoluteFencePositions.size()));
            }
            return null;
        }
    }
}

