/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.DirectProcessingItemHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.MetalPressShapes;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IESounds;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MetalPressLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_PRESS_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 0);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 0, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition INPUT_POS = new CapabilityPosition(0, 1, 0, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(1, 2, 0, RelativeBlockFace.UP);

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.renderAsActive) {
            return;
        }
        BlockPos soundPos = context.getLevel().toAbsolute(REDSTONE_POS);
        Level level = context.getLevel().getRawLevel();
        for (MultiblockProcess<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> process : state.processor.getQueue()) {
            float maxTicks = process.getMaxTicks(level);
            float transportTime = MetalPressLogic.getTransportTime(maxTicks);
            float pressTime = MetalPressLogic.getPressTime(maxTicks);
            float fProcess = process.processTick;
            Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
            if (fProcess >= transportTime && fProcess < transportTime + 1.0f) {
                level.playSound(localPlayer, soundPos, (SoundEvent)IESounds.metalpress_piston.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= transportTime + pressTime && fProcess < transportTime + pressTime + 1.0f) {
                level.playSound(localPlayer, soundPos, (SoundEvent)IESounds.metalpress_smash.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= maxTicks - transportTime && fProcess < maxTicks - transportTime + 1.0f) {
                level.playSound(localPlayer, soundPos, (SoundEvent)IESounds.metalpress_piston.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            ++process.processTick;
        }
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.renderAsActive) {
            state.renderAsActive = active;
            context.requestMasterBESync();
        }
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity entity) {
        Level world = ctx.getLevel().getRawLevel();
        if (world.isClientSide || !INPUT_POS.posInMultiblock().equals((Object)posInMultiblock)) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.isAlive() && !itemEntity.getItem().isEmpty()) {
                SpecialMetalPressProcess process;
                ItemStack stack = itemEntity.getItem();
                if (stack.isEmpty()) {
                    return;
                }
                State state = ctx.getState();
                RecipeHolder<MetalPressRecipe> recipe = MetalPressRecipe.findRecipe(state.mold, stack, world);
                if (recipe == null) {
                    return;
                }
                ItemStack displayStack = ((MetalPressRecipe)recipe.value()).getDisplayStack(stack);
                Recipe recipe2 = recipe.value();
                if (recipe2 instanceof MetalPressPackingRecipes.RecipeDelegate) {
                    MetalPressPackingRecipes.RecipeDelegate delegate = (MetalPressPackingRecipes.RecipeDelegate)recipe2;
                    process = new SpecialMetalPressProcess(recipe.id(), delegate, displayStack);
                } else {
                    process = new MultiblockProcessInWorld(recipe, displayStack);
                }
                if (state.processor.addProcessToQueue(process, world, false)) {
                    ItemStack remaining = stack.copy();
                    remaining.shrink(displayStack.getCount());
                    itemEntity.setItem(remaining);
                    if (remaining.isEmpty()) {
                        entity.discard();
                    }
                }
            }
        }
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        State state = ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        ItemStack heldItem = player.getItemInHand(hand);
        ItemStack newMold = null;
        if (player.isShiftKeyDown() && !state.mold.isEmpty()) {
            newMold = ItemStack.EMPTY;
        } else if (MetalPressRecipe.isValidMold(level, heldItem)) {
            newMold = heldItem;
        }
        if (newMold == null) {
            return InteractionResult.FAIL;
        }
        ItemStack oldMold = state.mold;
        state.mold = ItemHandlerHelper.copyStackWithSize((ItemStack)newMold, (int)1);
        newMold.shrink(1);
        if (!oldMold.isEmpty()) {
            if (heldItem.isEmpty()) {
                player.setItemInHand(hand, oldMold);
            } else if (!isClient) {
                player.spawnAtLocation(oldMold, 0.0f);
            }
        }
        ctx.markMasterDirty();
        ctx.requestMasterBESync();
        return InteractionResult.SUCCESS;
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAt(Capabilities.ItemHandler.BLOCK, INPUT_POS, state -> state.inputCap);
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_POS, state -> state.energy);
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        if (!state.mold.isEmpty()) {
            drop.accept(state.mold.copy());
            state.mold = ItemStack.EMPTY;
        }
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return MetalPressShapes.SHAPE_GETTER;
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getPressTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<MetalPressRecipe> {
        public ItemStack mold = ItemStack.EMPTY;
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final MultiblockProcessor<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> processor;
        private boolean renderAsActive;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final IItemHandler inputCap;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor(3, maxTicks -> 1.0f - (MetalPressLogic.getTransportTime(maxTicks) + MetalPressLogic.getPressTime(maxTicks)) / (float)maxTicks, 3, ctx.getMarkDirtyRunnable(), ctx.getSyncRunnable(), MetalPressRecipe.STANDARD_RECIPES::getById);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.inputCap = new DirectProcessingItemHandler<MetalPressRecipe>(ctx.levelSupplier(), this.processor, (level, input) -> MetalPressRecipe.findRecipe(this.mold, input, level));
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.renderAsActive, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<MultiblockProcessor<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>>>(this.processor, MachineInterfaceHandler.BASIC_ITEM_IN, this.processor.getMachineInterfaceOptions(false)), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            this.energy.deserializeNBT(nbt.get("energy"));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            nbt.put("energy", this.energy.serializeNBT());
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.putBoolean("active", this.renderAsActive);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            this.renderAsActive = nbt.getBoolean("active");
        }

        private void writeCommonNBT(CompoundTag nbt) {
            if (!this.mold.isEmpty()) {
                nbt.put("mold", (Tag)this.mold.save(new CompoundTag()));
            }
            nbt.put("processor", this.processor.toNBT());
        }

        private void readCommonNBT(CompoundTag nbt) {
            this.mold = ItemStack.of((CompoundTag)nbt.getCompound("mold"));
            this.processor.fromNBT(nbt.get("processor"), State::loadProcess);
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }

        public static MultiblockProcessInWorld<MetalPressRecipe> loadProcess(BiFunction<Level, ResourceLocation, MetalPressRecipe> getRecipe, CompoundTag tag) {
            if (tag.contains("baseRecipe", 8)) {
                return new SpecialMetalPressProcess(tag, new ResourceLocation(tag.getString("baseRecipe")));
            }
            return new MultiblockProcessInWorld<MetalPressRecipe>(getRecipe, tag);
        }
    }

    private static class SpecialMetalPressProcess
    extends MultiblockProcessInWorld<MetalPressRecipe> {
        private final ResourceLocation baseRecipeLocation;

        public SpecialMetalPressProcess(CompoundTag data, ResourceLocation baseRecipeLocation) {
            super((Level level, ResourceLocation name) -> {
                CraftingRecipe baseRecipe = MetalPressPackingRecipes.CRAFTING_RECIPE_MAP.getById((Level)level, baseRecipeLocation);
                if (baseRecipe != null) {
                    return (MetalPressRecipe)MetalPressPackingRecipes.getRecipeDelegate((RecipeHolder<CraftingRecipe>)new RecipeHolder(baseRecipeLocation, (Recipe)baseRecipe), name, level.registryAccess()).value();
                }
                return null;
            }, data);
            this.baseRecipeLocation = baseRecipeLocation;
        }

        public SpecialMetalPressProcess(ResourceLocation id, MetalPressPackingRecipes.RecipeDelegate recipe, ItemStack inputItem) {
            super(new RecipeHolder(id, (Recipe)recipe), inputItem);
            this.baseRecipeLocation = recipe.baseRecipe.id();
        }

        @Override
        public void writeExtraDataToNBT(CompoundTag nbt) {
            super.writeExtraDataToNBT(nbt);
            nbt.putString("baseRecipe", this.baseRecipeLocation.toString());
        }
    }
}

