/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SiloTankShapes;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SiloLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    private static final SiloTankShapes SHAPE_GETTER = new SiloTankShapes(6);
    private static final int MAX_STORAGE = 41472;
    public static final BlockPos OUTPUT_POS = new BlockPos(1, 0, 1);
    private static final Set<BlockPos> IO_OFFSETS = Set.of(OUTPUT_POS, new BlockPos(1, 6, 1));

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        state.comparatorHelper.update(context, state.storageAmount);
        if (state.identStack.isEmpty() || state.storageAmount <= 0) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!level.shouldTickModulo(8) || !state.rsState.isEnabled(context)) {
            return;
        }
        for (Supplier<IItemHandler> output : state.outputs) {
            ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)state.identStack, (int)1);
            if (!(stack = Utils.insertStackIntoInventory(output, stack, false)).isEmpty()) continue;
            --state.storageAmount;
            if (state.storageAmount <= 0) {
                state.identStack = ItemStack.EMPTY;
            }
            context.markMasterDirty();
            context.requestMasterBESync();
            if (state.storageAmount > 0) continue;
            break;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.ItemHandler.BLOCK, (state, position) -> {
            if (IO_OFFSETS.contains(position.posInMultiblock())) {
                return state.inputHandler;
            }
            return null;
        });
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public ItemStack identStack = ItemStack.EMPTY;
        public int storageAmount = 0;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();
        private final LayeredComparatorOutput<IMultiblockContext<?>> comparatorHelper = LayeredComparatorOutput.makeForSiloLike(41472, 6);
        private final List<Supplier<@Nullable IItemHandler>> outputs;
        private final IItemHandler inputHandler;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public State(IInitialMultiblockContext<State> capabilitySource) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable ImmutableList.Builder outputBuilder = ImmutableList.builder();
            for (RelativeBlockFace face : RelativeBlockFace.values()) {
                if (face == RelativeBlockFace.DOWN) continue;
                BlockPos neighbor = face.offsetRelative(OUTPUT_POS, -1);
                outputBuilder.add(capabilitySource.getCapabilityAt(Capabilities.ItemHandler.BLOCK, neighbor, face));
            }
            this.outputs = outputBuilder.build();
            this.inputHandler = new InventoryHandler(this, () -> {
                capabilitySource.getMarkDirtyRunnable().run();
                capabilitySource.getSyncRunnable().run();
            });
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.put("identStack", (Tag)this.identStack.save(new CompoundTag()));
            nbt.putInt("count", this.storageAmount);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.identStack = ItemStack.of((CompoundTag)nbt.getCompound("identStack"));
            this.storageAmount = nbt.getInt("count");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }
    }

    private record InventoryHandler(State state, Runnable onChange) implements IItemHandler
    {
        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.EMPTY;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.state.identStack, (int)this.state.storageAmount);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int space = 41472 - this.state.storageAmount;
            if (slot != 0 || space < 1 || stack.isEmpty() || !this.state.identStack.isEmpty() && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.state.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.getCount());
            if (!simulate) {
                this.state.storageAmount += accepted;
                if (this.state.identStack.isEmpty()) {
                    this.state.identStack = stack.copy();
                }
                this.onChange.run();
            }
            stack = stack.copy();
            stack.shrink(accepted);
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1 || this.state.storageAmount < 1 || amount < 1 || this.state.identStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int returned = Math.min(Math.min(this.state.storageAmount, amount), this.state.identStack.getMaxStackSize());
            ItemStack out = ItemHandlerHelper.copyStackWithSize((ItemStack)this.state.identStack, (int)returned);
            if (!simulate) {
                this.state.storageAmount -= out.getCount();
                if (this.state.storageAmount <= 0) {
                    this.state.identStack = ItemStack.EMPTY;
                }
                this.onChange.run();
            }
            return out;
        }

        public int getSlotLimit(int slot) {
            return 41472;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }
    }
}

