/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingInsertionHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.BottlingMachineShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BottlingMachineLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_LIFT_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ITEM_INPUT_POS = new CapabilityPosition(0, 1, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition FLUID_INPUT_POS_BACK = new CapabilityPosition(0, 0, 0, RelativeBlockFace.FRONT);
    private static final CapabilityPosition FLUID_INPUT_POS_SIDE = new CapabilityPosition(0, 0, 0, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ENERGY_INPUT_POS = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        boolean active;
        State state = context.getState();
        state.active = active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (active) {
            context.requestMasterBESync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        for (MultiblockProcess process : state.processor.getQueue()) {
            Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
            if ((float)process.processTick != 8.0f) continue;
            BlockPos soundPos = level.toAbsolute(new BlockPos(1, 1, 1));
            rawLevel.playSound(localPlayer, soundPos, (SoundEvent)IESounds.bottling.value(), SoundSource.BLOCKS, 0.125f, 0.8f);
            break;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        BottlingProcess process;
        NonNullList<ItemStack> displayStacks;
        Level level = collided.level();
        if (!new BlockPos(0, 1, 1).equals((Object)posInMultiblock) || level.isClientSide) {
            return;
        }
        if (!(collided instanceof ItemEntity) || !collided.isAlive()) {
            return;
        }
        State state = ctx.getState();
        BlockPos absoluteCollisionPos = ctx.getLevel().toAbsolute(posInMultiblock);
        List<Pair> itemsOnConveyor = level.getEntitiesOfClass(ItemEntity.class, AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)absoluteCollisionPos))).stream().map(itemEntity1 -> Pair.of((Object)itemEntity1, (Object)itemEntity1.getItem())).toList();
        if (itemsOnConveyor.isEmpty()) {
            return;
        }
        ItemStack[] stacks = (ItemStack[])itemsOnConveyor.stream().map(Pair::getSecond).toArray(ItemStack[]::new);
        RecipeHolder<BottlingMachineRecipe> recipe = BottlingMachineRecipe.findRecipe(level, state.tank.getFluid(), stacks);
        if (recipe == null && !Utils.isFluidRelatedItemStack(stacks[0])) {
            return;
        }
        if (recipe == null) {
            ItemStack inputItem = ItemHandlerHelper.copyStackWithSize((ItemStack)stacks[0], (int)1);
            displayStacks = Utils.createNonNullItemStackListFromItemStack(inputItem);
            process = new BottlingProcess(inputItem, inputItem.copy(), state);
        } else {
            displayStacks = ((BottlingMachineRecipe)recipe.value()).getDisplayStacks(stacks);
            process = new BottlingProcess(recipe, displayStacks, state);
        }
        if (state.processor.addProcessToQueue(process, level, false)) {
            for (ItemStack stack : displayStacks) {
                itemsOnConveyor.stream().filter(t -> ItemStack.isSameItemSameTags((ItemStack)((ItemStack)t.getSecond()), (ItemStack)stack)).findFirst().ifPresent(t -> {
                    ItemStack remaining = ((ItemStack)t.getSecond()).copy();
                    remaining.shrink(stack.getCount());
                    ((ItemEntity)t.getFirst()).setItem(remaining);
                    if (remaining.isEmpty()) {
                        ((ItemEntity)t.getFirst()).discard();
                    }
                });
            }
        }
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (!player.getItemInHand(hand).is(IETags.hammers)) {
            return InteractionResult.PASS;
        }
        if (!isClient) {
            State state = ctx.getState();
            state.allowPartialFill = !state.allowPartialFill;
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.bottling_machine." + (state.allowPartialFill ? "partialFill" : "completeFill"))), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAt(Capabilities.ItemHandler.BLOCK, ITEM_INPUT_POS, state -> state.itemInput);
        register.register(Capabilities.FluidHandler.BLOCK, (state, pos) -> {
            if (FLUID_INPUT_POS_BACK.equalsOrNullFace(pos) || FLUID_INPUT_POS_SIDE.equals(pos)) {
                return state.fluidInput;
            }
            return null;
        });
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT_POS, state -> state.energy);
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof BottlingProcess)) continue;
            BottlingProcess bottlingProcess = (BottlingProcess)process;
            bottlingProcess.inputItems.forEach(drop);
        }
        state.processor.clear();
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return BottlingMachineShapes.SHAPE_GETTER;
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getLiftTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<BottlingMachineRecipe> {
        public final MultiblockProcessor.InWorldProcessor<BottlingMachineRecipe> processor;
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final FluidTank tank = new FluidTank(8000);
        boolean allowPartialFill;
        public boolean active;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final IItemHandler itemInput;
        private final IFluidHandler fluidInput;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            this.processor = new MultiblockProcessor.InWorldProcessor<BottlingMachineRecipe>(2, maxTicks -> 1.0f - (BottlingMachineLogic.getTransportTime(maxTicks) + BottlingMachineLogic.getLiftTime(maxTicks)) / (float)maxTicks, 2, markDirty, sync, BottlingMachineRecipe.RECIPES::getById);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.itemInput = new BottlingInsertionHandler(ctx.levelSupplier(), this.processor, this);
            this.fluidInput = new ArrayFluidHandler((IFluidTank)this.tank, false, true, () -> {
                markDirty.run();
                sync.run();
            });
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<IFluidHandler>(this.fluidInput, MachineInterfaceHandler.BASIC_FLUID_IN), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.put("processor", this.processor.toNBT());
            nbt.put("energy", this.energy.serializeNBT());
            nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.putBoolean("allowPartialFill", this.allowPartialFill);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.processor.fromNBT(nbt.get("processor"), BottlingProcess.loader(this));
            this.energy.deserializeNBT(nbt.get("energy"));
            this.tank.readFromNBT(nbt.getCompound("tank"));
            this.allowPartialFill = nbt.getBoolean("allowPartialFill");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.put("processor", this.processor.toNBT());
            nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.putBoolean("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.processor.fromNBT(nbt.get("processor"), BottlingProcess.loader(this));
            this.tank.readFromNBT(nbt.getCompound("tank"));
            this.active = nbt.getBoolean("active");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }
    }
}

