/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingMachineLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BottlingProcess
extends MultiblockProcessInWorld<BottlingMachineRecipe> {
    private static final RecipeHolder<BottlingMachineRecipe> DUMMY_RECIPE = new RecipeHolder(IEApi.ieLoc("bottling_dummy"), (Recipe)new BottlingMachineRecipe(new TagOutputList(TagOutput.EMPTY), IngredientWithSize.of(ItemStack.EMPTY), new FluidTagInput((TagKey<Fluid>)FluidTags.WATER, 0)));
    private static final float TRANSFORMATION_POINT = 0.45f;
    private final boolean isFilling;
    private final List<ItemStack> filledContainer;
    private final FluidTank tank;
    private final BooleanSupplier allowPartialFill;

    public BottlingProcess(BiFunction<Level, ResourceLocation, BottlingMachineRecipe> getRecipe, CompoundTag nbt, BottlingMachineLogic.State state) {
        super(nbt.getBoolean("isFilling") ? ($, $1) -> (BottlingMachineRecipe)DUMMY_RECIPE.value() : getRecipe, nbt);
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = nbt.getBoolean("isFilling");
        ListTag filledNBT = nbt.getList("filledContainer", 10);
        this.filledContainer = new ArrayList<ItemStack>();
        for (int i = 0; i < filledNBT.size(); ++i) {
            this.filledContainer.add(ItemStack.of((CompoundTag)filledNBT.getCompound(i)));
        }
    }

    public BottlingProcess(RecipeHolder<BottlingMachineRecipe> recipe, NonNullList<ItemStack> inputItem, BottlingMachineLogic.State state) {
        super(recipe, 0.45f, inputItem);
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = false;
        this.filledContainer = List.of();
    }

    public BottlingProcess(ItemStack inputItem, ItemStack currentContainer, BottlingMachineLogic.State state) {
        super(DUMMY_RECIPE, 0.45f, (NonNullList<ItemStack>)NonNullList.withSize((int)1, (Object)inputItem));
        this.tank = state.tank;
        this.allowPartialFill = () -> state.allowPartialFill;
        this.isFilling = true;
        this.filledContainer = Arrays.asList(currentContainer);
    }

    public static MultiblockProcessor.InWorldProcessLoader<BottlingMachineRecipe> loader(BottlingMachineLogic.State state) {
        return (getRecipe, tag) -> {
            if (tag.getBoolean("isFilling")) {
                return new BottlingProcess((level, resourceLocation) -> (BottlingMachineRecipe)DUMMY_RECIPE.value(), tag, state);
            }
            return new BottlingProcess(getRecipe, tag, state);
        };
    }

    @Override
    public void doProcessTick(ProcessContext.ProcessContextInWorld<BottlingMachineRecipe> context, IMultiblockLevel level) {
        FluidStack fs;
        super.doProcessTick(context, level);
        Level rawLevel = level.getRawLevel();
        float transPoint = (float)this.getMaxTicks(rawLevel) * this.transformationPoint;
        if ((float)this.processTick >= transPoint && (float)this.processTick < 1.0f + transPoint && !(fs = this.tank.getFluid()).isEmpty()) {
            if (this.isFilling) {
                ItemStack ret = FluidUtils.fillFluidContainer((IFluidHandler)this.tank, this.filledContainer.get(0), ItemStack.EMPTY, null);
                if (!ret.isEmpty()) {
                    this.filledContainer.set(0, ret);
                }
                if (!this.allowPartialFill.getAsBoolean() && !FluidUtils.isFluidContainerFull(ret)) {
                    --this.processTick;
                }
            } else {
                this.tank.drain(((BottlingMachineRecipe)this.getRecipe((Level)rawLevel)).fluidInput.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public List<ItemStack> getDisplayItem(Level level) {
        if (this.isFilling) {
            return this.filledContainer;
        }
        return super.getDisplayItem(level);
    }

    @Override
    protected List<ItemStack> getRecipeItemOutputs(Level level, ProcessContext.ProcessContextInWorld<BottlingMachineRecipe> context) {
        if (this.isFilling) {
            return this.filledContainer;
        }
        return super.getRecipeItemOutputs(level, context);
    }

    @Override
    public void writeExtraDataToNBT(CompoundTag nbt) {
        super.writeExtraDataToNBT(nbt);
        nbt.putBoolean("isFilling", this.isFilling);
        ListTag filledNBT = new ListTag();
        for (ItemStack stack : this.filledContainer) {
            filledNBT.add((Object)stack.save(new CompoundTag()));
        }
        nbt.put("filledContainer", (Tag)filledNBT);
    }
}

