/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.sawmill.SawmillProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SawmillShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.InsertOnlyInventory;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SawmillLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final int MAX_PROCESSES = 6;
    private static final CapabilityPosition INPUT = new CapabilityPosition(0, 1, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace PRIMARY_OUTPUT = new MultiblockFace(5, 1, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace SIDE_OUTPUT = new MultiblockFace(3, 0, 3, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 2);
    private static final AABB SAWBLADE_AABB = new AABB(2.6875, 1.0, 1.375, 4.3125, 2.0, 1.625);
    public static ResourceLocation MIF_CONDITION_SAWBLADE = new ResourceLocation("immersiveengineering", "sawmill/blade");

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        boolean rsAllowed = state.rsState.isEnabled(context);
        int i = 0;
        Iterator<SawmillProcess> processIterator = state.sawmillProcessQueue.iterator();
        HashSet<ItemStack> secondaries = new HashSet<ItemStack>();
        while (rsAllowed && processIterator.hasNext() && i++ < 6) {
            SawmillProcess process = processIterator.next();
            if (process.processStep(rawLevel, state.energy, state.sawblade, secondaries)) {
                context.markMasterDirty();
            }
            if (!process.isProcessFinished()) continue;
            state.output.insertOrDrop(process.getCurrentStack(rawLevel, !state.sawblade.isEmpty()).copy(), level);
            processIterator.remove();
            if (state.sawblade.hurt(((Integer)IEServerConfig.MACHINES.sawmill_bladeDamage.get()).intValue(), ApiUtils.RANDOM_SOURCE, null)) {
                state.sawblade = ItemStack.EMPTY;
            }
            context.markDirtyAndSync();
        }
        for (ItemStack output : secondaries) {
            state.secondaryOutput.insertOrDrop(output.copy(), level);
        }
        ActiveState renderActive = state.energy.getEnergyStored() <= 0 || !rsAllowed || state.sawblade.isEmpty() ? ActiveState.DISABLED : (state.sawmillProcessQueue.isEmpty() ? ActiveState.IDLE : ActiveState.SAWING);
        if (state.active != renderActive) {
            state.active = renderActive;
            context.markDirtyAndSync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> ctx) {
        boolean shouldPlay;
        IMultiblockLevel level = ctx.getLevel();
        State state = ctx.getState();
        boolean bl = shouldPlay = state.active != ActiveState.DISABLED || state.lastSoundState != ActiveState.DISABLED;
        if (shouldPlay && !state.soundPlaying.get((Object)state.active).getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(2.5, 1.0, 1.5));
            ActiveState active = state.active;
            Holder<SoundEvent> sound = switch (active) {
                default -> throw new IncompatibleClassChangeError();
                case ActiveState.DISABLED -> IESounds.saw_shutdown;
                case ActiveState.IDLE -> IESounds.saw_empty;
                case ActiveState.SAWING -> IESounds.saw_full;
            };
            state.soundPlaying.put(state.active, MultiblockSound.startSound(() -> state.active == active, ctx.isValid(), soundPos, sound, state.active != ActiveState.DISABLED, 0.4f));
        }
        state.lastSoundState = state.active;
        if (state.active == ActiveState.DISABLED) {
            return;
        }
        state.animation_bladeRotation += 36.0f;
        state.animation_bladeRotation %= 360.0f;
        state.sawmillProcessQueue.forEach(SawmillProcess::incrementProcessOnClient);
        Level rawLevel = level.getRawLevel();
        Optional<SawmillProcess> process = state.sawmillProcessQueue.stream().filter(p -> p.isSawing(rawLevel)).findFirst();
        if (process.isPresent()) {
            Direction particleDir = level.toAbsolute(RelativeBlockFace.RIGHT);
            AABB aabb = level.toAbsolute(SAWBLADE_AABB);
            double posX = aabb.minX + rawLevel.random.nextDouble() * (aabb.maxX - aabb.minX);
            double posY = aabb.minY + rawLevel.random.nextDouble() * (aabb.maxY - aabb.minY);
            double posZ = aabb.minZ + rawLevel.random.nextDouble() * (aabb.maxZ - aabb.minZ);
            double vX = rawLevel.random.nextDouble() * (double)particleDir.getStepX() * 0.3;
            double vY = rawLevel.random.nextDouble() * 0.3;
            double vZ = rawLevel.random.nextDouble() * (double)particleDir.getStepZ() * 0.3;
            rawLevel.addAlwaysVisibleParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, process.get().getCurrentStack(rawLevel, true)), posX, posY, posZ, vX, vY, vZ);
            ++state.count;
            if (state.count % 21 == 0) {
                rawLevel.playSound(ImmersiveEngineering.proxy.getClientPlayer(), level.toAbsolute(new BlockPos(2, 1, 1)), (SoundEvent)IESounds.saw_full.value(), SoundSource.BLOCKS, 0.4f, 1.0f);
            }
        } else if (state.count != -1) {
            state.count = -1;
        }
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT, state -> state.energy);
        register.registerAt(Capabilities.ItemHandler.BLOCK, INPUT, state -> state.insertionHandler);
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        State state = ctx.getState();
        IMultiblockLevel level = ctx.getLevel();
        Level rawLevel = level.getRawLevel();
        if (rawLevel.isClientSide || collided == null || !collided.isAlive() || !state.rsState.isEnabled(ctx)) {
            return;
        }
        if (new BlockPos(0, 1, 1).equals((Object)posInMultiblock) && collided instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)collided;
            ItemStack stack = itemEntity.getItem();
            if (stack.isEmpty()) {
                return;
            }
            if (SawmillLogic.insertItemToProcess(stack = stack.copy(), false, state, rawLevel)) {
                ctx.markDirtyAndSync();
            }
            if (stack.getCount() <= 0) {
                collided.discard();
            } else {
                itemEntity.setItem(stack);
            }
            return;
        }
        AABB absoluteBladeBB = level.toAbsolute(SAWBLADE_AABB);
        if (collided instanceof LivingEntity && !state.sawblade.isEmpty() && absoluteBladeBB.intersects(collided.getBoundingBox())) {
            this.hurtEntity(collided, ctx);
        }
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        State state = ctx.getState();
        ItemStack heldItem = player.getItemInHand(hand);
        if (state.rsState.isEnabled(ctx) && !state.sawblade.isEmpty()) {
            if (!isClient && player.isShiftKeyDown() && heldItem.isEmpty()) {
                this.hurtEntity((Entity)player, ctx);
            }
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && !state.sawblade.isEmpty() && heldItem.isEmpty()) {
            player.setItemInHand(hand, state.sawblade.copy());
            state.sawblade = ItemStack.EMPTY;
            ctx.markDirtyAndSync();
            return InteractionResult.SUCCESS;
        }
        if (heldItem.is(IETags.sawblades)) {
            ItemStack tempBlade = !state.sawblade.isEmpty() ? state.sawblade.copy() : ItemStack.EMPTY;
            state.sawblade = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
            heldItem.shrink(1);
            player.setItemInHand(hand, heldItem);
            if (!tempBlade.isEmpty()) {
                if (heldItem.isEmpty()) {
                    player.setItemInHand(hand, tempBlade);
                } else if (!isClient) {
                    player.spawnAtLocation(tempBlade, 0.0f);
                }
            }
            ctx.markDirtyAndSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void hurtEntity(Entity toHurt, IMultiblockContext<State> ctx) {
        if (toHurt instanceof Player) {
            Player player = (Player)toHurt;
            if (player.getAbilities().invulnerable) {
                return;
            }
        }
        if (!ctx.getState().rsState.isEnabled(ctx)) {
            return;
        }
        int consumed = ctx.getState().energy.extractEnergy(80, false);
        if (consumed > 0) {
            toHurt.hurt(IEDamageSources.sawmill(ctx.getLevel().getRawLevel()), 7.0f);
            ctx.markMasterDirty();
        }
    }

    private static boolean insertItemToProcess(ItemStack stack, boolean simulate, State state, Level rawLevel) {
        if (state.sawmillProcessQueue.size() >= 6) {
            return false;
        }
        float dist = 1.0f;
        float minProcessDist = 0.1f;
        SawmillProcess p = null;
        if (state.sawmillProcessQueue.size() > 0) {
            p = state.sawmillProcessQueue.get(state.sawmillProcessQueue.size() - 1);
            if (p != null) {
                dist = p.getRelativeProcessStep(rawLevel);
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)p.getInput()) || state.combinedLogs > 2) {
                    if (!simulate) {
                        state.combinedLogs = 0;
                    }
                    minProcessDist = 0.5f;
                }
            }
        } else if (state.combinedLogs > 0) {
            state.combinedLogs = 0;
        }
        if (p != null && dist < minProcessDist) {
            return false;
        }
        if (!simulate) {
            p = new SawmillProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            state.sawmillProcessQueue.add(p);
            ++state.combinedLogs;
        }
        stack.shrink(1);
        return true;
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        if (!state.sawblade.isEmpty()) {
            drop.accept(state.sawblade);
            state.sawblade = ItemStack.EMPTY;
        }
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SawmillShapes.SHAPE_GETTER;
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(state -> Mth.ceil((float)(state.getSawbladeComparatorValue() * 15.0f)), REDSTONE_POS);
    }

    static {
        MachineInterfaceHandler.register(MIF_CONDITION_SAWBLADE, MachineInterfaceHandler.buildComparativeConditions(State::getSawbladeComparatorValue));
    }

    public static class State
    implements IMultiblockState {
        private final MutableEnergyStorage energy = new MutableEnergyStorage(32000);
        public ItemStack sawblade = ItemStack.EMPTY;
        public final List<SawmillProcess> sawmillProcessQueue = new ArrayList<SawmillProcess>();
        private int combinedLogs = 0;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final DroppingMultiblockOutput secondaryOutput;
        private final IItemHandler insertionHandler;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        public ActiveState active = ActiveState.DISABLED;
        private int count = 0;
        public float animation_bladeRotation = 0.0f;
        private final EnumMap<ActiveState, BooleanSupplier> soundPlaying = new EnumMap(ActiveState.class);
        private ActiveState lastSoundState = ActiveState.DISABLED;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(PRIMARY_OUTPUT, ctx);
            this.secondaryOutput = new DroppingMultiblockOutput(SIDE_OUTPUT, ctx);
            final Supplier<@Nullable Level> levelGetter = ctx.levelSupplier();
            final Runnable markDirty = ctx.getMarkDirtyRunnable();
            final Runnable sync = ctx.getSyncRunnable();
            this.insertionHandler = new InsertOnlyInventory(){

                @Override
                protected ItemStack insert(ItemStack toInsert, boolean simulate) {
                    if (SawmillLogic.insertItemToProcess(toInsert = toInsert.copy(), simulate, this, (Level)levelGetter.get())) {
                        markDirty.run();
                        sync.run();
                    }
                    return toInsert;
                }
            };
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active == ActiveState.SAWING, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<State>(this, MachineInterfaceHandler.BASIC_ITEM_IN, MachineInterfaceHandler.buildComparativeConditions(s -> (float)s.sawmillProcessQueue.size() / 6.0f)), new MachineInterfaceHandler.MachineCheckImplementation<MutableEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY), new MachineInterfaceHandler.MachineCheckImplementation<State>(this, MIF_CONDITION_SAWBLADE)};
            for (ActiveState state : ActiveState.values()) {
                this.soundPlaying.put(state, () -> false);
            }
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.put("energy", this.energy.serializeNBT());
            nbt.putInt("combinedLogs", this.combinedLogs);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.get("energy"));
            this.readCommonNBT(nbt);
            this.combinedLogs = nbt.getInt("combinedLogs");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.putInt("active", this.active.ordinal());
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            this.active = ActiveState.values()[nbt.getInt("active")];
        }

        private void writeCommonNBT(CompoundTag nbt) {
            nbt.put("sawblade", (Tag)this.sawblade.save(new CompoundTag()));
            ListTag processes = new ListTag();
            for (SawmillProcess process : this.sawmillProcessQueue) {
                processes.add((Object)process.writeToNBT());
            }
            nbt.put("processes", (Tag)processes);
        }

        private void readCommonNBT(CompoundTag nbt) {
            this.sawblade = ItemStack.of((CompoundTag)nbt.getCompound("sawblade"));
            ListTag processes = nbt.getList("processes", 10);
            this.sawmillProcessQueue.clear();
            for (int i = 0; i < processes.size(); ++i) {
                this.sawmillProcessQueue.add(SawmillProcess.readFromNBT(processes.getCompound(i)));
            }
        }

        public IEnergyStorage getEnergy() {
            return this.energy;
        }

        private float getSawbladeComparatorValue() {
            if (this.sawblade.isEmpty()) {
                return 0.0f;
            }
            return 1.0f - (float)this.sawblade.getDamageValue() / (float)this.sawblade.getMaxDamage();
        }
    }

    public static enum ActiveState {
        DISABLED,
        IDLE,
        SAWING;

    }
}

