/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.InsertOnlyInventory;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class DirectProcessingItemHandler<R extends MultiblockRecipe>
extends InsertOnlyInventory {
    private static final float TRANSFORMATION_POINT = 0.5f;
    private boolean doProcessStacking = false;
    protected final Supplier<Level> level;
    protected final MultiblockProcessor<R, ProcessContext.ProcessContextInWorld<R>> processor;
    private final BiFunction<Level, ItemStack, @Nullable RecipeHolder<R>> getRecipeOnInsert;

    public DirectProcessingItemHandler(Supplier<Level> level, MultiblockProcessor<R, ProcessContext.ProcessContextInWorld<R>> processor, BiFunction<Level, ItemStack, @Nullable RecipeHolder<R>> getRecipeOnInsert) {
        this.level = level;
        this.processor = processor;
        this.getRecipeOnInsert = getRecipeOnInsert;
    }

    public DirectProcessingItemHandler<R> setProcessStacking(boolean stacking) {
        this.doProcessStacking = stacking;
        return this;
    }

    @Override
    protected ItemStack insert(ItemStack stack, boolean simulate) {
        ItemStack displayStack;
        stack = stack.copy();
        RecipeHolder<R> recipe = this.getRecipeOnInsert.apply(this.level.get(), stack);
        if (recipe == null) {
            return stack;
        }
        if (!this.doProcessStacking) {
            displayStack = ((MultiblockRecipe)recipe.value()).getDisplayStack(stack);
            displayStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)displayStack.getCount());
        } else {
            displayStack = stack.copy();
        }
        if (this.processor.addProcessToQueue(new MultiblockProcessInWorld<R>(recipe, 0.5f, Utils.createNonNullItemStackListFromItemStack(displayStack)), this.level.get(), simulate, this.doProcessStacking)) {
            stack.shrink(displayStack.getCount());
        }
        return stack;
    }
}

