/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class MultiblockProcessInWorld<R extends MultiblockRecipe>
extends MultiblockProcess<R, ProcessContext.ProcessContextInWorld<R>> {
    public NonNullList<ItemStack> inputItems;
    protected float transformationPoint;

    public MultiblockProcessInWorld(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, float transformationPoint, NonNullList<ItemStack> inputItem) {
        super(recipeId, getRecipe);
        this.inputItems = inputItem;
        this.transformationPoint = transformationPoint;
    }

    public MultiblockProcessInWorld(RecipeHolder<R> recipe, float transformationPoint, NonNullList<ItemStack> inputItem) {
        super(recipe);
        this.inputItems = inputItem;
        this.transformationPoint = transformationPoint;
    }

    public MultiblockProcessInWorld(BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
        super(getRecipe, data);
        this.inputItems = NonNullList.withSize((int)data.getInt("numInputs"), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)data, this.inputItems);
        this.transformationPoint = data.getFloat("process_transformationPoint");
    }

    public MultiblockProcessInWorld(RecipeHolder<R> recipe, ItemStack input) {
        this(recipe, 0.5f, Utils.createNonNullItemStackListFromItemStack(input));
    }

    public List<ItemStack> getDisplayItem(Level level) {
        NonNullList<ItemStack> list;
        MultiblockProcess.LevelDependentData levelData = this.getLevelData(level);
        if ((float)this.processTick / (float)levelData.maxTicks() > this.transformationPoint && levelData.recipe() != null && !(list = ((MultiblockRecipe)levelData.recipe()).getItemOutputs()).isEmpty()) {
            return list;
        }
        return this.inputItems;
    }

    @Override
    public void writeExtraDataToNBT(CompoundTag nbt) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inputItems);
        nbt.putInt("numInputs", this.inputItems.size());
        nbt.putFloat("process_transformationPoint", this.transformationPoint);
    }

    @Override
    protected boolean canOutputItem(ProcessContext.ProcessContextInWorld<R> context, ItemStack output) {
        return true;
    }

    @Override
    protected boolean canOutputFluid(ProcessContext.ProcessContextInWorld<R> context, FluidStack output) {
        return false;
    }

    @Override
    protected void outputItem(ProcessContext.ProcessContextInWorld<R> context, ItemStack output, IMultiblockLevel level) {
        context.doProcessOutput(output, level);
    }

    @Override
    protected void outputFluid(ProcessContext.ProcessContextInWorld<R> context, FluidStack output) {
        context.doProcessFluidOutput(output);
    }

    @Override
    protected void processFinish(ProcessContext.ProcessContextInWorld<R> context, IMultiblockLevel level) {
        super.processFinish(context, level);
        int size = -1;
        Object recipe = this.getLevelData(level.getRawLevel()).recipe();
        if (recipe == null) {
            return;
        }
        for (ItemStack inputItem : this.inputItems) {
            for (IngredientWithSize s : ((MultiblockRecipe)recipe).getItemInputs()) {
                if (!s.test(inputItem)) continue;
                size = s.getCount();
                break;
            }
            if (size <= 0 || inputItem.getCount() <= size) continue;
            inputItem.split(size);
            this.processTick = 0;
            this.clearProcess = false;
        }
    }
}

