/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoresampleBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds {
    public ItemStack coresample = ItemStack.EMPTY;
    private Component[] overlay = null;
    private static final VoxelShape AABB_CORESAMPLE_X = Shapes.box((double)0.0, (double)0.0, (double)0.28125, (double)1.0, (double)1.0, (double)0.71875);
    private static final VoxelShape AABB_CORESAMPLE_Z = Shapes.box((double)0.28125, (double)0.0, (double)0.0, (double)0.71875, (double)1.0, (double)1.0);

    public CoresampleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CORE_SAMPLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.coresample = ItemStack.of((CompoundTag)nbt.getCompound("coresample"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.put("coresample", (Tag)this.coresample.save(new CompoundTag()));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        ColumnPos coords = CoresampleItem.getCoords(this.coresample);
        if (player.isShiftKeyDown()) {
            if (!this.level.isClientSide) {
                ItemEntity entityitem = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), this.coresample, 0.0, 0.0, 0.0);
                this.level.removeBlock(this.worldPosition, false);
                this.level.addFreshEntity((Entity)entityitem);
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        if (!heldItem.isEmpty() && heldItem.getItem() == Items.FILLED_MAP && coords != null) {
            MapItemSavedData mapData;
            if (!this.level.isClientSide && (mapData = MapItem.getSavedData((ItemStack)heldItem, (Level)player.getCommandSenderWorld())) != null) {
                if (mapData.dimension != CoresampleItem.getDimension(this.coresample)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.coresample.mapDimension"));
                    return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
                }
                String ident = "ie:coresample_" + coords;
                CompoundTag mapTagCompound = heldItem.getOrCreateTag();
                ListTag nbttaglist = mapTagCompound.getList("Decorations", 10);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundTag tagCompound = (CompoundTag)nbttaglist.get(i);
                    if (!ident.equalsIgnoreCase(tagCompound.getString("id"))) continue;
                    nbttaglist.remove(i);
                    mapTagCompound.put("Decorations", (Tag)nbttaglist);
                    return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
                }
                double sampleX = (double)coords.x() + 0.5;
                double sampleZ = (double)coords.z() + 0.5;
                int mapScale = 1 << mapData.scale;
                float distX = (float)(sampleX - (double)mapData.centerX) / (float)mapScale;
                float distZ = (float)(sampleZ - (double)mapData.centerZ) / (float)mapScale;
                if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                    CompoundTag tagCompound = new CompoundTag();
                    tagCompound.putString("id", ident);
                    tagCompound.putByte("type", MapDecoration.Type.TARGET_POINT.getIcon());
                    tagCompound.putDouble("x", sampleX);
                    tagCompound.putDouble("z", sampleZ);
                    tagCompound.putDouble("rot", 180.0);
                    tagCompound.put("minerals", (Tag)CoresampleItem.getSimplifiedMineralList(this.level, this.coresample));
                    nbttaglist.add((Object)tagCompound);
                    mapTagCompound.put("Decorations", (Tag)nbttaglist);
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.coresample.mapFail"));
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public Component getDisplayName() {
        if (this.coresample.hasCustomHoverName()) {
            return this.coresample.getHoverName();
        }
        return Component.translatable((String)"item.immersiveengineering.coresample.name");
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        drop.accept(this.coresample);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        this.coresample = ctx.getItemInHand().copy();
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (this.overlay == null) {
            ArrayList<Component> list = new ArrayList<Component>();
            CoresampleItem.getCoresampleInfo(this.coresample, list, ChatFormatting.WHITE, this.level, false, false);
            this.overlay = list.toArray(new Component[0]);
        }
        return this.overlay;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getFacing().getAxis() == Direction.Axis.Z ? AABB_CORESAMPLE_Z : AABB_CORESAMPLE_X;
    }
}

