/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CircuitTableBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IInteractionObjectIE<CircuitTableBlockEntity>,
IModelOffsetProvider {
    public static final BlockPos MASTER_POS = BlockPos.ZERO;
    public static final BlockPos DUMMY_POS = new BlockPos(1, 0, 0);
    public static final String[] SLOT_TYPES = new String[]{"backplane", "logic", "solder"};
    public static final int ASSEMBLY_ENERGY = 5000;
    public static final int ENERGY_CAPACITY = 32000;
    public static final int NUM_SLOTS = SLOT_TYPES.length + 1;
    public final MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000);
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)NUM_SLOTS, (Object)ItemStack.EMPTY);
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, CircuitTableBlockEntity::master, this.makeEnergyInput(this.energyStorage));

    public CircuitTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CIRCUIT_TABLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        if (!descPacket) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        if (!descPacket) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory);
        }
    }

    public static int getEditSlot() {
        return SLOT_TYPES.length;
    }

    public static int getIngredientAmount(LogicCircuitHandler.LogicCircuitInstruction instruction, int slot) {
        return switch (slot) {
            case 0 -> 1;
            case 1 -> instruction.getOperator().getComplexity();
            case 2 -> (int)Math.ceil((float)(instruction.getOperator().getComplexity() + instruction.getInputs().length + 1) / 2.0f);
            default -> -1;
        };
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public CircuitTableBlockEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public IEMenuTypes.ArgContainer<CircuitTableBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CIRCUIT_TABLE;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    @Nullable
    public CircuitTableBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE != null) {
            return (CircuitTableBlockEntity)this.tempMasterBE;
        }
        Direction dummyDir = this.isDummy() ? this.getFacing().getCounterClockWise() : this.getFacing().getClockWise();
        BlockPos masterPos = this.getBlockPos().relative(dummyDir);
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof CircuitTableBlockEntity ? (CircuitTableBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        DeskBlock.placeDummies(this.getBlockState(), this.level, this.worldPosition, ctx);
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterBE = this.master();
        Direction dummyDir = this.isDummy() ? this.getFacing().getCounterClockWise() : this.getFacing().getClockWise();
        this.level.removeBlock(pos.relative(dummyDir), false);
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return DUMMY_POS;
        }
        return MASTER_POS;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<CircuitTableBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> {
            if (side == null || side == be.getFacing() && be.isDummy()) {
                return be.energyCap.get();
            }
            return null;
        });
    }
}

