/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.EnumMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemBatcherBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<ItemBatcherBlockEntity>,
IEBlockInterfaces.IStateBasedDirectional {
    public static final int NUM_SLOTS = 9;
    private final NonNullList<ItemStack> filters = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> buffers = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    public BatchMode batchMode = BatchMode.ALL;
    public NonNullList<DyeColor> redstoneColors = NonNullList.withSize((int)9, (Object)DyeColor.WHITE);
    private final IEBlockCapabilityCaches.IEBlockCapabilityCache<IItemHandler> output = IEBlockCapabilityCaches.forNeighbor(Capabilities.ItemHandler.BLOCK, this, this::getFacing);
    private final IItemHandler insertionCap = new IEInventoryHandler(9, (IIEInventory)this, 0, true, false);
    private final CapabilityRedstoneNetwork.RedstoneBundleConnection redstoneCap = new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

        @Override
        public void updateInput(byte[] signals, Direction side) {
            Set<DyeColor> outputMap = ItemBatcherBlockEntity.this.calculateRedstoneOutputs();
            for (DyeColor dye : outputMap) {
                signals[dye.getId()] = (byte)Math.max(signals[dye.getId()], 15);
            }
        }
    };

    public ItemBatcherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.ITEM_BATCHER.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.isShiftKeyDown();
    }

    @Override
    public void tickServer() {
        if (this.level.getGameTime() % 8L != 0L || !this.isActive()) {
            return;
        }
        IItemHandler outputHandler = this.output.getCapability();
        if (outputHandler != null) {
            boolean matched = true;
            if (this.batchMode == BatchMode.ALL) {
                for (int slot = 0; slot < 9; ++slot) {
                    if (((ItemStack)this.filters.get(slot)).isEmpty()) continue;
                    matched &= this.isFilterMatched(slot);
                }
            }
            if (matched) {
                boolean anySent = false;
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack filterStack = (ItemStack)this.filters.get(slot);
                    if (filterStack.isEmpty() || this.batchMode != BatchMode.ALL && !this.isFilterMatched(slot)) continue;
                    ItemStack outStack = (ItemStack)this.buffers.get(slot);
                    int outSize = filterStack.getCount();
                    ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)outStack, (int)outSize);
                    if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).isEmpty()) {
                        outSize -= stack.getCount();
                    }
                    outStack.shrink(outSize);
                    if (outStack.getCount() <= 0) {
                        this.buffers.set(slot, (Object)ItemStack.EMPTY);
                    }
                    anySent = true;
                }
                if (anySent) {
                    this.redstoneCap.markDirty();
                }
            }
        }
    }

    protected boolean isActive() {
        return !this.isRSPowered();
    }

    protected boolean isFilterMatched(int slot) {
        return ItemUtils.isSameIgnoreDurability((ItemStack)this.filters.get(slot), (ItemStack)this.buffers.get(slot)) && ((ItemStack)this.buffers.get(slot)).getCount() >= ((ItemStack)this.filters.get(slot)).getCount();
    }

    protected Set<DyeColor> calculateRedstoneOutputs() {
        EnumMap<DyeColor, Boolean> map = new EnumMap<DyeColor, Boolean>(DyeColor.class);
        for (int slot = 0; slot < 9; ++slot) {
            DyeColor dye;
            if (((ItemStack)this.filters.get(slot)).isEmpty()) continue;
            Boolean ex = (Boolean)map.get(dye = (DyeColor)this.redstoneColors.get(slot));
            map.put(dye, ex != null ? ex.booleanValue() && this.isFilterMatched(slot) : this.isFilterMatched(slot));
        }
        return map.keySet().stream().filter(map::get).collect(Collectors.toSet());
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int i;
        if (!descPacket) {
            NonNullList merged = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)merged);
            for (i = 0; i < 9; ++i) {
                this.buffers.set(i, (Object)((ItemStack)merged.get(i + 9)));
                this.filters.set(i, (Object)((ItemStack)merged.get(i)));
            }
        }
        this.batchMode = BatchMode.values()[nbt.getByte("batchMode")];
        int[] redstoneConfig = nbt.getIntArray("redstoneColors");
        if (redstoneConfig.length >= 9) {
            for (i = 0; i < 9; ++i) {
                this.redstoneColors.set(i, (Object)DyeColor.byId((int)redstoneConfig[i]));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int i;
        if (!descPacket) {
            NonNullList merged = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
            for (i = 0; i < 9; ++i) {
                merged.set(i + 9, (Object)((ItemStack)this.buffers.get(i)));
                merged.set(i, (Object)((ItemStack)this.filters.get(i)));
            }
            ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)merged);
        }
        nbt.putByte("batchMode", (byte)this.batchMode.ordinal());
        int[] redstoneConfig = new int[9];
        for (i = 0; i < 9; ++i) {
            redstoneConfig[i] = ((DyeColor)this.redstoneColors.get(i)).getId();
        }
        nbt.putIntArray("redstoneColors", redstoneConfig);
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("batchMode")) {
            this.batchMode = BatchMode.values()[message.getByte("batchMode")];
        }
        if (message.contains("redstoneColor_slot") && message.contains("redstoneColor_val")) {
            this.redstoneColors.set(message.getInt("redstoneColor_slot"), (Object)DyeColor.byId((int)message.getInt("redstoneColor_val")));
        }
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ItemBatcherBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<ItemBatcherBlockEntity, ?> getContainerType() {
        return IEMenuTypes.ITEM_BATCHER;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.buffers;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return ItemUtils.isSameIgnoreDurability((ItemStack)this.filters.get(slot), stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
        this.redstoneCap.markDirty();
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<ItemBatcherBlockEntity> registrar) {
        registrar.registerAllContexts(CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION, be -> be.redstoneCap);
        registrar.register(Capabilities.ItemHandler.BLOCK, (be, facing) -> facing == be.getFacing().getOpposite() ? be.insertionCap : null);
    }

    public NonNullList<ItemStack> getFilters() {
        return this.filters;
    }

    public static enum BatchMode {
        SINGLE,
        ALL;

    }
}

