/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.gui.CrateMenu;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class WoodenCrateBlockEntity
extends RandomizableContainerBlockEntity
implements IIEInventory,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText {
    public static final int CONTAINER_SIZE = 27;
    public static final int HITS_TO_SEAL = 6;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private ListTag enchantments;
    private int sealingProgress = 0;
    private final IItemHandler inventoryCap = new IEInventoryHandler(27, this);

    public WoodenCrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.WOODEN_CRATE.get(), pos, state);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.loadIEData(nbt);
    }

    private void loadIEData(CompoundTag nbt) {
        if (nbt.contains("enchantments", 9)) {
            this.enchantments = nbt.getList("enchantments", 10);
        }
        if (nbt.contains("lootTable", 8) && !nbt.contains("LootTable")) {
            nbt.putString("LootTable", nbt.getString("lootTable"));
        }
        if (!this.tryLoadLootTable(nbt)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory);
        }
        this.sealingProgress = nbt.getInt("sealingProgress");
    }

    protected void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        if (this.enchantments != null && this.enchantments.size() > 0) {
            nbt.put("enchantments", (Tag)this.enchantments);
        }
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory);
        }
        nbt.putInt("sealingProgress", this.sealingProgress);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, be -> {
            CompoundTag nbttagcompound = new CompoundTag();
            this.saveAdditional(nbttagcompound);
            return nbttagcompound;
        });
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        MutableComponent customName;
        CompoundTag nonNullTag;
        CompoundTag compoundTag = nonNullTag = pkt.getTag() != null ? pkt.getTag() : new CompoundTag();
        if (nonNullTag.contains("CustomName", 8) && (customName = Component.Serializer.fromJson((String)nonNullTag.getString("CustomName"))) != null) {
            this.setCustomName((Component)customName);
        }
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = super.getUpdateTag();
        if (this.getCustomName() != null) {
            nbt.putString("CustomName", Component.Serializer.toJson((Component)this.getCustomName()));
        }
        return nbt;
    }

    protected Component getDefaultName() {
        Block b = this.getBlockState().getBlock();
        if (b == IEBlocks.WoodenDevices.REINFORCED_CRATE.get()) {
            return Component.translatable((String)"block.immersiveengineering.reinforced_crate");
        }
        return Component.translatable((String)"block.immersiveengineering.crate");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> pItemStacks) {
        this.inventory = pItemStacks;
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new CrateMenu(IEMenuTypes.WOODEN_CRATE.get(), pContainerId, pInventory, (Container)this);
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        Component customName;
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        CompoundTag tag = new CompoundTag();
        if (this.isSealed()) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (boolean)false);
        } else {
            this.inventory.forEach(drop);
        }
        if (!tag.isEmpty()) {
            stack.setTag(tag);
        }
        if ((customName = this.getCustomName()) != null) {
            stack.setHoverName(customName);
        }
        if (this.enchantments != null && this.enchantments.size() > 0) {
            stack.getOrCreateTag().put("ench", (Tag)this.enchantments);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        this.onBEPlaced(ctx.getItemInHand());
    }

    public void onBEPlaced(ItemStack stack) {
        if (stack.hasTag()) {
            this.loadIEData(stack.getOrCreateTag());
            if (stack.hasCustomHoverName()) {
                this.setCustomName(stack.getHoverName());
            }
            this.enchantments = stack.getEnchantmentTags();
        }
    }

    public boolean canOpen(Player player) {
        return super.canOpen(player) && !this.isSealed();
    }

    public boolean isSealed() {
        return this.sealingProgress >= 6;
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<WoodenCrateBlockEntity> registrar) {
        registrar.registerAllContexts(Capabilities.ItemHandler.BLOCK, be -> be.inventoryCap);
    }

    public IItemHandler getInventoryCap() {
        return this.inventoryCap;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isStackValid(index, stack);
    }

    @Override
    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory(this);
    }

    public int getContainerSize() {
        return 27;
    }

    @Override
    public InteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.is(IETags.hammers) && player.isCrouching()) {
            if (!player.getCooldowns().isOnCooldown(heldItem.getItem()) && !this.isSealed()) {
                if (++this.sealingProgress >= 6) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.crate_sealed"), true);
                }
                player.playSound(SoundEvents.ZOMBIE_ATTACK_WOODEN_DOOR);
                player.getCooldowns().addCooldown(heldItem.getItem(), 10);
                return InteractionResult.sidedSuccess((boolean)Objects.requireNonNull(this.getLevel()).isClientSide);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        Component customName = this.getCustomName();
        if (customName != null) {
            return new Component[]{this.getCustomName()};
        }
        return null;
    }
}

