/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

public class EarlyConfigLoader
implements AutoCloseable {
    private final ModConfigSpec configSpec;
    private final CommentedFileConfig backingConfig;

    public EarlyConfigLoader(ModConfigSpec spec, ModConfig.Type type) {
        Preconditions.checkState((!spec.isLoaded() ? 1 : 0) != 0);
        this.configSpec = spec;
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("immersiveengineering-" + type.extension() + ".toml");
        this.backingConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).build();
        this.backingConfig.load();
        this.configSpec.setConfig((CommentedConfig)this.backingConfig);
    }

    @Override
    public void close() {
        this.configSpec.setConfig(null);
        this.backingConfig.close();
    }
}

