/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.config;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.client.EarmuffHandler;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEClientConfig {
    public static final ModConfigSpec.BooleanValue showUpdateNews;
    public static final ModConfigSpec.BooleanValue fancyItemHolding;
    public static final ModConfigSpec.BooleanValue stencilBufferEnabled;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> earDefenders_SoundBlacklist;
    public static final ModConfigSpec.BooleanValue enableVBOs;
    public static final ModConfigSpec.BooleanValue disableFancyTESR;
    public static final ModConfigSpec.BooleanValue showTextOverlay;
    public static final ModConfigSpec.IntValue manualGuiScale;
    public static final ModConfigSpec.BooleanValue badEyesight;
    public static boolean lastBadEyesight;
    public static final ModConfigSpec.BooleanValue fractionDisplay;
    public static final ModConfigSpec.BooleanValue tagTooltips;
    public static final ModConfigSpec.DoubleValue increasedTileRenderdistance;
    public static final Map<IEWireTypes.IEWireType, ModConfigSpec.IntValue> wireColors;
    public static final ModConfigSpec CONFIG_SPEC;

    private static void addColor(ModConfigSpec.Builder builder, IEWireTypes.IEWireType type, int defaultColor) {
        wireColors.put(type, builder.defineInRange(type.name().toLowerCase(Locale.ENGLISH), defaultColor, Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent ev) {
        if (CONFIG_SPEC == ev.getConfig().getSpec()) {
            if (lastBadEyesight != (Boolean)badEyesight.get()) {
                lastBadEyesight = (Boolean)badEyesight.get();
                ImmersiveEngineering.proxy.resetManual();
            }
            FluidUtils.enableFractionDisplay = (Boolean)fractionDisplay.get();
            EarmuffHandler.onConfigUpdate();
        }
    }

    static {
        wireColors = new EnumMap<IEWireTypes.IEWireType, ModConfigSpec.IntValue>(IEWireTypes.IEWireType.class);
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        disableFancyTESR = builder.comment(new String[]{"Disables most lighting code for certain models that are rendered dynamically (TESR). May improve FPS.", "Affects turrets and garden cloches"}).define("disableFancyTESR", false);
        showTextOverlay = builder.comment("Show the text overlay for various blocks, such as the configuration of capacitors or pumps").define("showTextOverlay", true);
        manualGuiScale = builder.comment("Set the GUI scale of the Engineer's Manual. This uses the same numbers as Vanilla's GUI Scale and is therefor limited to the maximum value available ingame.").defineInRange("manualGuiScale", 4, 1, 32);
        badEyesight = builder.comment("Set this to true if you suffer from bad eyesight. The Engineer's manual will be switched to a bold and darker text to improve readability.").define("badEyesight", false);
        fractionDisplay = builder.comment("Set this to false to change fluid recipes in the manual to use decimals on buckets instead of fractions").define("fluidFractions", true);
        tagTooltips = builder.comment("Controls if item tooltips should contain the tags names of items. These tooltips are only visible in advanced tooltip mode (F3+H)").define("tagTooltips", false);
        increasedTileRenderdistance = builder.comment("Increase the distance at which certain TileEntities (specifically windmills) are still visible. This is a modifier, so set it to 1 for default render distance, to 2 for doubled distance and so on.").defineInRange("increasedTileRenderdistance", 1.5, 0.0, Double.MAX_VALUE);
        showUpdateNews = builder.comment("Set this to false to hide the update news in the manual").define("showUpdateNews", true);
        fancyItemHolding = builder.comment("Allows revolvers and other IE items to look properly held in 3rd person. This uses a coremod. Can be disabled in case of conflicts with other animation mods.").define("fancyItemHolding", true);
        stencilBufferEnabled = builder.comment("Set to false to disable the stencil buffer. This may be necessary on older GPUs.").define("stencilBufferEnabled", true);
        earDefenders_SoundBlacklist = builder.comment("A list of sounds that should not be muffled by the Ear Defenders. Adding to this list requires knowledge of the correct sound resource names.").defineList("earDefenders_SoundBlacklist", (List)ImmutableList.of(), obj -> true);
        enableVBOs = builder.comment(new String[]{"Use VBOs to render certain blocks. This is significantly faster than the usual rendering,", "but may not work correctly with visual effects from other mods"}).define("enableVBO", true);
        builder.comment("Options to set the RGB color of all IE wire types").push("wire_colors");
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.COPPER, 11758655);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.ELECTRUM, 15573061);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.STEEL, 0x6F6F6F);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.STRUCTURE_ROPE, 9862765);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.STRUCTURE_STEEL, 0x6F6F6F);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.REDSTONE, 0xFF2F2F);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.COPPER_INSULATED, 16445918);
        IEClientConfig.addColor(builder, IEWireTypes.IEWireType.ELECTRUM_INSULATED, 10323322);
        builder.pop();
        CONFIG_SPEC = builder.build();
    }
}

