/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.TagOutputList;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ArcRecyclingRecipe
extends ArcFurnaceRecipe {
    private final Supplier<RegistryAccess> tags;
    private final List<Pair<TagOutput, Double>> outputs;
    private final Lazy<TagOutputList> defaultOutputs;

    public ArcRecyclingRecipe(Supplier<RegistryAccess> tags, List<Pair<TagOutput, Double>> outputs, IngredientWithSize input, int time, int energyPerTick) {
        super(new TagOutputList(outputs.stream().map(Pair::getFirst).toList()), TagOutput.EMPTY, List.of(), time, energyPerTick, input, List.of());
        this.tags = tags;
        this.outputs = outputs;
        this.setSpecialRecipeType("Recycling");
        this.defaultOutputs = Lazy.of(() -> {
            ArrayList<TagOutput> ret = new ArrayList<TagOutput>();
            for (Pair e : outputs) {
                String[] type;
                if ((Double)e.getSecond() >= 1.0) {
                    ret.add(new TagOutput(((TagOutput)e.getFirst()).get().copyWithCount((int)((Double)e.getSecond()).doubleValue())));
                }
                if ((type = TagUtils.getMatchingPrefixAndRemaining((RegistryAccess)tags.get(), ((TagOutput)e.getFirst()).get(), "ingots")) == null || !((Double)e.getSecond() % 1.0 > 0.11)) continue;
                ret.add(new TagOutput(TagUtils.createItemWrapper(IETags.getNugget(type[1])), (int)(9.0 * ((Double)e.getSecond() % 1.0))));
            }
            return new TagOutputList(ret);
        });
    }

    @Override
    public NonNullList<ItemStack> generateActualOutput(ItemStack input, NonNullList<ItemStack> additives, long seed) {
        if (this.outputs == null) {
            return NonNullList.create();
        }
        float mod = !input.isDamageableItem() ? 1.0f : (float)(input.getMaxDamage() - input.getDamageValue()) / (float)input.getMaxDamage();
        NonNullList outs = NonNullList.create();
        for (Pair<TagOutput, Double> e : this.outputs) {
            double scaledOut = (double)mod * (Double)e.getSecond();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)outs, e);
        }
        return outs;
    }

    @Override
    public NonNullList<ItemStack> getBaseOutputs() {
        return ((TagOutputList)this.defaultOutputs.get()).get();
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return ((TagOutputList)this.defaultOutputs.get()).get();
    }

    private void addOutputToList(double scaledOut, NonNullList<ItemStack> outs, Pair<TagOutput, Double> e) {
        ItemStack nuggets;
        String[] type;
        int nuggetOut;
        if (scaledOut >= 1.0) {
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)((TagOutput)e.getFirst()).get(), (int)((int)scaledOut)));
        }
        if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) > 0 && (type = TagUtils.getMatchingPrefixAndRemaining(this.tags.get(), ((TagOutput)e.getFirst()).get(), "ingots")) != null && !(nuggets = IEApi.getPreferredTagStack(this.tags.get(), TagUtils.createItemWrapper(IETags.getNugget(type[1])))).isEmpty()) {
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)nuggets, (int)nuggetOut));
        }
    }

    @Override
    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        return !input.isEmpty() && this.input.test(input);
    }

    public List<Pair<TagOutput, Double>> getOutputs() {
        return this.outputs;
    }
}

