/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EarmuffsRecipe
implements CraftingRecipe {
    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level worldIn) {
        ItemStack earmuffs = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ArmorItem armorItem;
            Item item;
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            boolean isEarmuffs = stackInSlot.is(IEItems.Misc.EARMUFFS.asItem());
            if (earmuffs.isEmpty() && isEarmuffs) {
                earmuffs = stackInSlot;
                continue;
            }
            if (armor.isEmpty() && (item = stackInSlot.getItem()) instanceof ArmorItem && (armorItem = (ArmorItem)item).getEquipmentSlot() == EquipmentSlot.HEAD && !isEarmuffs) {
                armor = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        if (!(earmuffs.isEmpty() || armor.isEmpty() && list.isEmpty())) {
            return true;
        }
        return !armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs") && earmuffs.isEmpty() && list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack earmuffs = ItemStack.EMPTY;
        ItemStack armor = ItemStack.EMPTY;
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            boolean isEarmuffs = stackInSlot.is(IEItems.Misc.EARMUFFS.asItem());
            if (earmuffs.isEmpty() && isEarmuffs) {
                earmuffs = stackInSlot;
                int colour = ((IEItemInterfaces.IColouredItem)earmuffs.getItem()).getColourForIEItem(earmuffs, 0);
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                float[] afloat = Utils.getDye(stackInSlot).getTextureDiffuseColors();
                int r = (int)(afloat[0] * 255.0f);
                int g = (int)(afloat[1] * 255.0f);
                int b = (int)(afloat[2] * 255.0f);
                j += Math.max(r, Math.max(g, b));
                colourArray[0] = colourArray[0] + r;
                colourArray[1] = colourArray[1] + g;
                colourArray[2] = colourArray[2] + b;
                ++totalColourSets;
                continue;
            }
            if (!armor.isEmpty() || !(stackInSlot.getItem() instanceof ArmorItem) || ((ArmorItem)stackInSlot.getItem()).getEquipmentSlot() != EquipmentSlot.HEAD || isEarmuffs) continue;
            armor = stackInSlot;
        }
        if (!earmuffs.isEmpty()) {
            ItemStack output;
            if (totalColourSets > 1) {
                int r = colourArray[0] / totalColourSets;
                int g = colourArray[1] / totalColourSets;
                int b = colourArray[2] / totalColourSets;
                float colourMod = (float)j / (float)totalColourSets;
                float highestColour = Math.max(r, Math.max(g, b));
                r = (int)((float)r * colourMod / highestColour);
                g = (int)((float)g * colourMod / highestColour);
                b = (int)((float)b * colourMod / highestColour);
                int newColour = (r << 8) + g;
                newColour = (newColour << 8) + b;
                ItemNBTHelper.putInt(earmuffs, "IE:EarmuffColour", newColour);
            }
            if (!armor.isEmpty()) {
                output = armor.copy();
                ItemNBTHelper.setItemStack(output, "IE:Earmuffs", earmuffs.copy());
            } else {
                output = earmuffs.copy();
            }
            return output;
        }
        if (!armor.isEmpty() && ItemNBTHelper.hasKey(armor, "IE:Earmuffs")) {
            ItemStack output = armor.copy();
            ItemNBTHelper.remove(output, "IE:Earmuffs");
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess access) {
        return new ItemStack(IEItems.Misc.EARMUFFS, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = super.getRemainingItems((Container)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Earmuffs")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Earmuffs"));
        }
        return remaining;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.EARMUFF_SERIALIZER.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)Ingredient.of((ItemLike[])new ItemLike[]{IEItems.Misc.EARMUFFS}));
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }
}

