/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class IERepairItemRecipe
extends CustomRecipe {
    public IERepairItemRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.findInputSlots(inv).isPresent();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        return this.findInputSlots(inv).map(p -> this.combineStacks((ItemStack)p.getFirst(), (ItemStack)p.getSecond())).orElse(ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.withSize((int)(inv.getHeight() * inv.getWidth()), (Object)ItemStack.EMPTY);
    }

    @Nonnull
    public RecipeSerializer<IERepairItemRecipe> getSerializer() {
        return RecipeSerializers.IE_REPAIR_SERIALIZER.get();
    }

    private Optional<Pair<ItemStack, ItemStack>> findInputSlots(CraftingContainer inv) {
        Optional<Object> first = Optional.empty();
        Optional<Object> second = Optional.empty();
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.isEmpty()) continue;
            if (!this.isValidInput(stack)) {
                return Optional.empty();
            }
            if (first.isPresent() && second.isPresent()) {
                return Optional.empty();
            }
            if (first.isPresent()) {
                ItemStack existing = (ItemStack)first.get();
                if (existing.getItem() != stack.getItem()) {
                    return Optional.empty();
                }
                second = Optional.of(stack);
                continue;
            }
            first = Optional.of(stack);
        }
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(Pair.of((Object)((ItemStack)first.get()), (Object)((ItemStack)second.get())));
        }
        return Optional.empty();
    }

    private boolean isValidInput(ItemStack in) {
        return in.getItem() instanceof IEBaseItem && ((IEBaseItem)in.getItem()).isIERepairable(in);
    }

    private ItemStack combineStacks(ItemStack a, ItemStack b) {
        int remainingA = a.getMaxDamage() - a.getDamageValue();
        int remainingB = a.getMaxDamage() - b.getDamageValue();
        int remainingResult = remainingA + remainingB + a.getMaxDamage() * 5 / 100;
        int damageResult = a.getMaxDamage() - remainingResult;
        if (damageResult < 0) {
            damageResult = 0;
        }
        ItemStack result = new ItemStack((ItemLike)a.getItem());
        result.setDamageValue(damageResult);
        return result;
    }
}

